/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.Codec;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgClasses;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.rdm.DomainTypes;
import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBase;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgType;
import com.refinitiv.eta.valueadd.reactor.ConsumerRole;
import com.refinitiv.eta.valueadd.reactor.ConsumerWatchlistOptions;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.WlDirectoryHandler;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlItemHandler;
import com.refinitiv.eta.valueadd.reactor.WlLoginHandler;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlStream;
import com.refinitiv.eta.valueadd.reactor.WorkerEventTypes;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;

class Watchlist
extends VaNode {
    ReactorChannel _reactorChannel;
    Reactor _reactor;
    ConsumerRole _role;
    ConsumerWatchlistOptions _watchlistOptions;
    WlLoginHandler _loginHandler;
    WlDirectoryHandler _directoryHandler;
    WlItemHandler _itemHandler;
    int _nextStreamId;
    int _nextProviderStreamId;
    HashMap<WlInteger, WlRequest> _streamIdtoWlRequestTable;
    HashMap<WlInteger, WlStream> _streamIdtoWlStreamTable;
    EncodeIterator _eIter = CodecFactory.createEncodeIterator();
    DecodeIterator _dIter = CodecFactory.createDecodeIterator();
    LinkedList<WlStream> _streamTimeoutInfoList = new LinkedList();
    EncodeIterator _streamEncodeIterator = CodecFactory.createEncodeIterator();
    int _numOutstandingPosts;
    Buffer _tempBuffer1 = CodecFactory.createBuffer();
    ByteBuffer _tempByteBuffer1;
    Buffer _tempBuffer2 = CodecFactory.createBuffer();
    ByteBuffer _tempByteBuffer2;
    Msg _tempMsg = CodecFactory.createMsg();
    WlInteger _tempWlInteger = ReactorFactory.createWlInteger();
    ReactorChannelInfo _reactorChannelInfo = ReactorFactory.createReactorChannelInfo();
    ReactorChannelInfo _reactorChnlInfo = ReactorFactory.createReactorChannelInfo();

    Watchlist(ReactorChannel reactorChannel, ConsumerRole consumerRole) {
        this._reactorChannel = reactorChannel;
        this._reactor = this._reactorChannel.reactor();
        this._role = consumerRole;
        this._watchlistOptions = this._role.watchlistOptions();
        if (this._watchlistOptions.itemCountHint() > 0) {
            this._streamIdtoWlRequestTable = new HashMap(this._watchlistOptions.itemCountHint() + 10, 1.0f);
            this._streamIdtoWlStreamTable = new HashMap(this._watchlistOptions.itemCountHint() + 10, 1.0f);
        } else {
            this._streamIdtoWlRequestTable = new HashMap();
            this._streamIdtoWlStreamTable = new HashMap();
        }
        this._loginHandler = new WlLoginHandler(this);
        this._directoryHandler = new WlDirectoryHandler(this);
        this._itemHandler = new WlItemHandler(this);
        this._tempByteBuffer1 = ByteBuffer.allocate(8192);
        this._tempBuffer1.data(this._tempByteBuffer1);
        this._tempByteBuffer2 = ByteBuffer.allocate(8192);
        this._tempBuffer2.data(this._tempByteBuffer2);
    }

    HashMap<WlInteger, WlStream> streamIdtoWlStreamTable() {
        return this._streamIdtoWlStreamTable;
    }

    HashMap<WlInteger, WlRequest> streamIdtoWlRequestTable() {
        return this._streamIdtoWlRequestTable;
    }

    int submitMsg(Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        this._tempWlInteger.value(msg.streamId());
        WlRequest wlRequest = this._streamIdtoWlRequestTable.get(this._tempWlInteger);
        boolean isReissue = false;
        if (msg.msgClass() == 1) {
            int ret;
            if (submitOptions.serviceName() != null && ((RequestMsg)msg).msgKey().checkHasServiceId()) {
                return this._reactor.populateErrorInfo(errorInfo, -6, "Watchlist.submitMsg", "Cannot submit request with both service name and service id specified.");
            }
            if (wlRequest == null) {
                if (((RequestMsg)msg).checkNoRefresh()) {
                    return this._reactor.populateErrorInfo(errorInfo, -6, "Watchlist.submitMsg", "Cannot submit new item request to watchlist with NO_REFRESH flag set.");
                }
                wlRequest = ReactorFactory.createWlRequest();
                switch (msg.domainType()) {
                    case 1: {
                        wlRequest.handler(this._loginHandler);
                        break;
                    }
                    case 4: {
                        wlRequest.handler(this._directoryHandler);
                        break;
                    }
                    default: {
                        wlRequest.handler(this._itemHandler);
                        break;
                    }
                }
            } else {
                ret = this.validateReissue(wlRequest, (RequestMsg)msg, submitOptions, errorInfo);
                if (ret < 0) {
                    return ret;
                }
                isReissue = true;
            }
            if ((ret = wlRequest.handler().submitRequest(wlRequest, (RequestMsg)msg, isReissue, submitOptions, errorInfo)) >= 0) {
                wlRequest.requestMsg().clear();
                if (((RequestMsg)msg).checkHasBatch()) {
                    msg.copy((Msg)wlRequest.requestMsg(), 4063);
                } else {
                    msg.copy((Msg)wlRequest.requestMsg(), 4095);
                }
                if (!isReissue) {
                    WlInteger wlInteger = ReactorFactory.createWlInteger();
                    wlInteger.value(msg.streamId());
                    wlRequest.tableKey(wlInteger);
                    this._streamIdtoWlRequestTable.put(wlInteger, wlRequest);
                }
            } else if (!isReissue) {
                wlRequest.returnToPool();
            }
            return ret;
        }
        if (wlRequest != null) {
            return wlRequest.handler().submitMsg(wlRequest, msg, submitOptions, errorInfo);
        }
        if (msg.msgClass() != 5) {
            return this._reactor.populateErrorInfo(errorInfo, -6, "Watchlist.submitMsg", "Cannot submit message class " + MsgClasses.toString((int)msg.msgClass()) + " to watchlist before stream is opened with a REQUEST.");
        }
        return 0;
    }

    int submitMsg(MsgBase rdmMsg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        if (rdmMsg.domainType() != 1 && rdmMsg.domainType() != 4 && rdmMsg.domainType() != 5) {
            return this._reactor.populateErrorInfo(errorInfo, -6, "Watchlist.submitMsg", "Cannot submit domain type " + DomainTypes.toString((int)rdmMsg.domainType()) + " to watchlist as RDM message.");
        }
        this._tempMsg.clear();
        this.convertRDMToCodecMsg(rdmMsg, this._tempMsg);
        if (rdmMsg.domainType() == 5 && ((DictionaryMsg)rdmMsg).rdmMsgType() == DictionaryMsgType.REQUEST && submitOptions.serviceName() != null) {
            this._tempMsg.msgKey().flags(this._tempMsg.msgKey().flags() & 0xFFFFFFFE);
        }
        return this.submitMsg(this._tempMsg, submitOptions, errorInfo);
    }

    int validateReissue(WlRequest wlRequest, RequestMsg requestMsg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = 0;
        if (requestMsg.msgKey().checkHasServiceId()) {
            if (!wlRequest.requestMsg().msgKey().checkHasServiceId() || requestMsg.msgKey().serviceId() != wlRequest.requestMsg().msgKey().serviceId()) {
                ret = -6;
            }
        } else if (wlRequest.requestMsg().msgKey().checkHasServiceId()) {
            ret = -6;
        } else if (submitOptions.serviceName() == null) {
            if (wlRequest.streamInfo().serviceName() != null) {
                ret = -6;
            }
        } else if (!(wlRequest.requestMsg().domainType() == 1 || wlRequest.streamInfo().serviceName() != null && submitOptions.serviceName().equals(wlRequest.streamInfo().serviceName()))) {
            ret = -6;
        }
        if (ret < 0) {
            ret = this._reactor.populateErrorInfo(errorInfo, -6, "Watchlist.validateReissue", "Cannot change ServiceId or ServiceName on reissue.");
        }
        return ret;
    }

    int readMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        assert (wlStream != null);
        return wlStream.handler().readMsg(wlStream, dIter, msg, false, errorInfo);
    }

    int readMsgWSB(WlStream wlStream, ReactorChannel channel, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        StatusMsg status;
        assert (wlStream != null);
        boolean isActiveServer = false;
        int ret = wlStream.handler().readMsg(wlStream, dIter, msg, false, errorInfo);
        if (ret != 0) {
            return ret;
        }
        if (wlStream.domainType() >= 6) {
            if (channel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                isActiveServer = channel.isActiveServer;
            } else if (wlStream.wlService() != null && wlStream.wlService().rdmService() != null) {
                boolean bl = isActiveServer = channel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(wlStream.wlService().tableKey()) != null;
            }
        }
        if (isActiveServer && msg.msgClass() == 3 && msg.domainType() != 10 && (status = (StatusMsg)msg).checkHasState() && status.state().streamState() == 4) {
            wlStream._closeMsg.clear();
            wlStream._closeMsg.streamId(msg.streamId());
            for (int i = 0; i < channel.warmStandByHandlerImpl.channelList().size(); ++i) {
                ReactorChannel chnl = channel.warmStandByHandlerImpl.channelList().get(i);
                if (chnl == channel) continue;
                wlStream._submitOptions.clear();
                chnl.watchlist().submitMsg((Msg)wlStream._closeMsg, wlStream._submitOptions, errorInfo);
            }
        }
        return ret;
    }

    int dispatch(ReactorErrorInfo errorInfo) {
        int ret1 = this._loginHandler.dispatch(errorInfo);
        int ret2 = this._directoryHandler.dispatch(errorInfo);
        int ret3 = this._itemHandler.dispatch(errorInfo);
        if (ret1 < 0) {
            return ret1;
        }
        if (ret2 < 0) {
            return ret2;
        }
        if (ret3 < 0) {
            return ret3;
        }
        return 0;
    }

    int timeout(ReactorErrorInfo errorInfo) {
        int ret = 0;
        WlStream wlStream = this._streamTimeoutInfoList.poll();
        if (wlStream != null) {
            wlStream._addedToTimeOutList = false;
            ret = wlStream.timeout(errorInfo);
        }
        return ret;
    }

    void reactorChannel(ReactorChannel reactorChannel) {
        this._reactorChannel = reactorChannel;
        this._reactor = this._reactorChannel.reactor();
    }

    ReactorChannel reactorChannel() {
        return this._reactorChannel;
    }

    Reactor reactor() {
        return this._reactor;
    }

    void role(ConsumerRole role) {
        this._role = role;
        this._watchlistOptions = this._role.watchlistOptions();
    }

    ConsumerRole role() {
        return this._role;
    }

    ConsumerWatchlistOptions watchlistOptions() {
        return this._watchlistOptions;
    }

    int nextStreamId() {
        if (this._nextStreamId == Integer.MAX_VALUE) {
            this._nextStreamId = 0;
        }
        int nextStreamId = ++this._nextStreamId;
        this._tempWlInteger.value(nextStreamId);
        while (this._streamIdtoWlStreamTable.containsKey(this._tempWlInteger)) {
            nextStreamId = ++this._nextStreamId;
            this._tempWlInteger.value(nextStreamId);
        }
        return nextStreamId;
    }

    int nextProviderStreamId() {
        if (this._nextProviderStreamId == Integer.MAX_VALUE) {
            this._nextProviderStreamId = 0;
        }
        int nextProviderStreamId = ++this._nextProviderStreamId;
        this._tempWlInteger.value(-nextProviderStreamId);
        while (this._streamIdtoWlRequestTable.containsKey(this._tempWlInteger)) {
            nextProviderStreamId = ++this._nextProviderStreamId;
            this._tempWlInteger.value(-nextProviderStreamId);
        }
        return -nextProviderStreamId;
    }

    WlLoginHandler loginHandler() {
        return this._loginHandler;
    }

    WlDirectoryHandler directoryHandler() {
        return this._directoryHandler;
    }

    WlItemHandler itemHandler() {
        return this._itemHandler;
    }

    int numOutstandingPosts() {
        return this._numOutstandingPosts;
    }

    void numOutstandingPosts(int numOutstandingPosts) {
        this._numOutstandingPosts = numOutstandingPosts;
    }

    void channelDown() {
        this._loginHandler.channelDown();
        this._directoryHandler.deleteAllServices(true);
    }

    void channelUp(ReactorErrorInfo errorInfo) {
        this._loginHandler.channelUp(errorInfo);
        this._directoryHandler.channelUp(errorInfo);
        this._itemHandler.channelUp(errorInfo);
    }

    int startWatchlistTimer(long expireTime, WlStream wlStream, ReactorErrorInfo errorInfo) {
        if (!this._reactor.sendWorkerEvent(WorkerEventTypes.START_WATCHLIST_TIMER, this._reactorChannel, expireTime)) {
            this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, this._reactorChannel);
            this._reactorChannel.state(ReactorChannel.State.DOWN);
            this._reactor.sendAndHandleChannelEventCallback("Watchlist.startWatchlistTimer", 2, this._reactorChannel, errorInfo);
            return this._reactor.populateErrorInfo(errorInfo, -1, "Watchlist.startWatchlistTimer", "_reactor.sendWorkerEvent() failed");
        }
        this._streamTimeoutInfoList.add(wlStream);
        wlStream._addedToTimeOutList = true;
        return 0;
    }

    int convertRDMToCodecMsg(MsgBase rdmMsg, Msg msg) {
        int ret = 0;
        this._tempBuffer1.clear();
        this._tempByteBuffer1.clear();
        this._tempBuffer1.data(this._tempByteBuffer1);
        this._eIter.clear();
        this._eIter.setBufferAndRWFVersion(this._tempBuffer1, Codec.majorVersion(), Codec.minorVersion());
        ret = rdmMsg.encode(this._eIter);
        while (ret == -21) {
            this._tempByteBuffer1 = ByteBuffer.allocate(this._tempBuffer1.capacity() * 2);
            this._tempBuffer1.clear();
            this._tempBuffer1.data(this._tempByteBuffer1);
            this._eIter.clear();
            this._eIter.setBufferAndRWFVersion(this._tempBuffer1, Codec.majorVersion(), Codec.minorVersion());
            ret = rdmMsg.encode(this._eIter);
        }
        if (ret >= 0) {
            this._dIter.clear();
            this._dIter.setBufferAndRWFVersion(this._tempBuffer1, Codec.majorVersion(), Codec.minorVersion());
            ret = msg.decode(this._dIter);
        }
        return ret;
    }

    int convertCodecToRDMMsg(Msg msg, MsgBase rdmMsg) {
        int ret = 0;
        this._tempBuffer2.clear();
        this._tempByteBuffer2.clear();
        this._tempBuffer2.data(this._tempByteBuffer2);
        this._eIter.clear();
        this._eIter.setBufferAndRWFVersion(this._tempBuffer2, Codec.majorVersion(), Codec.minorVersion());
        ret = msg.encode(this._eIter);
        if (ret >= 0) {
            this._dIter.clear();
            this._dIter.setBufferAndRWFVersion(this._tempBuffer2, Codec.majorVersion(), Codec.minorVersion());
            this._tempMsg.clear();
            this._tempMsg.decode(this._dIter);
            ret = rdmMsg.decode(this._dIter, this._tempMsg);
        }
        return ret;
    }

    boolean isRequestRecoverable(WlRequest wlRequest, int streamState) {
        boolean supportSingleOpen = this.reactor().reactorHandlesWarmStandby(this.reactorChannel()) ? true : this.loginHandler().supportSingleOpen();
        return !wlRequest.requestMsg().checkPrivateStream() && (wlRequest.requestMsg().domainType() != 5 || wlRequest.state() != WlRequest.State.OPEN) && supportSingleOpen && streamState == 3;
    }

    void closeWlRequest(WlRequest wlRequest) {
        assert (wlRequest.state() != WlRequest.State.RETURN_TO_POOL);
        this._tempWlInteger.value(wlRequest.requestMsg().streamId());
        WlRequest removedRequest = this._streamIdtoWlRequestTable.remove(this._tempWlInteger);
        assert (removedRequest == wlRequest);
    }

    public void close() {
        this.clear();
        this.returnToPool();
    }

    int changeServiceNameToID(MsgKey msgKey, String serviceName, ReactorErrorInfo errorInfo) {
        if (msgKey.checkHasServiceId()) {
            return this._reactor.populateErrorInfo(errorInfo, -6, "Watchlist.changeServiceNameToID", "Message submitted with both service name and service ID.");
        }
        int serviceId = this._directoryHandler.serviceId(serviceName);
        if (serviceId < 0) {
            return this._reactor.populateErrorInfo(errorInfo, -6, "Watchlist.changeServiceNameToID", "Message submitted with unknown service name " + serviceName + ".");
        }
        msgKey.applyHasServiceId();
        msgKey.serviceId(serviceId);
        return 0;
    }

    void clear() {
        this._reactorChannel = null;
        this._reactor = null;
        this._role = null;
        this._watchlistOptions = null;
        this._nextStreamId = 0;
        this._loginHandler.clear();
        this._directoryHandler.clear();
        this._itemHandler.clear();
        this._eIter.clear();
        this._dIter.clear();
        this._tempMsg.clear();
        this._tempWlInteger.clear();
        this._streamTimeoutInfoList.clear();
        this._streamIdtoWlRequestTable.clear();
        this._streamIdtoWlStreamTable.clear();
        this._reactorChannelInfo.clear();
        this._reactorChnlInfo.clear();
    }

    @Override
    public void returnToPool() {
        this._reactorChannel = null;
        this._reactor = null;
        this._role = null;
        this._watchlistOptions = null;
        this._loginHandler.clear();
        this._directoryHandler.clear();
        this._itemHandler.clear();
        super.returnToPool();
    }
}

