/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointInfo;
import com.refinitiv.eta.valueadd.reactor.RestAuthOptions;
import com.refinitiv.eta.valueadd.reactor.RestCallback;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestEvent;
import com.refinitiv.eta.valueadd.reactor.RestReactor;
import com.refinitiv.eta.valueadd.reactor.RestReactorOptions;
import com.refinitiv.eta.valueadd.reactor.RestRequest;
import com.refinitiv.eta.valueadd.reactor.RestResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;

class RestClient
implements Runnable,
RestCallback {
    static final String EDP_RT_TRANSPORT = "transport";
    static final String EDP_RT_DATAFORMAT = "dataformat";
    static final String EDP_RT_TRANSPORT_PROTOCOL_WEBSOCKET = "websocket";
    static final String EDP_RT_TRANSPORT_PROTOCOL_TCP = "tcp";
    static final String EDP_RT_DATAFORMAT_PROTOCOL_RWF = "rwf";
    static final String EDP_RT_DATAFORMAT_PROTOCOL_JSON2 = "tr_json2";
    static final String EDP_RT_SD_SERVICES = "services";
    static final String EDP_RT_SD_ENDPOINT = "endpoint";
    static final String EDP_RT_SD_PORT = "port";
    static final String EDP_RT_SD_LOCATION = "location";
    static final String EDP_RT_SD_DATAFORMAT = "dataFormat";
    static final String EDP_RT_SD_PROVIDER = "provider";
    static final String EDP_RT_SD_TRANSPORT = "transport";
    RestReactor _restReactor;
    private RestReactorOptions _restReactorOptions;
    private List<ReactorServiceEndpointInfo> _reactorServiceEndpointInfoList;

    RestClient(RestReactorOptions restReactorOpt, ReactorErrorInfo errorInfo) {
        this._restReactorOptions = restReactorOpt;
        this._restReactor = new RestReactor(this._restReactorOptions, errorInfo);
        this._reactorServiceEndpointInfoList = new ArrayList<ReactorServiceEndpointInfo>();
        new Thread(this).start();
    }

    int getAuthAccessTokenInfo(RestAuthOptions authOptions, RestConnectOptions connectOptions, ReactorAuthTokenInfo authTokenInfo, boolean isBlocking, ReactorErrorInfo errorInfo) {
        int ret = 0;
        try {
            ret = isBlocking ? this._restReactor.submitAuthRequestBlocking(authOptions, connectOptions, authTokenInfo, errorInfo) : this._restReactor.submitAuthRequest(authOptions, connectOptions, authTokenInfo, errorInfo);
        }
        catch (IOException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestClient.getAuthAccessTokenInfo", "Failed to send REST request. exception: " + RestReactor.getExceptionCause(e));
        }
        return ret;
    }

    int getServiceDiscovery(RestConnectOptions connectOptions, ReactorAuthTokenInfo authTokenInfo, boolean isBlocking, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, ReactorErrorInfo errorInfo) {
        RestRequest restRequest = RestClient.createRestRequestForServiceDiscovery(connectOptions.transport(), connectOptions.dataFormat());
        int ret = 0;
        try {
            ret = isBlocking ? this._restReactor.submitServiceDiscoveryRequestBlocking(restRequest, connectOptions, authTokenInfo, reactorServiceEndpointInfoList, errorInfo) : this._restReactor.submitRequestForServiceDiscovery(restRequest, connectOptions, authTokenInfo, reactorServiceEndpointInfoList, errorInfo);
        }
        catch (IOException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestClient.connectBlocking", "Failed to send REST request. exception: " + RestReactor.getExceptionCause(e));
        }
        return ret;
    }

    @Override
    public int RestResponseCallback(RestResponse response, RestEvent event) {
        ReactorChannel reactorChannel = (ReactorChannel)event.resultClosure().userSpecObj();
        if (reactorChannel.reactor().isShutdown()) {
            return 0;
        }
        switch (event.eventType()) {
            case 0: {
                if (response.jsonObject() == null) break;
                RestClient.parseServiceDiscovery(response, reactorChannel.reactorServiceEndpointInfoList());
                if (reactorChannel == null) break;
                reactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.RECEIVED_ENDPOINT_INFO);
                if (reactorChannel.state() != ReactorChannel.State.EDP_RT) break;
                reactorChannel.state(ReactorChannel.State.EDP_RT_DONE);
                break;
            }
            case 1: 
            case 3: {
                if (reactorChannel == null) break;
                String errorText = "failed to get endpoints from the service discovery";
                if (response.jsonObject() != null) {
                    errorText = "Failed REST request for the service discovery. Text: " + response.jsonObject().toString();
                }
                event.errorInfo().error().text("Failed REST request from HTTP status code " + response.statusCode() + ". Text: " + errorText);
                reactorChannel.reactor().populateErrorInfo(reactorChannel.getEDPErrorInfo(), -1, "RestClient.RestResponseCallback", "Failed REST request with text: " + errorText);
                reactorChannel.reactor().sendChannelWarningEvent(reactorChannel, reactorChannel.getEDPErrorInfo());
                if (reactorChannel.state() == ReactorChannel.State.EDP_RT) {
                    if (event.eventType() == 3) {
                        reactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.STOP_QUERYING_SERVICE_DISCOVERY);
                    } else {
                        reactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.REQ_FAILURE_FOR_SERVICE_DISCOVERY);
                    }
                    reactorChannel.state(ReactorChannel.State.EDP_RT_FAILED);
                }
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int RestErrorCallback(RestEvent event, String errorText) {
        ReactorChannel reactorChannel = (ReactorChannel)event.resultClosure().userSpecObj();
        if (reactorChannel.reactor().isShutdown()) {
            return 0;
        }
        RestReactor.populateErrorInfo(reactorChannel.getEDPErrorInfo(), -1, "RestHandler.failed", "Failed REST request for the service discovery. Text: " + errorText);
        reactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.REQ_FAILURE_FOR_SERVICE_DISCOVERY);
        reactorChannel.reactor().sendChannelWarningEvent(reactorChannel, reactorChannel.getEDPErrorInfo());
        if (reactorChannel.state() == ReactorChannel.State.EDP_RT) {
            reactorChannel.state(ReactorChannel.State.EDP_RT_FAILED);
        }
        return 0;
    }

    static final RestRequest createRestRequestForServiceDiscovery(int transport, int dataformat) {
        RestRequest restRequest = new RestRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        switch (transport) {
            case 1: {
                map.put("transport", EDP_RT_TRANSPORT_PROTOCOL_TCP);
                break;
            }
            case 2: {
                map.put("transport", EDP_RT_TRANSPORT_PROTOCOL_WEBSOCKET);
                break;
            }
        }
        switch (dataformat) {
            case 1: {
                map.put(EDP_RT_DATAFORMAT, EDP_RT_DATAFORMAT_PROTOCOL_RWF);
                break;
            }
            case 2: {
                map.put(EDP_RT_DATAFORMAT, EDP_RT_DATAFORMAT_PROTOCOL_JSON2);
                break;
            }
        }
        restRequest.queryParameter(map);
        return restRequest;
    }

    @Override
    public void run() {
        if (this._restReactor == null || this._restReactor.isShutdown()) {
            return;
        }
        ReactorErrorInfo errorInfo = ReactorFactory.createReactorErrorInfo();
        if (this._restReactor.dispatch(errorInfo) != 0) {
            this._restReactor.shutdown(errorInfo);
        }
    }

    void shutdown() {
        ReactorErrorInfo errorInfo = ReactorFactory.createReactorErrorInfo();
        if (this._restReactor != null || !this._restReactor.isShutdown()) {
            this._restReactor.shutdown(errorInfo);
        }
    }

    public List<ReactorServiceEndpointInfo> reactorServiceEndpointInfo() {
        return this._reactorServiceEndpointInfoList;
    }

    static final void parseServiceDiscovery(RestResponse response, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList) {
        if (response.statusCode() == 200 && response.jsonObject() != null) {
            JSONArray arr = response.jsonObject().getJSONArray(EDP_RT_SD_SERVICES);
            reactorServiceEndpointInfoList.clear();
            for (int i = 0; i < arr.length(); ++i) {
                int l;
                ReactorServiceEndpointInfo serviceInfo = new ReactorServiceEndpointInfo();
                serviceInfo._endPoint = arr.getJSONObject(i).opt(EDP_RT_SD_ENDPOINT).toString();
                serviceInfo._port = arr.getJSONObject(i).opt(EDP_RT_SD_PORT).toString();
                serviceInfo._provider = arr.getJSONObject(i).opt(EDP_RT_SD_PROVIDER).toString();
                serviceInfo._transport = arr.getJSONObject(i).opt("transport").toString();
                for (l = 0; l < arr.getJSONObject(i).getJSONArray(EDP_RT_SD_LOCATION).length(); ++l) {
                    serviceInfo._locationList.add(arr.getJSONObject(i).getJSONArray(EDP_RT_SD_LOCATION).get(l).toString());
                }
                if (arr.getJSONObject(i).has(EDP_RT_SD_DATAFORMAT)) {
                    for (l = 0; l < arr.getJSONObject(i).getJSONArray(EDP_RT_SD_DATAFORMAT).length(); ++l) {
                        serviceInfo._dataFormatList.add(arr.getJSONObject(i).getJSONArray(EDP_RT_SD_DATAFORMAT).get(l).toString());
                    }
                }
                reactorServiceEndpointInfoList.add(serviceInfo);
            }
        }
    }
}

