/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.valueadd.reactor.ConnectOptionsInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorWSBService;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroup;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyServerInfo;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class ReactorWarmStandbyGroupImpl
implements ReactorWarmStandbyGroup {
    private ReactorWarmStandbyServerInfo startingActiveServer;
    ConnectOptionsInfo startingConnectOptionsInfo = new ConnectOptionsInfo();
    private List<ReactorWarmStandbyServerInfo> standbyServerList;
    List<ConnectOptionsInfo> standbyConnectOptionsInfoList;
    private int warmStandbyMode;
    boolean downloadConnectionConfig;
    HashMap<WlInteger, ReactorWSBService> _perServiceById = null;
    HashMap<Buffer, ReactorWSBService> _startupServiceNameList = null;
    List<ReactorWSBService> _updateServiceList;
    boolean sendQueueReqForAll = false;
    int sendReqQueueCount = 0;
    int currentStartingServerIndex = 0;
    int numOfClosingStandbyServers = 0;
    int downloadConfigActiveServer = 0;
    int directoryStreamId = 0;
    int closingStandbyCount;
    boolean startingServerIsDown = false;
    static final int REACTOR_WSB_STARTING_SERVER_INDEX = -1;

    public ReactorWarmStandbyGroupImpl() {
        this.startingActiveServer = new ReactorWarmStandbyServerInfo();
        this.clear();
    }

    @Override
    public void clear() {
        this.startingActiveServer.clear();
        if (this.standbyServerList == null) {
            this.standbyServerList = new LinkedList<ReactorWarmStandbyServerInfo>();
        }
        this.standbyServerList.clear();
        if (this._updateServiceList == null) {
            this._updateServiceList = new ArrayList<ReactorWSBService>();
        }
        this._updateServiceList.clear();
        if (this._perServiceById == null) {
            this._perServiceById = new HashMap();
        }
        Iterator<Map.Entry<WlInteger, ReactorWSBService>> iter = this._perServiceById.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next().getValue().returnToPool();
        }
        this._perServiceById.clear();
        if (this._startupServiceNameList == null) {
            this._startupServiceNameList = new HashMap();
        }
        if (this.standbyConnectOptionsInfoList == null) {
            this.standbyConnectOptionsInfoList = new ArrayList<ConnectOptionsInfo>();
        }
        this.standbyConnectOptionsInfoList.clear();
        Iterator<Map.Entry<Buffer, ReactorWSBService>> startupIter = this._startupServiceNameList.entrySet().iterator();
        while (startupIter.hasNext()) {
            startupIter.next().getValue().returnToPool();
        }
        this._startupServiceNameList.clear();
        this.warmStandbyMode = 1;
        this.sendQueueReqForAll = false;
        this.sendReqQueueCount = 0;
        this.currentStartingServerIndex = -1;
        this.numOfClosingStandbyServers = 0;
        this.downloadConfigActiveServer = 0;
        this.directoryStreamId = 0;
    }

    @Override
    public ReactorWarmStandbyServerInfo startingActiveServer() {
        return this.startingActiveServer;
    }

    @Override
    public List<ReactorWarmStandbyServerInfo> standbyServerList() {
        return this.standbyServerList;
    }

    @Override
    public int warmStandbyMode() {
        return this.warmStandbyMode;
    }

    @Override
    public void warmStandbyMode(int warmStandbyMode) {
        this.warmStandbyMode = warmStandbyMode;
    }

    void incrementClosingStandbyCount() {
        ++this.closingStandbyCount;
    }

    int closingStandbyCount() {
        return this.closingStandbyCount;
    }

    public void copy(ReactorWarmStandbyGroupImpl copyTo) {
        copyTo.clear();
        this.startingActiveServer.copy(copyTo.startingActiveServer);
        for (int i = 0; i < this.standbyServerList.size(); ++i) {
            ReactorWarmStandbyServerInfo standbyInfo = new ReactorWarmStandbyServerInfo();
            this.standbyServerList.get(i).copy(standbyInfo);
            copyTo.standbyServerList.add(standbyInfo);
        }
        copyTo.warmStandbyMode = this.warmStandbyMode;
        copyTo.downloadConnectionConfig = this.downloadConnectionConfig;
    }
}

