/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialEventCallback;
import java.nio.ByteBuffer;

public class ReactorOAuthCredential {
    private Buffer _userName = CodecFactory.createBuffer();
    private Buffer _password = CodecFactory.createBuffer();
    private Buffer _clientId = CodecFactory.createBuffer();
    private Buffer _clientSecret = CodecFactory.createBuffer();
    private Buffer _audience = CodecFactory.createBuffer();
    private Buffer _clientJwk = CodecFactory.createBuffer();
    private Buffer _tokenScope = CodecFactory.createBuffer();
    private boolean _takeExclusiveSignOnControl = true;
    private ReactorOAuthCredentialEventCallback _oAuthCredentialEventCallback;
    Object _userSpecObj = null;

    ReactorOAuthCredential() {
        this.clear();
    }

    public void clear() {
        this._userName.clear();
        this._password.clear();
        this._clientId.clear();
        this._clientSecret.clear();
        this._audience.clear();
        this._clientJwk.clear();
        this._tokenScope.data("trapi.streaming.pricing.read");
        this._takeExclusiveSignOnControl = true;
        this._oAuthCredentialEventCallback = null;
    }

    public Buffer userName() {
        return this._userName;
    }

    public void userName(Buffer userName) {
        assert (userName != null) : "userName can not be null";
        this._userName.data(userName.data(), userName.position(), userName.length());
    }

    public Buffer password() {
        return this._password;
    }

    public void password(Buffer password) {
        assert (password != null) : "password can not be null";
        this._password.data(password.data(), password.position(), password.length());
    }

    public Buffer clientId() {
        return this._clientId;
    }

    public void clientId(Buffer clientId) {
        assert (clientId != null) : "clientId can not be null";
        this._clientId.data(clientId.data(), clientId.position(), clientId.length());
    }

    public Buffer clientSecret() {
        return this._clientSecret;
    }

    public void clientSecret(Buffer clientSecret) {
        assert (clientSecret != null) : "clientSecret can not be null";
        this._clientSecret.data(clientSecret.data(), clientSecret.position(), clientSecret.length());
    }

    public Buffer clientJwk() {
        return this._clientJwk;
    }

    public void clientJwk(Buffer clientJwk) {
        assert (clientJwk != null) : "clientJwk can not be null";
        this._clientJwk.data(clientJwk.data(), clientJwk.position(), clientJwk.length());
    }

    public Buffer audience() {
        return this._audience;
    }

    public void audience(Buffer audience) {
        assert (audience != null) : "audience can not be null";
        this._audience.data(audience.data(), audience.position(), audience.length());
    }

    public Buffer tokenScope() {
        return this._tokenScope;
    }

    public void tokenScope(Buffer tokenScope) {
        assert (tokenScope != null) : "tokenScope can not be null";
        this._tokenScope.data(tokenScope.data(), tokenScope.position(), tokenScope.length());
    }

    public boolean takeExclusiveSignOnControl() {
        return this._takeExclusiveSignOnControl;
    }

    public void takeExclusiveSignOnControl(boolean takeExclusiveSignOnControl) {
        this._takeExclusiveSignOnControl = takeExclusiveSignOnControl;
    }

    public void reactorOAuthCredentialEventCallback(ReactorOAuthCredentialEventCallback oAuthCredentialEventCallback) {
        this._oAuthCredentialEventCallback = oAuthCredentialEventCallback;
    }

    public ReactorOAuthCredentialEventCallback reactorOAuthCredentialEventCallback() {
        return this._oAuthCredentialEventCallback;
    }

    public int userSpecObj(Object userSpecObj) {
        if (userSpecObj == null) {
            return -5;
        }
        this._userSpecObj = userSpecObj;
        return 0;
    }

    public Object userSpecObj() {
        return this._userSpecObj;
    }

    public int copy(ReactorOAuthCredential destReactorOAuthCredential) {
        ByteBuffer byteBuffer;
        assert (destReactorOAuthCredential != null) : "destReactorOAuthCredential must be non-null";
        if (destReactorOAuthCredential == null) {
            return -1;
        }
        if (this._userName.length() != 0) {
            byteBuffer = ByteBuffer.allocate(this._userName.length());
            this._userName.copy(byteBuffer);
            destReactorOAuthCredential.userName().data(byteBuffer);
        }
        if (this._password.length() != 0) {
            byteBuffer = ByteBuffer.allocate(this._password.length());
            this._password.copy(byteBuffer);
            destReactorOAuthCredential.password().data(byteBuffer);
        }
        if (this._clientId.length() != 0) {
            byteBuffer = ByteBuffer.allocate(this._clientId.length());
            this._clientId.copy(byteBuffer);
            destReactorOAuthCredential.clientId().data(byteBuffer);
        }
        if (this._clientSecret.length() != 0) {
            byteBuffer = ByteBuffer.allocate(this._clientSecret.length());
            this._clientSecret.copy(byteBuffer);
            destReactorOAuthCredential.clientSecret().data(byteBuffer);
        }
        if (this._clientJwk.length() != 0) {
            byteBuffer = ByteBuffer.allocate(this._clientJwk.length());
            this._clientJwk.copy(byteBuffer);
            destReactorOAuthCredential.clientJwk().data(byteBuffer);
        }
        if (this._audience.length() != 0) {
            byteBuffer = ByteBuffer.allocate(this._audience.length());
            this._audience.copy(byteBuffer);
            destReactorOAuthCredential.audience().data(byteBuffer);
        }
        if (this._tokenScope.length() != 0) {
            byteBuffer = ByteBuffer.allocate(this._tokenScope.length());
            this._tokenScope.copy(byteBuffer);
            destReactorOAuthCredential.tokenScope().data(byteBuffer);
        }
        destReactorOAuthCredential._takeExclusiveSignOnControl = this._takeExclusiveSignOnControl;
        destReactorOAuthCredential._oAuthCredentialEventCallback = this._oAuthCredentialEventCallback;
        destReactorOAuthCredential._userSpecObj = this._userSpecObj;
        return 0;
    }
}

