/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.GenericMsg;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueDataExpired;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsgType;
import com.refinitiv.eta.valueadd.reactor.QueueMsgImpl;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamUtil;
import java.nio.ByteBuffer;

class QueueDataExpiredImpl
extends QueueMsgImpl
implements QueueDataExpired {
    final int QUEUE_DATA_EXPIRED_OPCODE = 4;
    int _type;
    GenericMsg _genericMsg = (GenericMsg)CodecFactory.createMsg();
    Buffer _destName = CodecFactory.createBuffer();
    Buffer _sourceName = CodecFactory.createBuffer();
    Buffer _tempBuffer = CodecFactory.createBuffer();
    Buffer _dataBuffer = CodecFactory.createBuffer();
    int _containerType;
    int _undeliverableCode;
    Buffer _tempBuffer2 = CodecFactory.createBuffer();
    long _timeout = -1L;
    int _flags;
    int _queueDepth;

    QueueDataExpiredImpl() {
    }

    @Override
    public QueueMsgType rdmMsgType() {
        return QueueMsgType.DATAEXPIRED;
    }

    @Override
    public int encode(EncodeIterator eIter) {
        int ret = 0;
        this._genericMsg.clear();
        this._genericMsg.msgClass(7);
        this._genericMsg.streamId(this.streamId());
        this._genericMsg.domainType(this._domainType);
        this._genericMsg.containerType(this._containerType);
        this._genericMsg.applyHasExtendedHdr();
        this._genericMsg.applyMessageComplete();
        this._genericMsg.applyHasSeqNum();
        this._genericMsg.seqNum((long)this._seqNum);
        this._genericMsg.applyHasMsgKey();
        this._genericMsg.msgKey().applyHasName();
        this._genericMsg.msgKey().name().data(this._destName.data(), this._destName.position(), this._destName.length());
        ret = this._genericMsg.encodeInit(eIter, 0);
        if (ret != 12) {
            return ret;
        }
        ret = eIter.encodeNonRWFInit(this._tempBuffer);
        if (ret != 0) {
            return ret;
        }
        if (this._tempBuffer.length() < 2 + this._sourceName.length() + 2 + 1 + 8 + 1 + 8) {
            return -21;
        }
        this._tempBuffer.data().put((byte)4);
        TunnelStreamUtil.writeResBit15(0, this._tempBuffer.data());
        this._tempBuffer.data().put((byte)this._sourceName.length());
        int tmpPos = this._sourceName.data().position();
        int tmpLimit = this._sourceName.data().limit();
        this._tempBuffer.data().put(this._sourceName.data());
        this._sourceName.data().position(tmpPos);
        this._sourceName.data().limit(tmpLimit);
        int encodedLengthPos = this._tempBuffer.data().position();
        this._tempBuffer.data().position(encodedLengthPos + 1);
        ret = TunnelStreamUtil.writeLong64ls(this._identifier, this._tempBuffer.data());
        if (ret != 0) {
            return ret;
        }
        assert (this._tempBuffer.data().position() - (encodedLengthPos + 1) <= 255);
        this._tempBuffer.data().put(encodedLengthPos, (byte)(this._tempBuffer.data().position() - (encodedLengthPos + 1)));
        this._tempBuffer.data().put((byte)this._undeliverableCode);
        this._tempBuffer.data().putShort((short)this._queueDepth);
        ret = eIter.encodeNonRWFComplete(this._tempBuffer, true);
        if (ret != 0) {
            return ret;
        }
        ret = this._genericMsg.encodeExtendedHeaderComplete(eIter, true);
        if (ret != 13) {
            return ret;
        }
        ret = eIter.encodeNonRWFInit(this._tempBuffer2);
        if (ret != 0) {
            return ret;
        }
        tmpPos = this._dataBuffer.data().position();
        tmpLimit = this._dataBuffer.data().limit();
        this._dataBuffer.data().limit(this._dataBuffer.position() + this._dataBuffer.length());
        this._dataBuffer.data().position(this._dataBuffer.position());
        this._tempBuffer2.data().put(this._dataBuffer.data());
        this._dataBuffer.data().limit(tmpLimit);
        this._dataBuffer.data().position(tmpPos);
        ret = eIter.encodeNonRWFComplete(this._tempBuffer2, true);
        if (ret != 0) {
            return ret;
        }
        ret = this._genericMsg.encodeComplete(eIter, true);
        if (ret != 0) {
            return ret;
        }
        return 0;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        GenericMsg genericMsg = (GenericMsg)msg;
        try {
            if (!genericMsg.checkHasExtendedHdr()) {
                return -26;
            }
            ByteBuffer tmpByteBuf = genericMsg.extendedHeader().data();
            int tmpPos = tmpByteBuf.position();
            int tmpLimit = tmpByteBuf.limit();
            tmpByteBuf.position(genericMsg.extendedHeader().position());
            this._opCode = tmpByteBuf.get();
            this._flags = TunnelStreamUtil.readResBit15(tmpByteBuf);
            this.streamId(msg.streamId());
            this.domainType(msg.domainType());
            if (!genericMsg.checkHasMsgKey()) {
                return -26;
            }
            if (!genericMsg.msgKey().checkHasName()) {
                return -26;
            }
            if (!genericMsg.checkHasSeqNum()) {
                return -26;
            }
            this._destName.data(genericMsg.msgKey().name().data(), genericMsg.msgKey().name().position(), genericMsg.msgKey().name().length());
            this._dataBuffer.data(genericMsg.encodedDataBody().data(), genericMsg.encodedDataBody().position(), genericMsg.encodedDataBody().length());
            this._containerType = genericMsg.containerType();
            this._seqNum = (int)genericMsg.seqNum();
            int msgLength = tmpByteBuf.get() & 0xFF;
            this._sourceName.data(tmpByteBuf, tmpByteBuf.position(), msgLength);
            tmpByteBuf.position(tmpByteBuf.position() + msgLength);
            msgLength = 0;
            msgLength = tmpByteBuf.get() & 0xFF;
            this._identifier = TunnelStreamUtil.readLong64ls(msgLength, tmpByteBuf);
            this._undeliverableCode = tmpByteBuf.get() & 0xFF;
            this._queueDepth = tmpByteBuf.getShort();
            tmpByteBuf.limit(tmpLimit);
            tmpByteBuf.position(tmpPos);
            return 0;
        }
        catch (Exception e) {
            return -26;
        }
    }

    @Override
    public void containerType(int containerType) {
        this._containerType = containerType;
    }

    @Override
    public int containerType() {
        return this._containerType;
    }

    @Override
    public void identifier(long identifier) {
        this._identifier = identifier;
    }

    @Override
    public long identifier() {
        return this._identifier;
    }

    @Override
    public void undeliverableCode(int undeliverableCode) {
        this._undeliverableCode = undeliverableCode;
    }

    @Override
    public int undeliverableCode() {
        return this._undeliverableCode;
    }

    @Override
    public Buffer sourceName() {
        return this._sourceName;
    }

    @Override
    public Buffer destName() {
        return this._destName;
    }

    @Override
    public void encodedDataBody(Buffer data) {
        this._dataBuffer.data(data.data(), data.position(), data.length());
    }

    @Override
    public Buffer encodedDataBody() {
        return this._dataBuffer;
    }

    @Override
    public void flags(int flags) {
        this._flags = flags;
    }

    @Override
    public int flags() {
        return this._flags;
    }

    @Override
    public boolean checkPossibleDuplicate() {
        return (this.flags() & 1) != 0;
    }

    @Override
    public void queueDepth(int queueDepth) {
        this._queueDepth = queueDepth;
    }

    @Override
    public int queueDepth() {
        return this._queueDepth;
    }

    @Override
    public void clear() {
        this._identifier = 0L;
        this._opCode = 4;
        this._sourceName.clear();
        this._destName.clear();
        this._identifier = 0L;
        this._timeout = -1L;
        this._dataBuffer.clear();
        this._flags = 0;
        this._queueDepth = 0;
    }
}

