/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import java.nio.ByteBuffer;
import java.util.List;

public interface LoginConnectionConfig {
    public int copy(LoginConnectionConfig var1);

    public void clear();

    public long numStandbyServers();

    public void numStandbyServers(long var1);

    public void serverList(List<ServerInfo> var1);

    public List<ServerInfo> serverList();

    public static class ServerInfoFlags {
        public static final int NONE = 0;
        public static final int HAS_LOAD_FACTOR = 1;
        public static final int HAS_TYPE = 2;
    }

    public static class ServerInfo {
        private int flags = 0;
        private long serverIndex = 0L;
        private Buffer hostName;
        private long port;
        private long loadFactor = 65535L;
        private int serverType = 1;
        private static final String eol = System.getProperty("line.separator");
        private static final String tab = "\t";
        private StringBuilder stringBuf = new StringBuilder();

        public ServerInfo() {
            this.hostName = CodecFactory.createBuffer();
        }

        public void flags(int flags) {
            this.flags = flags;
        }

        public int flags() {
            return this.flags;
        }

        public int copy(ServerInfo destServerInfo) {
            assert (destServerInfo != null) : "destServerInfo can not be null";
            destServerInfo.flags(this.flags);
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.hostName.length());
            this.hostName.copy(byteBuffer);
            destServerInfo.hostName().data(byteBuffer);
            destServerInfo.port(this.port);
            destServerInfo.serverIndex(this.serverIndex);
            if (this.checkHasLoadFactor()) {
                destServerInfo.loadFactor(this.loadFactor);
            }
            if (this.checkHasType()) {
                destServerInfo.serverType(this.serverType);
            }
            return 0;
        }

        public String toString() {
            this.stringBuf.setLength(0);
            this.stringBuf.append(tab);
            this.stringBuf.append("Server:");
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("hostName: ");
            this.stringBuf.append(this.hostName().toString());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("port: ");
            this.stringBuf.append(this.port());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("serverIndex: ");
            this.stringBuf.append(this.serverIndex());
            this.stringBuf.append(eol);
            if (this.checkHasLoadFactor()) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("loadFactor: ");
                this.stringBuf.append(this.loadFactor());
                this.stringBuf.append(eol);
            }
            if (this.checkHasType()) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("serverType: ");
                this.stringBuf.append(this.serverType());
                this.stringBuf.append(eol);
            }
            return this.stringBuf.toString();
        }

        int copyReferences(ServerInfo srcServerInfo) {
            assert (srcServerInfo != null) : "srcServerInfo can not be null";
            this.hostName().data(srcServerInfo.hostName().data(), srcServerInfo.hostName().position(), srcServerInfo.hostName().length());
            this.flags(srcServerInfo.flags());
            if (srcServerInfo.checkHasLoadFactor()) {
                this.loadFactor(srcServerInfo.loadFactor());
            }
            if (srcServerInfo.checkHasType()) {
                this.serverType(srcServerInfo.serverType());
            }
            this.port(srcServerInfo.port());
            this.serverIndex(srcServerInfo.serverIndex());
            return 0;
        }

        public void clear() {
            this.hostName.clear();
            this.port = 0L;
            this.loadFactor = 65535L;
            this.serverType = 1;
            this.serverIndex = 0L;
        }

        public Buffer hostName() {
            return this.hostName;
        }

        public void hostName(Buffer hostName) {
            assert (hostName != null) : "hostName can not be null";
            this.hostName().data(hostName.data(), hostName.position(), hostName.length());
        }

        public long port() {
            return this.port;
        }

        public void port(long port) {
            this.port = port;
        }

        public long loadFactor() {
            return this.loadFactor;
        }

        public void loadFactor(long loadFactor) {
            assert (this.checkHasLoadFactor());
            this.loadFactor = loadFactor;
        }

        public void applyHasLoadFactor() {
            this.flags |= 1;
        }

        public boolean checkHasLoadFactor() {
            return (this.flags & 1) != 0;
        }

        public int serverType() {
            return this.serverType;
        }

        public void serverType(int serverType) {
            assert (this.checkHasType());
            this.serverType = serverType;
        }

        public void applyHasType() {
            this.flags |= 2;
        }

        public boolean checkHasType() {
            return (this.flags & 2) != 0;
        }

        public void serverIndex(long serverIndex) {
            this.serverIndex = serverIndex;
        }

        public long serverIndex() {
            return this.serverIndex;
        }
    }
}

