/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.directory;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Map;
import com.refinitiv.eta.codec.MapEntry;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryRefresh;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.Service;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.ServiceImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class DirectoryRefreshImpl
extends MsgBaseImpl {
    private List<Service> serviceList = new ArrayList<Service>();
    private long sequenceNumber;
    private int serviceId;
    private long filter;
    private int flags;
    private State state;
    private static final String eol = "\n";
    private static final String tab = "\t";
    private Map map = CodecFactory.createMap();
    private MapEntry mEntry = CodecFactory.createMapEntry();
    private UInt tmpUInt = CodecFactory.createUInt();
    private RefreshMsg refreshMsg = (RefreshMsg)CodecFactory.createMsg();

    DirectoryRefreshImpl() {
        this.state = CodecFactory.createState();
    }

    @Override
    public void clear() {
        super.clear();
        this.serviceList.clear();
        this.sequenceNumber = 0L;
        this.serviceId = 0;
        this.filter = 0L;
        this.flags = 0;
        this.state.clear();
        this.state.streamState(1);
        this.state.dataState(1);
        this.state.code(0);
    }

    public State state() {
        return this.state;
    }

    public void state(State state) {
        this.state().streamState(state.streamState());
        this.state().dataState(state.dataState());
        this.state().code(state.code());
        this.state().text(state.text());
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    private Service service(int serviceId) {
        for (Service service : this.serviceList) {
            if (service.serviceId() != serviceId) continue;
            return service;
        }
        return null;
    }

    public List<Service> serviceList() {
        return this.serviceList;
    }

    public void serviceList(List<Service> serviceList) {
        assert (serviceList != null) : "serviceList must be non-null";
        this.serviceList().clear();
        for (Service service : serviceList) {
            this.serviceList().add(service);
        }
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        RefreshMsg refreshMsg;
        this.clear();
        if (msg.msgClass() != 2) {
            return -1;
        }
        this.streamId(msg.streamId());
        MsgKey msgKey = msg.msgKey();
        if (msgKey != null) {
            if (msgKey.checkHasFilter()) {
                this.filter(msg.msgKey().filter());
            }
            if (msgKey.checkHasServiceId()) {
                this.applyHasServiceId();
                this.serviceId(msgKey.serviceId());
            }
        }
        if ((refreshMsg = (RefreshMsg)msg).checkSolicited()) {
            this.applySolicited();
        }
        if (refreshMsg.checkClearCache()) {
            this.applyClearCache();
        }
        this.state().streamState(refreshMsg.state().streamState());
        this.state().dataState(refreshMsg.state().dataState());
        this.state().code(refreshMsg.state().code());
        if (refreshMsg.state().text().length() > 0) {
            Buffer text = refreshMsg.state().text();
            this.state.text().data(text.data(), text.position(), text.length());
        }
        if (refreshMsg.checkHasSeqNum()) {
            this.applyHasSequenceNumber();
            this.sequenceNumber(refreshMsg.seqNum());
        }
        if (msg.containerType() != 137) {
            return -1;
        }
        return this.decodeServiceList(dIter);
    }

    private int encodeServiceList(EncodeIterator encIter) {
        this.map.clear();
        this.map.flags(0);
        this.map.keyPrimitiveType(4);
        this.map.containerType(135);
        int ret = this.map.encodeInit(encIter, 0, 0);
        if (ret != 0) {
            return ret;
        }
        for (Service service : this.serviceList()) {
            this.mEntry.clear();
            this.mEntry.flags(0);
            this.mEntry.action(service.action());
            this.tmpUInt.value(service.serviceId());
            ret = this.mEntry.encodeInit(encIter, this.tmpUInt, 0);
            if (ret != 0) {
                return ret;
            }
            if (this.mEntry.action() != 3 && (ret = service.encode(encIter)) != 0) {
                return ret;
            }
            ret = this.mEntry.encodeComplete(encIter, true);
            if (ret == 0) continue;
            return ret;
        }
        return this.map.encodeComplete(encIter, true);
    }

    private int decodeServiceList(DecodeIterator dIter) {
        int ret = 0;
        ret = this.map.decode(dIter);
        if (ret < 0) {
            return ret;
        }
        if (this.map.containerType() != 135 || this.map.keyPrimitiveType() != 4) {
            return -1;
        }
        Service service = null;
        while ((ret = this.mEntry.decode(dIter, (Object)this.tmpUInt)) != 14) {
            if (ret != 0 && ret != 15) {
                return ret;
            }
            service = this.service((int)this.tmpUInt.toLong());
            if (service == null) {
                service = new ServiceImpl();
                service.serviceId((int)this.tmpUInt.toLong());
                this.serviceList.add(service);
            }
            if (this.mEntry.action() != 3 && (ret = service.decode(dIter)) != 0) {
                return ret;
            }
            service.action(this.mEntry.action());
        }
        return 0;
    }

    public int copy(DirectoryRefresh destRefreshMsg) {
        assert (destRefreshMsg != null) : "destRefreshMsg must be non-null";
        destRefreshMsg.streamId(this.streamId());
        destRefreshMsg.filter(this.filter());
        destRefreshMsg.state().streamState(this.state().streamState());
        destRefreshMsg.state().dataState(this.state().dataState());
        destRefreshMsg.state().code(this.state().code());
        if (this.checkClearCache()) {
            destRefreshMsg.applyClearCache();
        }
        if (this.checkSolicited()) {
            destRefreshMsg.applySolicited();
        }
        if (this.state().text().length() > 0) {
            Buffer stateText = CodecFactory.createBuffer();
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.state().text().length());
            this.state().text().copy(byteBuffer);
            stateText.data(byteBuffer);
            destRefreshMsg.state().text(stateText);
        }
        if (this.checkHasServiceId()) {
            destRefreshMsg.applyHasServiceId();
            destRefreshMsg.serviceId(this.serviceId());
        }
        if (this.checkHasSequenceNumber()) {
            destRefreshMsg.applyHasSequenceNumber();
            destRefreshMsg.sequenceNumber(this.sequenceNumber());
        }
        int ret = 0;
        for (Service rdmService : this.serviceList()) {
            ServiceImpl destRDMService;
            ret = rdmService.copy(destRDMService = new ServiceImpl());
            if (ret != 0) {
                return ret;
            }
            destRefreshMsg.serviceList().add(destRDMService);
        }
        return 0;
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        int ret;
        this.refreshMsg.clear();
        this.refreshMsg.streamId(this.streamId());
        this.refreshMsg.containerType(137);
        this.refreshMsg.msgClass(2);
        this.refreshMsg.domainType(4);
        this.refreshMsg.applyHasMsgKey();
        this.refreshMsg.applyRefreshComplete();
        this.refreshMsg.state().dataState(this.state().dataState());
        this.refreshMsg.state().streamState(this.state().streamState());
        this.refreshMsg.state().code(this.state().code());
        this.refreshMsg.state().text(this.state().text());
        if (this.checkClearCache()) {
            this.refreshMsg.applyClearCache();
        }
        if (this.checkSolicited()) {
            this.refreshMsg.applySolicited();
        }
        this.refreshMsg.msgKey().applyHasFilter();
        this.refreshMsg.msgKey().filter(this.filter);
        if (this.checkHasServiceId()) {
            this.refreshMsg.msgKey().applyHasServiceId();
            this.refreshMsg.msgKey().serviceId(this.serviceId);
        }
        if (this.checkHasSequenceNumber()) {
            this.refreshMsg.applyHasSeqNum();
            this.refreshMsg.seqNum(this.sequenceNumber());
        }
        if ((ret = this.refreshMsg.encodeInit(encodeIter, 0)) != 13) {
            return ret;
        }
        ret = this.encodeServiceList(encodeIter);
        if (ret != 0) {
            return ret;
        }
        ret = this.refreshMsg.encodeComplete(encodeIter, true);
        if (ret != 0) {
            return ret;
        }
        return 0;
    }

    public long filter() {
        return this.filter;
    }

    public void filter(long filter) {
        this.filter = filter;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public void sequenceNumber(long sequenceNumber) {
        assert (this.checkHasSequenceNumber());
        this.sequenceNumber = sequenceNumber;
    }

    public boolean checkHasSequenceNumber() {
        return (this.flags & 4) != 0;
    }

    public void applyHasSequenceNumber() {
        this.flags |= 4;
    }

    public int serviceId() {
        return this.serviceId;
    }

    public void serviceId(int serviceId) {
        assert (this.checkHasServiceId());
        this.serviceId = serviceId;
    }

    public boolean checkHasServiceId() {
        return (this.flags & 1) != 0;
    }

    public void applyHasServiceId() {
        this.flags |= 1;
    }

    public boolean checkClearCache() {
        return (this.flags & 8) != 0;
    }

    public void applyClearCache() {
        this.flags |= 8;
    }

    public boolean checkSolicited() {
        return (this.flags & 2) != 0;
    }

    public void applySolicited() {
        this.flags |= 2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "DirectoryRefresh: \n");
        stringBuf.append(tab);
        stringBuf.append(this.state());
        stringBuf.append(eol);
        if (this.checkHasServiceId()) {
            stringBuf.append(tab);
            stringBuf.append("serviceId: ");
            stringBuf.append(this.serviceId());
            stringBuf.append(eol);
        }
        if (this.checkHasSequenceNumber()) {
            stringBuf.append(tab);
            stringBuf.append("sequenceNumber: ");
            stringBuf.append(this.sequenceNumber());
            stringBuf.append(eol);
        }
        stringBuf.append(tab);
        stringBuf.append("clearCache: ");
        stringBuf.append(this.checkClearCache());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("solicited: ");
        stringBuf.append(this.checkSolicited());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("filter: ");
        boolean addOr = false;
        long filter = this.filter();
        if ((filter & 1L) != 0L) {
            stringBuf.append("INFO");
            addOr = true;
        }
        if ((filter & 0x10L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("DATA");
            addOr = true;
        }
        if ((filter & 4L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("GROUP");
            addOr = true;
        }
        if ((filter & 0x20L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("LINK");
            addOr = true;
        }
        if ((filter & 8L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("LOAD");
            addOr = true;
        }
        if ((filter & 2L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("STATE");
            addOr = true;
        }
        stringBuf.append(eol);
        for (Service service : this.serviceList) {
            stringBuf.append(service.toString());
        }
        return stringBuf.toString();
    }

    @Override
    public int domainType() {
        return 4;
    }
}

