/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.common;

import com.refinitiv.eta.valueadd.common.VaConcurrentQueue;
import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.common.VaQueue;

public class VaPool {
    private VaQueue _queue;
    private boolean _debug;

    public VaPool() {
        this._queue = new VaQueue();
    }

    public VaPool(boolean useConcurrent) {
        this._queue = useConcurrent ? new VaConcurrentQueue() : new VaQueue();
    }

    public VaPool(boolean useConcurrent, boolean debug) {
        this._queue = useConcurrent ? new VaConcurrentQueue() : new VaQueue();
        this._debug = debug;
    }

    public void add(VaNode node) {
        if (this._debug) {
            this._queue.verifyQueue();
        }
        if (node.inPool()) {
            return;
        }
        if (node.pool() != this) {
            node.pool(this);
        }
        node.inPool(true);
        this._queue.add(node);
        if (this._debug) {
            this._queue.verifyQueue();
        }
    }

    public void updatePool(VaNode node) {
        node.pool(this);
    }

    public VaNode poll() {
        VaNode node;
        if (this._debug) {
            this._queue.verifyQueue();
        }
        if ((node = this._queue.poll()) != null) {
            node.inPool(false);
        }
        if (this._debug) {
            this._queue.verifyQueue();
        }
        return node;
    }

    public int size() {
        return this._queue.size();
    }
}

