/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorTokenSession;
import java.util.HashMap;
import java.util.Map;

class RestAuthOptions {
    public static final int NONE = 0;
    public static final int HAS_USERNAME = 1;
    public static final int HAS_PASSWORD = 2;
    public static final int HAS_CLIENT_ID = 4;
    public static final int HAS_TOKEN_SCOPE = 8;
    public static final int HAS_GRANT_TYPE = 16;
    public static final int HAS_HEADER_ATTRIB = 32;
    public static final int HAS_REFRESH_TOKEN = 64;
    public static final int HAS_NEW_PASSWORD = 128;
    public static final int HAS_CLIENT_SECRET = 256;
    public static final int HAS_CLIENT_JWK = 512;
    public static final int HAS_AUDIENCE = 1024;
    private int _flags;
    private String _username;
    private String _password;
    private String _newPassword;
    private boolean _takeExclusiveSignOnControl;
    private String _clientId;
    private String _tokenScope = "trapi.streaming.pricing.read";
    private String _clientSecret;
    private String _clientJwk;
    private String _audience;
    private String _grantType = "password";
    private HashMap<String, String> _headerAttribute;
    private ReactorTokenSession _tokenSession;

    public RestAuthOptions(boolean takeExclusiveSignOnControl) {
        this.clear();
        this._takeExclusiveSignOnControl = takeExclusiveSignOnControl;
    }

    public RestAuthOptions(ReactorTokenSession tokenSession) {
        this.clear();
        this._tokenSession = tokenSession;
        this._takeExclusiveSignOnControl = tokenSession.oAuthCredential().takeExclusiveSignOnControl();
    }

    public RestAuthOptions clear() {
        this._flags = 0;
        this._username = "";
        this._password = "";
        this._newPassword = "";
        this._clientJwk = "";
        this._takeExclusiveSignOnControl = true;
        this._clientId = "";
        this._tokenScope = "trapi.streaming.pricing.read";
        this._clientSecret = "";
        this._clientJwk = "";
        this._audience = "";
        this._grantType = "password";
        this._headerAttribute = null;
        this._tokenSession = null;
        return this;
    }

    public RestAuthOptions clearSensitiveInfo() {
        this._password = "";
        this._flags &= 0xFFFFFFFD;
        this._newPassword = "";
        this._flags &= 0xFFFFFF7F;
        this._clientSecret = "";
        this._flags &= 0xFFFFFEFF;
        this._clientJwk = "";
        this._flags &= 0xFFFFFDFF;
        return this;
    }

    public RestAuthOptions username(String username) {
        if (username != null && !username.isEmpty()) {
            this._username = username;
            this._flags |= 1;
        }
        return this;
    }

    public String username() {
        return this._username;
    }

    public RestAuthOptions password(String password) {
        if (password != null && !password.isEmpty()) {
            this._password = password;
            this._flags |= 2;
        }
        return this;
    }

    public String password() {
        return this._password;
    }

    public RestAuthOptions newPassword(String newPassword) {
        if (newPassword != null && !newPassword.isEmpty()) {
            this._newPassword = newPassword;
            this._flags |= 2;
        }
        return this;
    }

    public String newPassword() {
        return this._newPassword;
    }

    public RestAuthOptions clientJwk(String clientJwk) {
        if (clientJwk != null && !clientJwk.isEmpty()) {
            this._clientJwk = clientJwk;
            this._flags |= 0x200;
        }
        return this;
    }

    public String clientJwk() {
        return this._clientJwk;
    }

    public RestAuthOptions audience(String audience) {
        if (audience != null && !audience.isEmpty()) {
            this._audience = audience;
            this._flags |= 0x400;
        }
        return this;
    }

    public String audience() {
        return this._audience;
    }

    public RestAuthOptions grantType(String grantType) {
        this._grantType = grantType;
        this._flags |= 0x10;
        return this;
    }

    public String grantType() {
        return this._grantType;
    }

    public boolean takeExclusiveSignOnControl() {
        return this._takeExclusiveSignOnControl;
    }

    public void takeExclusiveSignOnControl(boolean takeExclusiveSignOnControl) {
        this._takeExclusiveSignOnControl = takeExclusiveSignOnControl;
    }

    public String takeExclusiveSignOnControlAsString() {
        return this._takeExclusiveSignOnControl ? "true" : "false";
    }

    public RestAuthOptions clientId(String clientId) {
        if (clientId != null && !clientId.isEmpty()) {
            this._clientId = clientId;
            this._flags |= 4;
        }
        return this;
    }

    public String clientId() {
        return this._clientId;
    }

    public RestAuthOptions tokenScope(String tokenScope) {
        if (tokenScope != null && !tokenScope.isEmpty()) {
            this._tokenScope = tokenScope;
            this._flags |= 8;
        }
        return this;
    }

    public String tokenScope() {
        return this._tokenScope;
    }

    public RestAuthOptions clientSecret(String clientSecret) {
        if (clientSecret != null && !clientSecret.isEmpty()) {
            this._clientSecret = clientSecret;
            this._flags |= 0x100;
        }
        return this;
    }

    public String clientSecret() {
        return this._clientSecret;
    }

    public RestAuthOptions headerAttribute(Map<String, String> attributes) {
        this._headerAttribute = (HashMap)attributes;
        this._flags |= 0x20;
        return this;
    }

    public ReactorTokenSession tokenSession() {
        return this._tokenSession;
    }

    public Map<String, String> headerAttribute() {
        return this._headerAttribute;
    }

    public boolean hasUsername() {
        return (this._flags & 1) != 0;
    }

    public boolean hasPassword() {
        return (this._flags & 2) != 0;
    }

    public boolean hasNewPassword() {
        return (this._flags & 0x80) != 0;
    }

    public boolean hasGrantType() {
        return (this._flags & 0x10) != 0;
    }

    public boolean hasRefreshToken() {
        return (this._flags & 0x40) != 0;
    }

    public boolean hasClientId() {
        return (this._flags & 4) != 0;
    }

    public boolean hasClientSecret() {
        return (this._flags & 0x100) != 0;
    }

    public boolean hasTokenScope() {
        return (this._flags & 8) != 0;
    }

    public boolean hasHeaderAttribute() {
        return (this._flags & 0x20) != 0;
    }

    public boolean hasClientJwk() {
        return (this._flags & 0x200) != 0;
    }

    public boolean hasAudience() {
        return (this._flags & 0x400) != 0;
    }

    public String toString() {
        return "RestAuthOptions\n\tgrantType: " + this._grantType + "\n" + "\tusername: " + this._username + "\n" + "\tpassword: " + this._password + "\n" + "\tnewPassword: " + this._newPassword + "\n" + "\tclientSecret: " + this._clientSecret + "\n" + "\ttakeExclusiveSignOnControl: " + this._takeExclusiveSignOnControl + "\n" + "\tclientId: " + this._clientId + "\n" + "\ttokenScope: " + this._tokenScope + "\n" + "\theaderAttribute: " + this._headerAttribute == null ? "" : this._headerAttribute.toString() + "\n";
    }
}

