/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorDebuggerOptions;
import java.io.OutputStream;

class ReactorDebuggerOptionsImpl
implements ReactorDebuggerOptions {
    private volatile int _debuggingLevels = 0;
    OutputStream _outputStream;
    int _capacity;

    ReactorDebuggerOptionsImpl() {
    }

    @Override
    public void copy(ReactorDebuggerOptions dst) {
        if (dst != null) {
            dst.setDebuggingLevels(this._debuggingLevels);
            dst.outputStream(this._outputStream);
            dst.capacity(this._capacity);
        }
    }

    @Override
    public void setDebuggingLevels(int value) {
        this._debuggingLevels = value;
    }

    @Override
    public void enableLevel(int level) {
        if (level == 1 || level == 2 || level == 4) {
            this._debuggingLevels |= level;
        }
    }

    @Override
    public void disableLevel(int level) {
        if (level == 1 || level == 2 || level == 4) {
            this._debuggingLevels &= ~level;
        }
    }

    @Override
    public boolean debugConnectionLevel() {
        return (this._debuggingLevels & 1) != 0;
    }

    @Override
    public boolean debugEventQueueLevel() {
        return (this._debuggingLevels & 2) != 0;
    }

    @Override
    public boolean debugTunnelStreamLevel() {
        return (this._debuggingLevels & 4) != 0;
    }

    @Override
    public boolean debugEnabled() {
        return this._debuggingLevels != 0;
    }

    @Override
    public int debuggingLevels() {
        return this._debuggingLevels;
    }

    @Override
    public OutputStream outputStream() {
        return this._outputStream;
    }

    @Override
    public void outputStream(OutputStream outputStream) {
        this._outputStream = outputStream;
    }

    @Override
    public int capacity() {
        return this._capacity;
    }

    @Override
    public void capacity(int capacity) {
        this._capacity = capacity;
    }

    @Override
    public void clear() {
        this._debuggingLevels = 0;
        this._outputStream = null;
        this._capacity = 0;
    }
}

