/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginAttrib;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class LoginAttribImpl
implements LoginAttrib {
    private int flags;
    private long singleOpen;
    private long allowSuspectData;
    private Buffer applicationId;
    private Buffer applicationName;
    private Buffer position;
    private long providePermissionExpressions;
    private long providePermissionProfile;
    private long supportProviderDictionaryDownload;
    private long supportConsumerRTTMonitoring;
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";
    private StringBuilder stringBuf = new StringBuilder();
    private static final String defaultApplicationId = "256";
    private static final String defaultApplicationName = "eta";
    private static String defaultPosition;

    LoginAttribImpl() {
        this.applicationId = CodecFactory.createBuffer();
        this.applicationName = CodecFactory.createBuffer();
        this.position = CodecFactory.createBuffer();
        try {
            defaultPosition = InetAddress.getLocalHost().getHostAddress() + "/" + InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            defaultPosition = "1.1.1.1/net";
        }
    }

    @Override
    public void flags(int flags) {
        this.flags = flags;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public void clear() {
        this.flags = 0;
        this.applicationId.clear();
        this.applicationName.clear();
        this.position.clear();
        this.providePermissionProfile = 1L;
        this.providePermissionExpressions = 1L;
        this.singleOpen = 1L;
        this.allowSuspectData = 1L;
        this.supportProviderDictionaryDownload = 0L;
        this.supportConsumerRTTMonitoring = 2L;
    }

    @Override
    public int copy(LoginAttrib destAttrib) {
        ByteBuffer byteBuffer;
        assert (destAttrib != null) : "destAttrib can not be null";
        destAttrib.flags(this.flags());
        if (this.checkHasAllowSuspectData()) {
            destAttrib.applyHasAllowSuspectData();
            destAttrib.allowSuspectData(this.allowSuspectData);
        }
        if (this.checkHasApplicationId()) {
            byteBuffer = ByteBuffer.allocate(this.applicationId.length());
            this.applicationId.copy(byteBuffer);
            destAttrib.applyHasApplicationId();
            destAttrib.applicationId().data(byteBuffer);
        }
        if (this.checkHasApplicationName()) {
            byteBuffer = ByteBuffer.allocate(this.applicationName.length());
            this.applicationName.copy(byteBuffer);
            destAttrib.applyHasApplicationName();
            destAttrib.applicationName().data(byteBuffer);
        }
        if (this.checkHasPosition()) {
            byteBuffer = ByteBuffer.allocate(this.position.length());
            this.position.copy(byteBuffer);
            destAttrib.applyHasPosition();
            destAttrib.position().data(byteBuffer);
        }
        if (this.checkHasProvidePermissionExpressions()) {
            destAttrib.applyHasProvidePermissionExpressions();
            destAttrib.providePermissionExpressions(this.providePermissionExpressions);
        }
        if (this.checkHasProvidePermissionProfile()) {
            destAttrib.applyHasProvidePermissionProfile();
            destAttrib.providePermissionProfile(this.providePermissionProfile);
        }
        if (this.checkHasSingleOpen()) {
            destAttrib.applyHasSingleOpen();
            destAttrib.singleOpen(this.singleOpen);
        }
        if (this.checkHasProviderSupportDictionaryDownload()) {
            destAttrib.applyHasProviderSupportDictionaryDownload();
            destAttrib.supportProviderDictionaryDownload(this.supportProviderDictionaryDownload);
        }
        if (this.checkHasSupportRoundTripLatencyMonitoring()) {
            destAttrib.applyHasSupportRoundTripLatencyMonitoring();
            destAttrib.supportRTTMonitoring(this.supportConsumerRTTMonitoring);
        }
        return 0;
    }

    public String toString() {
        this.stringBuf.setLength(0);
        if (this.checkHasApplicationId()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("applicationId: ");
            this.stringBuf.append(this.applicationId().toString());
            this.stringBuf.append(eol);
        }
        if (this.checkHasApplicationName()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("applicationName: ");
            this.stringBuf.append(this.applicationName().toString());
            this.stringBuf.append(eol);
        }
        if (this.checkHasPosition()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("position: ");
            this.stringBuf.append(this.position());
            this.stringBuf.append(eol);
        }
        if (this.checkHasProvidePermissionProfile()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("providePermissionProfile: ");
            this.stringBuf.append(this.providePermissionProfile());
            this.stringBuf.append(eol);
        }
        if (this.checkHasProvidePermissionExpressions()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("providePermissionExpressions: ");
            this.stringBuf.append(this.providePermissionExpressions());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSingleOpen()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("singleOpen: ");
            this.stringBuf.append(this.singleOpen());
            this.stringBuf.append(eol);
        }
        if (this.checkHasAllowSuspectData()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("allowSuspectData: ");
            this.stringBuf.append(this.allowSuspectData());
            this.stringBuf.append(eol);
        }
        if (this.checkHasProviderSupportDictionaryDownload()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("providerSupportDictionaryDownload: ");
            this.stringBuf.append(this.supportProviderDictionaryDownload());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportRoundTripLatencyMonitoring()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("RoundTripLatency: ");
            this.stringBuf.append(this.supportRTTMonitoring());
            this.stringBuf.append(eol);
        }
        return this.stringBuf.toString();
    }

    void initDefaultAttrib() {
        this.applyHasApplicationId();
        this.applicationId().data(defaultApplicationId);
        this.applyHasApplicationName();
        this.applicationName().data(defaultApplicationName);
        this.applyHasPosition();
        this.position().data(defaultPosition);
    }

    @Override
    public Buffer applicationId() {
        return this.applicationId;
    }

    @Override
    public void applyHasApplicationId() {
        this.flags |= 2;
    }

    @Override
    public boolean checkHasApplicationId() {
        return (this.flags & 2) != 0;
    }

    @Override
    public Buffer applicationName() {
        return this.applicationName;
    }

    @Override
    public void applyHasApplicationName() {
        this.flags |= 4;
    }

    @Override
    public boolean checkHasApplicationName() {
        return (this.flags & 4) != 0;
    }

    @Override
    public Buffer position() {
        return this.position;
    }

    @Override
    public void applyHasPosition() {
        this.flags |= 8;
    }

    @Override
    public boolean checkHasPosition() {
        return (this.flags & 8) != 0;
    }

    @Override
    public long providePermissionProfile() {
        return this.providePermissionProfile;
    }

    @Override
    public void providePermissionProfile(long providePermissionProfile) {
        assert (this.checkHasProvidePermissionProfile());
        this.providePermissionProfile = providePermissionProfile;
    }

    @Override
    public void applyHasProvidePermissionProfile() {
        this.flags |= 0x40;
    }

    @Override
    public boolean checkHasProvidePermissionProfile() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public long providePermissionExpressions() {
        return this.providePermissionExpressions;
    }

    @Override
    public void providePermissionExpressions(long providePermissionExpressions) {
        assert (this.checkHasProvidePermissionExpressions());
        this.providePermissionExpressions = providePermissionExpressions;
    }

    @Override
    public void applyHasProvidePermissionExpressions() {
        this.flags |= 0x20;
    }

    @Override
    public boolean checkHasProvidePermissionExpressions() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public long singleOpen() {
        return this.singleOpen;
    }

    @Override
    public void singleOpen(long singleOpen) {
        assert (this.checkHasSingleOpen());
        this.singleOpen = singleOpen;
    }

    @Override
    public void applyHasSingleOpen() {
        this.flags |= 0x80;
    }

    @Override
    public boolean checkHasSingleOpen() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public long allowSuspectData() {
        return this.allowSuspectData;
    }

    @Override
    public void allowSuspectData(long allowSuspectData) {
        assert (this.checkHasAllowSuspectData());
        this.allowSuspectData = allowSuspectData;
    }

    @Override
    public void applyHasAllowSuspectData() {
        this.flags |= 1;
    }

    @Override
    public boolean checkHasAllowSuspectData() {
        return (this.flags & 1) != 0;
    }

    @Override
    public void applyHasProviderSupportDictionaryDownload() {
        this.flags |= 0x100;
    }

    @Override
    public boolean checkHasProviderSupportDictionaryDownload() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public void supportProviderDictionaryDownload(long supportProviderDictionaryDownload) {
        assert (this.checkHasProviderSupportDictionaryDownload());
        this.supportProviderDictionaryDownload = supportProviderDictionaryDownload;
    }

    @Override
    public long supportProviderDictionaryDownload() {
        return this.supportProviderDictionaryDownload;
    }

    @Override
    public boolean checkHasSupportRoundTripLatencyMonitoring() {
        return (this.flags & 0x4000) != 0;
    }

    @Override
    public void applyHasSupportRoundTripLatencyMonitoring() {
        this.flags |= 0x4000;
    }

    @Override
    public long supportRTTMonitoring() {
        return this.supportConsumerRTTMonitoring;
    }

    @Override
    public void supportRTTMonitoring(long supportConsumerRTTMonitoring) {
        assert (this.checkHasSupportRoundTripLatencyMonitoring());
        this.supportConsumerRTTMonitoring = supportConsumerRTTMonitoring;
    }

    void copyReferences(LoginAttrib srcLoginAttrib) {
        assert (srcLoginAttrib != null) : "srcLoginAttrib can not be null";
        this.flags(srcLoginAttrib.flags());
        if (srcLoginAttrib.checkHasAllowSuspectData()) {
            this.applyHasAllowSuspectData();
            this.allowSuspectData(srcLoginAttrib.allowSuspectData());
        }
        if (srcLoginAttrib.checkHasApplicationId()) {
            this.applyHasApplicationId();
            this.applicationId(srcLoginAttrib.applicationId());
        }
        if (srcLoginAttrib.checkHasApplicationName()) {
            this.applyHasApplicationName();
            this.applicationName(srcLoginAttrib.applicationName());
        }
        if (srcLoginAttrib.checkHasPosition()) {
            this.applyHasPosition();
            this.position(srcLoginAttrib.position());
        }
        if (srcLoginAttrib.checkHasProvidePermissionExpressions()) {
            this.applyHasProvidePermissionExpressions();
            this.providePermissionExpressions(srcLoginAttrib.providePermissionExpressions());
        }
        if (srcLoginAttrib.checkHasProvidePermissionProfile()) {
            this.applyHasProvidePermissionProfile();
            this.providePermissionProfile(srcLoginAttrib.providePermissionProfile());
        }
        if (srcLoginAttrib.checkHasSingleOpen()) {
            this.applyHasSingleOpen();
            this.singleOpen(srcLoginAttrib.singleOpen());
        }
        if (srcLoginAttrib.checkHasProviderSupportDictionaryDownload()) {
            this.applyHasProviderSupportDictionaryDownload();
            this.supportProviderDictionaryDownload(srcLoginAttrib.supportProviderDictionaryDownload());
        }
        if (srcLoginAttrib.checkHasSupportRoundTripLatencyMonitoring()) {
            this.applyHasSupportRoundTripLatencyMonitoring();
            this.supportRTTMonitoring(srcLoginAttrib.supportRTTMonitoring());
        }
    }

    @Override
    public void applicationId(Buffer applicationId) {
        assert (this.checkHasApplicationId()) : "application id flag should be set first";
        assert (applicationId != null) : "applicationId can not be null";
        this.applicationId().data(applicationId.data(), applicationId.position(), applicationId.length());
    }

    @Override
    public void applicationName(Buffer applicationName) {
        assert (this.checkHasApplicationName()) : "applicationName flag should be set first";
        assert (applicationName != null) : "applicationName can not be null";
        this.applicationName().data(applicationName.data(), applicationName.position(), applicationName.length());
    }

    @Override
    public void position(Buffer position) {
        assert (this.checkHasPosition()) : "position flag should be set first";
        assert (position != null) : "position can not be null";
        this.position().data(position.data(), position.position(), position.length());
    }
}

