/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.common;

import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.common.VaQueue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;

public class SelectableBiDirectionalQueue {
    int DEFAULT_BUFFER_SIZE = 2;
    SelectableBiDirectionalQueue _remote;
    VaQueue _writeQueue;
    VaQueue _readQueue;
    Pipe _writePipe;
    Pipe _readPipe;
    ByteBuffer _writeBuffer;
    ByteBuffer _readBuffer;
    Lock _writeLock;
    Lock _readLock;
    NotifiedState _writeNotifier;
    NotifiedState _readNotifier;
    volatile NotifiedState _shutdown;

    public SelectableBiDirectionalQueue() {
        try {
            this._writePipe = SelectorProvider.provider().openPipe();
            this._readPipe = SelectorProvider.provider().openPipe();
            this._writePipe.sink().configureBlocking(false);
            this._writePipe.source().configureBlocking(false);
            this._readPipe.sink().configureBlocking(false);
            this._readPipe.source().configureBlocking(false);
        }
        catch (IOException e) {
            System.out.println("SelectableBiDirectionalQueue.constructor: failed to create a Pipe, exception=" + e.getLocalizedMessage());
            return;
        }
        this._writeBuffer = ByteBuffer.allocateDirect(this.DEFAULT_BUFFER_SIZE);
        this._readBuffer = ByteBuffer.allocateDirect(this.DEFAULT_BUFFER_SIZE);
        this._writeQueue = new VaQueue();
        this._readQueue = new VaQueue();
        this._writeLock = new ReentrantLock();
        this._readLock = new ReentrantLock();
        this._writeNotifier = new NotifiedState();
        this._readNotifier = new NotifiedState();
        this._shutdown = new NotifiedState();
    }

    public boolean isShutDown() {
        return this._shutdown.isSet();
    }

    SelectableBiDirectionalQueue(SelectableBiDirectionalQueue sq) {
        this._writePipe = sq._readPipe;
        this._readPipe = sq._writePipe;
        this._writeBuffer = sq._readBuffer;
        this._readBuffer = sq._writeBuffer;
        this._writeQueue = sq._readQueue;
        this._readQueue = sq._writeQueue;
        this._writeLock = sq._readLock;
        this._readLock = sq._writeLock;
        this._writeNotifier = sq._readNotifier;
        this._readNotifier = sq._writeNotifier;
        this._shutdown = sq._shutdown;
    }

    public SelectableChannel readChannel() {
        return this._readPipe.source();
    }

    public int readQueueSize() {
        return this._readQueue.size();
    }

    public int writeQueueSize() {
        return this._writeQueue.size();
    }

    public VaNode read() {
        if (this._shutdown.isSet()) {
            return null;
        }
        VaNode node = null;
        this._readLock.lock();
        if (this._shutdown.isSet()) {
            this._readLock.unlock();
            return null;
        }
        try {
            node = this._readQueue.poll();
            if (node == null) {
                System.out.println("SelectableBiDirectionalQueue.read: node was unexpectedly null?");
            }
            if (this._readQueue.size() == 0) {
                this._readBuffer.clear();
                int cnt = this._readPipe.source().read(this._readBuffer);
                if (cnt == -1) {
                    System.out.println("SelectableBiDirectionalQueue.read: return returned -1");
                    this.shutdown();
                }
                this._readNotifier.clear();
            }
        }
        catch (IOException e) {
            System.out.println("SelectableBiDirectionalQueue.read: failed, execption=" + e.getLocalizedMessage());
            e.printStackTrace();
            this.shutdown();
        }
        finally {
            this._readLock.unlock();
        }
        return node;
    }

    public boolean write(VaNode node) {
        if (this._shutdown.isSet()) {
            return false;
        }
        this._writeLock.lock();
        if (this._shutdown.isSet()) {
            this._writeLock.unlock();
            return false;
        }
        try {
            this._writeQueue.add(node);
            if (!this._writeNotifier.isSet()) {
                this._writeNotifier.set();
                this._writeBuffer.clear();
                this._writeBuffer.put((byte)0);
                this._writeBuffer.flip();
                int cnt = this._writePipe.sink().write(this._writeBuffer);
                if (cnt != 1) {
                    System.out.println("SelectableBiDirectionalQueue.write: expected to write 1 byte but wrote " + cnt);
                    this.shutdown();
                }
            }
        }
        catch (IOException e) {
            System.out.println("SelectableBiDirectionalQueue.write: failed, execption=" + e.getLocalizedMessage() + " stacktrace=" + e.getStackTrace().toString());
            this.shutdown();
        }
        finally {
            this._writeLock.unlock();
        }
        return true;
    }

    public SelectableBiDirectionalQueue remote() {
        if (this._remote == null) {
            this._remote = new SelectableBiDirectionalQueue(this);
        }
        return this._remote;
    }

    public void shutdown() {
        if (!this._shutdown.isSet()) {
            this._shutdown.set();
            try {
                this._writePipe.sink().close();
                this._writePipe.source().close();
                this._readPipe.sink().close();
                this._readPipe.source().close();
                this._remote._writePipe.sink().close();
                this._remote._writePipe.source().close();
                this._remote._readPipe.sink().close();
                this._remote._readPipe.source().close();
                this._writeBuffer = null;
                this._writeNotifier = null;
                this._writePipe = null;
                this._writeQueue = null;
                this._readBuffer = null;
                this._readNotifier = null;
                this._readPipe = null;
                this._readQueue = null;
                this._remote._writeBuffer = null;
                this._remote._writeNotifier = null;
                this._remote._writePipe = null;
                this._remote._writeQueue = null;
                this._remote._readBuffer = null;
                this._remote._readNotifier = null;
                this._remote._readPipe = null;
                this._remote._readQueue = null;
            }
            catch (IOException e) {
                System.out.println("SelectableBiDirectionalQueue.shutdown: closing of pipes failed, execption=" + e.getLocalizedMessage() + " stacktrace=" + e.getStackTrace().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countNumberOfReadQueueElements(Predicate<VaNode> filter) {
        this._readLock.lock();
        try {
            int result = 0;
            for (VaNode current = this._readQueue._head; current != null; current = current.next()) {
                if (!filter.test(current)) continue;
                ++result;
            }
            int n = result;
            return n;
        }
        finally {
            this._readLock.unlock();
        }
    }

    class NotifiedState {
        boolean _notified = false;

        NotifiedState() {
        }

        public void set() {
            this._notified = true;
        }

        public boolean isSet() {
            return this._notified;
        }

        public void clear() {
            this._notified = false;
        }
    }
}

