/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.TunnelStreamBuffer;
import java.nio.ByteBuffer;

class SlicedBufferPool {
    static final int TUNNEL_STREAM_HDR_SIZE = 128;
    SliceableBufferList _bufferList = new SliceableBufferList();
    SliceableBufferList _userBufferList = new SliceableBufferList();
    SliceableBuffer _currentBuffer;
    SliceableBuffer _currentUserBuffer;
    int _maxMsgSize;
    int _maxNumUserBuffers;
    int _currentNumUserBuffers;
    int _currentNumUserBuffersByApplication;

    SlicedBufferPool(int maxMsgSize, int numBuffers) {
        this._maxMsgSize = maxMsgSize;
        this._maxNumUserBuffers = numBuffers;
    }

    int count() {
        return this._bufferList.count();
    }

    void getBufferSlice(TunnelStreamBuffer bufferImpl, int length, boolean isForUser) {
        if (!isForUser) {
            this.getBufferSlice(bufferImpl, length);
        } else {
            this.getUserBufferSlice(bufferImpl, length);
        }
    }

    void getBufferSlice(TunnelStreamBuffer bufferImpl, int length) {
        DuplicateBuffer duplicateBuffer;
        if (this._currentBuffer == null || this._currentBuffer._data.limit() - this._currentBuffer._position < length) {
            this._currentBuffer = this._bufferList.pop();
            if (this._currentBuffer == null) {
                this._currentBuffer = new SliceableBuffer();
            }
        }
        bufferImpl._duplicateBuffer = duplicateBuffer = this._currentBuffer.getDuplicate(false);
        bufferImpl.data(duplicateBuffer._data, this._currentBuffer._position, length);
        this._currentBuffer._position += length;
        ++this._currentBuffer._numSlicesInUse;
        bufferImpl._parentBuffer = this._currentBuffer;
        bufferImpl._isUserBuffer = false;
    }

    void getUserBufferSlice(TunnelStreamBuffer bufferImpl, int length) {
        boolean maxUserBuffersReached = false;
        if (this._currentUserBuffer != null && this._currentUserBuffer._position == 0) {
            ++this._currentNumUserBuffersByApplication;
        }
        if (this._currentUserBuffer == null || this._currentUserBuffer._data.limit() - this._currentUserBuffer._position < length) {
            this._currentUserBuffer = this._userBufferList.pop();
            if (this._currentUserBuffer != null && this._currentUserBuffer._position == 0) {
                ++this._currentNumUserBuffersByApplication;
            }
            if (this._currentUserBuffer == null || this._currentUserBuffer._data.limit() - this._currentUserBuffer._position < length) {
                if (this._currentNumUserBuffers < this._maxNumUserBuffers) {
                    this._currentUserBuffer = new SliceableBuffer();
                    ++this._currentNumUserBuffers;
                    ++this._currentNumUserBuffersByApplication;
                } else {
                    maxUserBuffersReached = true;
                }
            }
        }
        if (!maxUserBuffersReached) {
            DuplicateBuffer duplicateBuffer;
            bufferImpl._duplicateBuffer = duplicateBuffer = this._currentUserBuffer.getDuplicate(true);
            duplicateBuffer._data.position(this._currentUserBuffer._position);
            bufferImpl.data(duplicateBuffer._data, this._currentUserBuffer._position, length);
            this._currentUserBuffer._position += length;
            ++this._currentUserBuffer._numSlicesInUse;
            bufferImpl._parentBuffer = this._currentUserBuffer;
            bufferImpl._isUserBuffer = true;
        } else if (bufferImpl != null) {
            bufferImpl.data(null);
            if (bufferImpl._parentBuffer != null) {
                bufferImpl._parentBuffer._position = 0;
                bufferImpl._parentBuffer._data.clear();
                bufferImpl._parentBuffer = null;
            }
        }
    }

    void releaseBufferSlice(TunnelStreamBuffer bufferImpl) {
        SliceableBuffer parentBuffer = bufferImpl._parentBuffer;
        parentBuffer.releaseDuplicate(bufferImpl);
        if (--parentBuffer._numSlicesInUse == 0) {
            parentBuffer._position = 0;
            parentBuffer._data.clear();
            if (!bufferImpl._isUserBuffer && parentBuffer != this._currentBuffer) {
                this._bufferList.push(parentBuffer);
            } else if (bufferImpl._isUserBuffer && parentBuffer != this._currentUserBuffer) {
                this._userBufferList.push(parentBuffer);
            }
            if (bufferImpl._isUserBuffer) {
                --this._currentNumUserBuffersByApplication;
            }
        }
    }

    int getBuffersUsed() {
        return this._currentNumUserBuffersByApplication;
    }

    class DuplicateList {
        DuplicateBuffer _head;
        DuplicateBuffer _tail;
        private int _count;

        DuplicateList() {
        }

        void push(DuplicateBuffer buffer) {
            if (this._tail != null) {
                buffer._next = null;
                this._tail._next = buffer;
                this._tail = buffer;
            } else {
                this._head = this._tail = buffer;
                this._tail._next = null;
                this._head._next = null;
            }
            ++this._count;
        }

        DuplicateBuffer pop() {
            DuplicateBuffer retBuffer = null;
            if (this._head != null) {
                retBuffer = this._head;
                this._head = retBuffer._next;
                if (this._head == null) {
                    this._tail = null;
                }
                --this._count;
            }
            return retBuffer;
        }

        int count() {
            return this._count;
        }
    }

    class SliceableBufferList {
        SliceableBuffer _head;
        SliceableBuffer _tail;
        private int _count;

        SliceableBufferList() {
        }

        void push(SliceableBuffer buffer) {
            if (this._tail != null) {
                buffer._next = null;
                this._tail._next = buffer;
                this._tail = buffer;
            } else {
                this._head = this._tail = buffer;
                this._tail._next = null;
                this._head._next = null;
            }
            ++this._count;
        }

        SliceableBuffer pop() {
            SliceableBuffer retBuffer = null;
            if (this._head != null) {
                retBuffer = this._head;
                this._head = retBuffer._next;
                if (this._head == null) {
                    this._tail = null;
                }
                --this._count;
            }
            return retBuffer;
        }

        int count() {
            return this._count;
        }
    }

    class SliceableBuffer {
        ByteBuffer _data;
        int _position;
        int _numSlicesInUse;
        SliceableBuffer _next;
        DuplicateList _duplicateList;

        SliceableBuffer() {
            this._duplicateList = new DuplicateList();
            this._data = ByteBuffer.allocate(SlicedBufferPool.this._maxMsgSize + 128);
        }

        DuplicateBuffer getDuplicate(boolean isUserBuffer) {
            DuplicateBuffer duplicateBuffer = this._duplicateList.pop();
            if (duplicateBuffer != null) {
                duplicateBuffer._data.clear();
            } else {
                duplicateBuffer = new DuplicateBuffer();
                duplicateBuffer._data = !isUserBuffer ? SlicedBufferPool.this._currentBuffer._data.duplicate() : SlicedBufferPool.this._currentUserBuffer._data.duplicate();
            }
            return duplicateBuffer;
        }

        void releaseDuplicate(TunnelStreamBuffer bufferImpl) {
            this._duplicateList.push(bufferImpl._duplicateBuffer);
        }
    }

    class DuplicateBuffer {
        ByteBuffer _data;
        DuplicateBuffer _next;

        DuplicateBuffer() {
        }
    }
}

