/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueRequest;
import com.refinitiv.eta.valueadd.reactor.QueueMsgImpl;
import java.nio.ByteBuffer;

class QueueRequestImpl
extends QueueMsgImpl
implements QueueRequest {
    final int SUBSTREAM_REQUEST_CLIENT_OPCODE = 1;
    Msg _msg = CodecFactory.createMsg();
    RequestMsg _requestMsg = (RequestMsg)CodecFactory.createMsg();
    DecodeIterator _decIter = CodecFactory.createDecodeIterator();
    Buffer _tmpBuffer = CodecFactory.createBuffer();
    Buffer _sourceName = CodecFactory.createBuffer();
    Buffer _destName = CodecFactory.createBuffer();

    QueueRequestImpl() {
    }

    @Override
    public QueueMsgType rdmMsgType() {
        return QueueMsgType.REQUEST;
    }

    @Override
    public int encode(EncodeIterator eIter) {
        this._requestMsg.clear();
        this._requestMsg.msgClass(1);
        this._requestMsg.streamId(this.streamId());
        this._requestMsg.domainType(this.domainType());
        this._requestMsg.containerType(128);
        this._requestMsg.applyStreaming();
        this._requestMsg.applyHasExtendedHdr();
        this._requestMsg.msgKey().applyHasName();
        this._requestMsg.msgKey().name().data(this._sourceName.data());
        int ret = this._requestMsg.encodeInit(eIter, 0);
        if (ret < 0) {
            return ret;
        }
        ret = eIter.encodeNonRWFInit(this._tmpBuffer);
        if (ret != 0) {
            return ret;
        }
        if (this._tmpBuffer.length() < 9) {
            return -21;
        }
        this._tmpBuffer.data().put((byte)1);
        this._tmpBuffer.data().putInt(this._lastOutSeqNum);
        this._tmpBuffer.data().putInt(this._lastInSeqNum);
        ret = eIter.encodeNonRWFComplete(this._tmpBuffer, true);
        if (ret != 0) {
            return ret;
        }
        ret = this._requestMsg.encodeExtendedHeaderComplete(eIter, true);
        if (ret < 0) {
            return ret;
        }
        ret = this._requestMsg.encodeComplete(eIter, true);
        if (ret < 0) {
            return ret;
        }
        return 0;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        int startPos;
        this._opCode = 3;
        this.streamId(msg.streamId());
        this.domainType(msg.domainType());
        RequestMsg requestMsg = (RequestMsg)msg;
        if (!requestMsg.checkHasExtendedHdr() || requestMsg.extendedHeader().length() < 9) {
            return -26;
        }
        ByteBuffer extHdrByteBuf = requestMsg.extendedHeader().data();
        if (extHdrByteBuf.get(startPos = requestMsg.extendedHeader().position()) != 1) {
            return -26;
        }
        this._lastOutSeqNum = extHdrByteBuf.getInt(startPos + 1);
        this._lastInSeqNum = extHdrByteBuf.getInt(startPos + 1 + 4);
        this._sourceName.data(msg.msgKey().name().data(), msg.msgKey().name().position(), msg.msgKey().name().length());
        return 0;
    }

    @Override
    public Buffer sourceName() {
        return this._sourceName;
    }

    @Override
    public void sourceName(Buffer sourceName) {
        this._sourceName.data(sourceName.data(), sourceName.position(), sourceName.length());
    }

    @Override
    public void clear() {
        this._opCode = 3;
    }

    public int requestMsgBufferSize() {
        return 128 + this._sourceName.length();
    }
}

