/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.transport.Channel;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorOptions;
import java.util.Date;

class PingHandler {
    private volatile int _pingTimeoutRemote = 0;
    private volatile int _pingTimeoutLocal = 0;
    private volatile long _nextRemotePingTime = 0L;
    private volatile long _nextLocalPingTime = 0L;
    private volatile long _pingsReceived = 0L;
    private volatile long _pingsSent = 0L;
    private volatile boolean _receivedRemoteMsg = false;
    private volatile boolean _sentLocalMsg = false;
    private static boolean _trackPings = true;
    private StringBuilder xmlString = new StringBuilder(1500);
    ReactorOptions _reactorOptions;

    PingHandler() {
    }

    void receivedMsg() {
        this._receivedRemoteMsg = true;
    }

    void sentMsg() {
        this._sentLocalMsg = true;
    }

    void receivedPing() {
        if (_trackPings) {
            ++this._pingsReceived;
        }
    }

    void sentPing() {
        if (_trackPings) {
            ++this._pingsSent;
        }
    }

    void initPingHandler(int timeout) {
        this._pingTimeoutLocal = timeout / 3;
        this._pingTimeoutRemote = timeout;
        this._nextLocalPingTime = System.currentTimeMillis() + (long)(this._pingTimeoutLocal * 1000);
        this._nextRemotePingTime = System.currentTimeMillis() + (long)(this._pingTimeoutRemote * 1000);
    }

    public int handlePings(ReactorChannel reactorChannel, Error error) {
        long currentTime = System.currentTimeMillis();
        Channel chnl = reactorChannel.channel();
        if (currentTime >= this._nextLocalPingTime) {
            boolean isJSONProtocol;
            boolean bl = isJSONProtocol = chnl.protocolType() == 2;
            if (this._sentLocalMsg && !isJSONProtocol) {
                this._sentLocalMsg = false;
            } else {
                boolean sendPing = true;
                if (isJSONProtocol && !reactorChannel.sendPingMessage()) {
                    sendPing = false;
                }
                if (sendPing) {
                    int ret;
                    this._reactorOptions = reactorChannel.reactor().reactorOptions();
                    if (this._reactorOptions.xmlTracePing() && (this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile())) {
                        this.xmlString.setLength(0);
                        this.xmlString.append("\n<!-- Outgoing Ping message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
                        if (this._reactorOptions.xmlTracing()) {
                            System.out.println(this.xmlString);
                        }
                        if (this._reactorOptions.xmlTraceToFile()) {
                            reactorChannel.reactor()._fileDumper.dump(this.xmlString.toString());
                        }
                    }
                    if ((ret = chnl.ping(error)) < 0) {
                        return ret;
                    }
                    if (ret == 0) {
                        this.sentPing();
                    }
                }
            }
            this._nextLocalPingTime = currentTime + (long)(this._pingTimeoutLocal * 1000);
        }
        if (currentTime >= this._nextRemotePingTime) {
            if (this._receivedRemoteMsg) {
                this._receivedRemoteMsg = false;
                this._nextRemotePingTime = currentTime + (long)(this._pingTimeoutRemote * 1000);
            } else {
                error.text("Lost contact with connection...");
                return -1;
            }
        }
        return 0;
    }

    long getPingsReceived() {
        return this._pingsReceived;
    }

    long getPingsSent() {
        return this._pingsSent;
    }

    void trackPings(boolean trackPings) {
        _trackPings = trackPings;
    }

    void clear() {
        this._pingTimeoutRemote = 0;
        this._pingTimeoutLocal = 0;
        this._nextRemotePingTime = 0L;
        this._nextLocalPingTime = 0L;
        this._pingsReceived = 0L;
        this._pingsSent = 0L;
        this._receivedRemoteMsg = false;
        this._sentLocalMsg = false;
    }

    void resetAggregatedStats() {
        this._pingsReceived = 0L;
        this._pingsSent = 0L;
    }
}

