/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.common;

public class VaDoubleLinkList<T> {
    private T _head;
    private T _tail;
    private T _iter;
    private int _count;
    private static final boolean DEBUG_LIST = false;

    public VaDoubleLinkList() {
        this.clear();
    }

    public void clear() {
        this._head = null;
        this._tail = null;
        this._count = 0;
    }

    public int count() {
        return this._count;
    }

    public void push(T elem, Link<T> queueLink) {
        if (this._tail != null) {
            queueLink.setPrev(elem, this._tail);
            queueLink.setNext(this._tail, elem);
            this._tail = elem;
        } else {
            queueLink.setPrev(elem, null);
            this._tail = elem;
            this._head = this._tail;
        }
        queueLink.setNext(elem, null);
        ++this._count;
    }

    public void pushBack(T elem, Link<T> queueLink) {
        if (this._head != null) {
            queueLink.setNext(elem, this._head);
            queueLink.setPrev(this._head, elem);
            this._head = elem;
        } else {
            queueLink.setNext(elem, null);
            this._tail = elem;
            this._head = this._tail;
        }
        queueLink.setPrev(elem, null);
        ++this._count;
    }

    public void insertBefore(T thisBuffer, T newBuffer, Link<T> queueLink) {
        if (queueLink.getPrev(thisBuffer) != null) {
            queueLink.setNext(queueLink.getPrev(thisBuffer), newBuffer);
        }
        queueLink.setPrev(newBuffer, queueLink.getPrev(thisBuffer));
        queueLink.setNext(newBuffer, thisBuffer);
        queueLink.setPrev(thisBuffer, newBuffer);
        if (thisBuffer == this._head) {
            this._head = newBuffer;
        }
        ++this._count;
    }

    public void insertAfter(T thisBuffer, T newBuffer, Link<T> queueLink) {
        if (queueLink.getNext(thisBuffer) != null) {
            queueLink.setPrev(queueLink.getNext(thisBuffer), newBuffer);
        }
        queueLink.setNext(newBuffer, queueLink.getNext(thisBuffer));
        queueLink.setPrev(newBuffer, thisBuffer);
        queueLink.setNext(thisBuffer, newBuffer);
        if (thisBuffer == this._tail) {
            this._tail = newBuffer;
        }
        ++this._count;
    }

    public T peek() {
        return this._head;
    }

    public T peekTail() {
        return this._tail;
    }

    public T pop(Link<T> queueLink) {
        T head = this._head;
        if (head != null) {
            this.remove(head, queueLink);
        }
        return head;
    }

    public T start(Link<T> queueLink) {
        this._iter = this._head != null ? queueLink.getNext(this._head) : null;
        return this._head;
    }

    public T forth(Link<T> queueLink) {
        T iter = this._iter;
        if (this._iter != null) {
            this._iter = queueLink.getNext(this._iter);
        }
        return iter;
    }

    public void remove(T elem, Link<T> queueLink) {
        if (this._iter != null && elem == this._iter) {
            this._iter = queueLink.getNext(elem);
        }
        if (queueLink.getPrev(elem) != null) {
            queueLink.setNext(queueLink.getPrev(elem), queueLink.getNext(elem));
        } else {
            assert (this._head == elem);
            this._head = queueLink.getNext(elem);
        }
        if (queueLink.getNext(elem) != null) {
            queueLink.setPrev(queueLink.getNext(elem), queueLink.getPrev(elem));
        } else {
            assert (this._tail == elem);
            this._tail = queueLink.getPrev(elem);
        }
        queueLink.setNext(elem, null);
        queueLink.setPrev(elem, null);
        --this._count;
    }

    public void append(VaDoubleLinkList<T> otherList, Link<T> queueLink) {
        if (otherList._head == null) {
            return;
        }
        if (this._head != null) {
            queueLink.setNext(this._tail, otherList._head);
            queueLink.setPrev(otherList._head, this._tail);
            this._tail = otherList._tail;
        } else {
            this._head = otherList._head;
            this._tail = otherList._tail;
        }
        this._count += otherList._count;
        otherList._head = null;
        otherList._tail = null;
        otherList._count = 0;
    }

    void verifyList(Link<T> queueLink) {
        int i = 0;
        assert (this._count >= 0);
        T link = this._head;
        while (link != null) {
            ++i;
            if (queueLink.getNext(link) == null) assert (link == this._tail);
            link = queueLink.getNext(link);
        }
        assert (i == this._count);
    }

    public boolean contains(T elem, Link<T> queueLink) {
        T link = this._head;
        while (link != null) {
            if (link == elem) {
                return true;
            }
            link = queueLink.getNext(link);
        }
        return false;
    }

    public static interface Link<T> {
        public T getPrev(T var1);

        public void setPrev(T var1, T var2);

        public T getNext(T var1);

        public void setNext(T var1, T var2);
    }
}

