/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.cache;

import com.refinitiv.eta.codec.Codec;
import com.refinitiv.eta.codec.DataDictionary;
import com.refinitiv.eta.valueadd.cache.CacheDictLoadingHelper;
import com.refinitiv.eta.valueadd.cache.CacheError;
import com.refinitiv.eta.valueadd.cache.CacheErrorImpl;
import com.refinitiv.eta.valueadd.cache.CacheJNIBuffer;
import com.refinitiv.eta.valueadd.cache.PayloadCache;
import com.refinitiv.eta.valueadd.cache.PayloadCacheConfigOptions;
import com.refinitiv.eta.valueadd.cache.PayloadCursorImpl;
import com.refinitiv.eta.valueadd.cache.PayloadEntry;
import com.refinitiv.eta.valueadd.cache.PayloadEntryImpl;
import com.refinitiv.eta.valueadd.common.VaConcurrentQueue;
import com.refinitiv.eta.valueadd.common.VaIteratableQueue;
import com.refinitiv.eta.valueadd.common.VaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class PayloadCacheImpl
extends VaNode
implements PayloadCache {
    private static final int DICT_INCREASE_SIZE = 2000;
    private static final int DEFAULT_BUFFER_SIZE = 500;
    private static final int MAX_BUFFER_ARRAY_SIZE = 21;
    private static final int MAX_BUFFER_ARRAY_POS = 20;
    private static final int MAX_FIXED_BUFFER_SIZE = 10000;
    private static boolean _cacheInitialized = false;
    private static VaIteratableQueue _globalDictDbList = null;
    private static Lock _globalDictLock = new ReentrantLock();
    private static Lock _globalCacheLock = new ReentrantLock();
    private static VaConcurrentQueue _globalCacheList = new VaConcurrentQueue();
    private boolean _isCacheDestroyed = true;
    private VaIteratableQueue _cacheEntryList = null;
    private List<PayloadEntry> _appCacheEntryList = null;
    private String _dictKey = null;
    private boolean _dictKeyCleared = false;
    private long _etaCacheRef = 0L;
    private CacheDictLoadingHelper _dictLoadingHelper = null;
    private VaIteratableQueue[] _retrieveJNIBufferArray = new VaIteratableQueue[21];
    private VaIteratableQueue[] _applyJNIBufferArray = new VaIteratableQueue[21];
    private int _maxRetrieveJNIBufferArrayPos = 3;
    private int _maxApplyJNIBufferArrayPos = 3;

    public PayloadCacheImpl(long etaCacheInstance, PayloadCacheConfigOptions configOptions) {
        this._etaCacheRef = etaCacheInstance;
        this._cacheEntryList = new VaIteratableQueue();
        _globalCacheLock.lock();
        _globalCacheList.add((VaNode)this);
        _globalCacheLock.unlock();
        this._isCacheDestroyed = false;
        this.initializePooling();
    }

    public static PayloadCache create(PayloadCacheConfigOptions configOptions, CacheError error) {
        _globalCacheLock.lock();
        if (!_cacheInitialized) {
            if (PayloadCacheImpl.etaInitializeJNICache() == -1) {
                throw new UnsupportedOperationException("PayloadCacheImpl: JNI etaInitializeJNICache() failed.");
            }
            _cacheInitialized = true;
        }
        _globalCacheLock.unlock();
        long etaCacheInstance = PayloadCacheImpl.etaCreateCache(configOptions.maxItems(), error);
        if (etaCacheInstance != 0L) {
            return new PayloadCacheImpl(etaCacheInstance, configOptions);
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this._isCacheDestroyed) {
            return;
        }
        if (this._etaCacheRef != 0L) {
            int pos;
            this.destroyPayloadEntries();
            this.etaDestroyCache(this._etaCacheRef);
            CacheJNIBuffer buffer = null;
            VaIteratableQueue flexLenBufList = null;
            for (pos = 0; pos <= this._maxRetrieveJNIBufferArrayPos; ++pos) {
                flexLenBufList = this._retrieveJNIBufferArray[pos];
                flexLenBufList.rewind();
                while (flexLenBufList.hasNext()) {
                    buffer = (CacheJNIBuffer)flexLenBufList.next();
                    this.etaFreeRsslBuffer(buffer._etaBufferCPtr);
                }
            }
            for (pos = 0; pos <= this._maxApplyJNIBufferArrayPos; ++pos) {
                flexLenBufList = this._applyJNIBufferArray[pos];
                flexLenBufList.rewind();
                while (flexLenBufList.hasNext()) {
                    buffer = (CacheJNIBuffer)flexLenBufList.next();
                    this.etaFreeRsslBuffer(buffer._etaBufferCPtr);
                }
            }
        }
        _globalCacheLock.lock();
        _globalCacheList.remove((VaNode)this);
        if (_cacheInitialized && _globalCacheList.size() == 0) {
            this.uninitialize();
            PayloadCacheImpl.etaUninitializeJNICache();
            _cacheInitialized = false;
        }
        _globalCacheLock.unlock();
        this._isCacheDestroyed = true;
    }

    @Override
    public void destroyAll() {
        if (this._isCacheDestroyed) {
            return;
        }
        _globalCacheLock.lock();
        int cacheCount = _globalCacheList.size();
        if (cacheCount == 0) {
            _globalCacheLock.unlock();
            return;
        }
        while (cacheCount-- > 0) {
            PayloadCacheImpl cache = (PayloadCacheImpl)_globalCacheList.poll();
            _globalCacheLock.unlock();
            cache.destroy();
            _globalCacheLock.lock();
        }
        _globalCacheLock.unlock();
    }

    @Override
    public int setDictionary(DataDictionary fidDictionary, String dictionaryKey, CacheError error) {
        if (error == null) {
            throw new UnsupportedOperationException("PayloadCacheImpl.bindDictionary: error cannot be null, dictionary not bind.");
        }
        if (this._isCacheDestroyed) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -29, "PayloadCacheImpl.bindDictionary error: the cache instance has been destroyed.");
        }
        if (dictionaryKey == null || fidDictionary == null) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -22, "PayloadCacheImpl.bindDictionary error: dictionaryKey or fidDictionary cannot be null, dictionary not bind.");
        }
        if (this._dictLoadingHelper == null) {
            this._dictLoadingHelper = new CacheDictLoadingHelper();
            if (_globalDictDbList == null) {
                _globalDictDbList = new VaIteratableQueue();
            }
        }
        if (!this._dictKeyCleared && this._dictKey != null && !this._dictKey.equals(dictionaryKey)) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -22, "PayloadCacheImpl.bindDictionary error: not allow to reload dictonary with new key.");
        }
        if (!this.encodedFidDictBuf(fidDictionary)) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -1, "PayloadCacheImpl.bindDictionary error: unable to get encoded dictionary buffer.");
        }
        int bindRet = -1;
        long etaDictDbRef = 0L;
        KeyETADictRefMap globalDictDb = this.getDictDb(dictionaryKey);
        if (globalDictDb == null) {
            etaDictDbRef = this.etaCreateFIDDictionary(dictionaryKey);
            if (etaDictDbRef == 0L) {
                return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -1, "PayloadCacheImpl.bindDictionary error: unable to create eta dictonary with dictionaryKey.");
            }
            bindRet = this.etaLoadDictionaryFromBuffer(etaDictDbRef, this._dictLoadingHelper._dictEncodedBuf._etaBufferCPtr, this._dictLoadingHelper._dictEncodedBufWrap.length(), error);
            this.etaFreeRsslBuffer(this._dictLoadingHelper._dictEncodedBuf._etaBufferCPtr);
            if (bindRet < 0) {
                return bindRet;
            }
            globalDictDb = new KeyETADictRefMap(dictionaryKey, etaDictDbRef);
            _globalDictLock.lock();
            _globalDictDbList.add((VaNode)globalDictDb);
            _globalDictLock.unlock();
        } else {
            bindRet = this.etaLoadDictionaryFromBuffer(globalDictDb._etaDictRef, this._dictLoadingHelper._dictEncodedBuf._etaBufferCPtr, this._dictLoadingHelper._dictEncodedBufWrap.length(), error);
            this.etaFreeRsslBuffer(this._dictLoadingHelper._dictEncodedBuf._etaBufferCPtr);
            if (bindRet < 0) {
                return bindRet;
            }
            etaDictDbRef = globalDictDb._etaDictRef;
        }
        bindRet = this.etaSetFidDbWithCache(this._etaCacheRef, etaDictDbRef, dictionaryKey, error);
        if (bindRet < 0) {
            return bindRet;
        }
        if (this._dictKey == null || this._dictKeyCleared) {
            this._dictKey = globalDictDb._dictKey;
            this._dictKeyCleared = false;
        }
        return 0;
    }

    @Override
    public int setSharedDictionaryKey(String dictionaryKey, CacheError error) {
        if (error == null) {
            throw new UnsupportedOperationException("PayloadCacheImpl.bindDictionary: error cannot be null, dictionary not bind.");
        }
        if (dictionaryKey == null) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -22, "PayloadCacheImpl.bindSharedDictionaryKey error: dictionaryKey cannot be null, dictionary not bind.");
        }
        if (this._isCacheDestroyed) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -29, "PayloadCacheImpl.bindSharedDictionaryKey error: the cache instance has been destroyed.");
        }
        if (this._dictLoadingHelper == null) {
            this._dictLoadingHelper = new CacheDictLoadingHelper();
            if (_globalDictDbList == null) {
                _globalDictDbList = new VaIteratableQueue();
            }
        }
        if (!this._dictKeyCleared && this._dictKey != null) {
            if (!this._dictKey.equals(dictionaryKey)) {
                return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -22, "PayloadCacheImpl.bindSharedDictionaryKey error: not allow to reload dictonary with new key.");
            }
            return 0;
        }
        KeyETADictRefMap globalDictDb = this.getDictDb(dictionaryKey);
        if (globalDictDb == null) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -22, "PayloadCacheImpl.bindSharedDictionaryKey error: the shared dictionary is not available, dictionary not bind.");
        }
        int bindRet = this.etaSetFidDbWithCache(this._etaCacheRef, globalDictDb._etaDictRef, dictionaryKey, error);
        if (bindRet < 0) {
            return bindRet;
        }
        this._dictKey = globalDictDb._dictKey;
        this._dictKeyCleared = false;
        return 0;
    }

    @Override
    public int entryCount() {
        if (this._isCacheDestroyed) {
            return 0;
        }
        return this._cacheEntryList.size();
    }

    @Override
    public List<PayloadEntry> entryList() {
        if (this._isCacheDestroyed) {
            return null;
        }
        int entryNum = this._cacheEntryList.size();
        if (entryNum == 0) {
            return null;
        }
        if (this._appCacheEntryList == null) {
            this._appCacheEntryList = new ArrayList<PayloadEntry>(entryNum);
        } else {
            this._appCacheEntryList.clear();
        }
        this._cacheEntryList.rewind();
        while (this._cacheEntryList.hasNext()) {
            this._appCacheEntryList.add((PayloadEntry)this._cacheEntryList.next());
        }
        return this._appCacheEntryList;
    }

    @Override
    public void clear() {
        if (this._isCacheDestroyed) {
            return;
        }
        this.destroyPayloadEntries();
        this._dictKeyCleared = true;
    }

    public static int populateErrorInfo(CacheErrorImpl errorInfo, int returnCode, String text) {
        errorInfo.errorId(returnCode);
        errorInfo.text(text);
        return returnCode;
    }

    private KeyETADictRefMap getDictDb(String dictionaryKey) {
        KeyETADictRefMap dictKeyEtaDict = null;
        _globalDictLock.lock();
        _globalDictDbList.rewind();
        while (_globalDictDbList.hasNext()) {
            dictKeyEtaDict = (KeyETADictRefMap)_globalDictDbList.next();
            if (!dictKeyEtaDict._dictKey.equals(dictionaryKey)) continue;
            _globalDictLock.unlock();
            return dictKeyEtaDict;
        }
        _globalDictLock.unlock();
        return null;
    }

    private boolean encodedFidDictBuf(DataDictionary dict) {
        int ret;
        int dictSize = dict.numberOfEntries() * 50;
        this._dictLoadingHelper._dictMinFidInt.value(dict.minFid());
        long etaBufferRef = this.etaCreateRsslBuffer(this._dictLoadingHelper._dictEncodedBuf, dictSize, null);
        if (etaBufferRef == 0L) {
            return false;
        }
        this._dictLoadingHelper._dictEncodedBufWrap.data(this._dictLoadingHelper._dictEncodedBuf._data);
        this._dictLoadingHelper._dictMsg.clear();
        this._dictLoadingHelper._dictMsg.msgClass(2);
        this._dictLoadingHelper._dictMsg.applyRefreshComplete();
        this._dictLoadingHelper._dictMsg.domainType(5);
        this._dictLoadingHelper._dictMsg.applySolicited();
        this._dictLoadingHelper._dictMsg.containerType(138);
        this._dictLoadingHelper._dictMsg.state().streamState(1);
        this._dictLoadingHelper._dictMsg.state().dataState(1);
        this._dictLoadingHelper._dictMsg.state().code(0);
        this._dictLoadingHelper._dictMsg.state().text().data("Field Dictionary Refresh complete");
        this._dictLoadingHelper._dictMsg.applyHasMsgKey();
        this._dictLoadingHelper._dictMsg.msgKey().applyHasName();
        this._dictLoadingHelper._dictMsg.msgKey().name(this._dictLoadingHelper._dictName);
        this._dictLoadingHelper._dictMsg.msgKey().applyHasFilter();
        this._dictLoadingHelper._dictMsg.msgKey().filter(7L);
        this._dictLoadingHelper._dictMsg.msgKey().applyHasServiceId();
        this._dictLoadingHelper._dictMsg.msgKey().serviceId(0);
        this._dictLoadingHelper._dictMsg.streamId(3);
        while (true) {
            this._dictLoadingHelper._dictEncodeIter.setBufferAndRWFVersion(this._dictLoadingHelper._dictEncodedBufWrap, Codec.majorVersion(), Codec.minorVersion());
            if (this._dictLoadingHelper._dictMsg.encodeInit(this._dictLoadingHelper._dictEncodeIter, 0) == -1) {
                this.etaFreeRsslBuffer(this._dictLoadingHelper._dictEncodedBuf._etaBufferCPtr);
                return false;
            }
            ret = dict.encodeFieldDictionary(this._dictLoadingHelper._dictEncodeIter, this._dictLoadingHelper._dictMinFidInt, 7, this._dictLoadingHelper._dictError);
            if (ret != 10) break;
            this.etaFreeRsslBuffer(this._dictLoadingHelper._dictEncodedBuf._etaBufferCPtr);
            etaBufferRef = this.etaCreateRsslBuffer(this._dictLoadingHelper._dictEncodedBuf, dictSize += 2000, null);
            if (etaBufferRef == 0L) {
                return false;
            }
            this._dictLoadingHelper._dictEncodedBufWrap.data(this._dictLoadingHelper._dictEncodedBuf._data);
        }
        if (ret == -1) {
            this.etaFreeRsslBuffer(this._dictLoadingHelper._dictEncodedBuf._etaBufferCPtr);
            return false;
        }
        if (this._dictLoadingHelper._dictMsg.encodeComplete(this._dictLoadingHelper._dictEncodeIter, true) == -1) {
            this.etaFreeRsslBuffer(this._dictLoadingHelper._dictEncodedBuf._etaBufferCPtr);
            return false;
        }
        return true;
    }

    private void uninitialize() {
        _globalDictLock.lock();
        KeyETADictRefMap one = null;
        while ((one = (KeyETADictRefMap)_globalDictDbList.poll()) != null) {
            one._dictKey = null;
        }
        _globalDictLock.unlock();
        PayloadCursorImpl.destroyAll();
    }

    private void destroyPayloadEntries() {
        int cacheCount = this._cacheEntryList.size();
        if (cacheCount == 0) {
            return;
        }
        PayloadEntryImpl next = null;
        while (cacheCount-- > 0) {
            next = (PayloadEntryImpl)this._cacheEntryList.poll();
            next.applyDestroy();
        }
        this.etaDestroyAllEntries(this._etaCacheRef);
    }

    private void initializePooling() {
        int pos;
        CacheJNIBuffer one = null;
        long etaBufferRef = 0L;
        for (pos = 0; pos < 21; ++pos) {
            this._retrieveJNIBufferArray[pos] = new VaIteratableQueue();
            this._applyJNIBufferArray[pos] = new VaIteratableQueue();
        }
        for (pos = 0; pos <= this._maxRetrieveJNIBufferArrayPos; ++pos) {
            one = new CacheJNIBuffer();
            etaBufferRef = this.etaCreateRsslBuffer(one, 500 * (pos + 1), null);
            if (etaBufferRef == 0L) continue;
            this._retrieveJNIBufferArray[pos].add((VaNode)one);
        }
        for (pos = 0; pos <= this._maxApplyJNIBufferArrayPos; ++pos) {
            one = new CacheJNIBuffer();
            etaBufferRef = this.etaCreateRsslBuffer(one, 500 * (pos + 1), null);
            if (etaBufferRef == 0L) continue;
            this._applyJNIBufferArray[pos].add((VaNode)one);
        }
    }

    public long createCacheEntry(CacheError error) {
        if (this._isCacheDestroyed || this._etaCacheRef == 0L) {
            PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -1, "PayloadCacheImpl.createCacheEntry error: use invalid cache instance to create cache entry.");
            return 0L;
        }
        long etaCacheEntryInstance = this.etaCreateCacheEntry(this._etaCacheRef, error);
        return etaCacheEntryInstance;
    }

    public void addCacheEntry(PayloadEntryImpl entry) {
        if (this._isCacheDestroyed || this._etaCacheRef == 0L) {
            return;
        }
        this._cacheEntryList.add((VaNode)entry);
    }

    public void removeCacheEntry(PayloadEntryImpl entry) {
        if (this._isCacheDestroyed || this._etaCacheRef == 0L) {
            return;
        }
        this._cacheEntryList.remove((VaNode)entry);
    }

    public CacheJNIBuffer acquireCacheRetrieveJNIBuffer(int length, CacheError error) {
        CacheJNIBuffer one = null;
        long etaBufferRef = 0L;
        int pos = length / 500;
        if (pos < 20) {
            one = (CacheJNIBuffer)this._retrieveJNIBufferArray[pos].poll();
            if (one == null) {
                one = new CacheJNIBuffer();
                etaBufferRef = this.etaCreateRsslBuffer(one, 500 * (pos + 1), error);
                if (etaBufferRef != 0L) {
                    if (this._maxRetrieveJNIBufferArrayPos < pos) {
                        this._maxRetrieveJNIBufferArrayPos = pos;
                    }
                    return one;
                }
                return null;
            }
            one.clear();
            return one;
        }
        this._maxRetrieveJNIBufferArrayPos = 20;
        VaIteratableQueue flexLenBufList = this._retrieveJNIBufferArray[20];
        flexLenBufList.rewind();
        while (flexLenBufList.hasNext()) {
            one = (CacheJNIBuffer)flexLenBufList.next();
            if (one._capability <= length) continue;
            flexLenBufList.remove();
            one.clear();
            return one;
        }
        one = new CacheJNIBuffer();
        etaBufferRef = this.etaCreateRsslBuffer(one, length, error);
        if (etaBufferRef == 0L) {
            return null;
        }
        return one;
    }

    public void releaseCacheRetrieveJNIBuffer(CacheJNIBuffer buffer) {
        if (buffer._capability > 10000) {
            this._retrieveJNIBufferArray[20].add((VaNode)buffer);
        } else {
            int pos = buffer._capability / 500 - 1;
            this._retrieveJNIBufferArray[pos].add((VaNode)buffer);
        }
    }

    public CacheJNIBuffer acquireCacheApplyJNIBuffer(int length, CacheError error) {
        CacheJNIBuffer one = null;
        long etaBufferRef = 0L;
        int pos = length / 500;
        if (pos < 20) {
            one = (CacheJNIBuffer)this._applyJNIBufferArray[pos].poll();
            if (one == null) {
                one = new CacheJNIBuffer();
                etaBufferRef = this.etaCreateRsslBuffer(one, 500 * (pos + 1), error);
                if (etaBufferRef != 0L) {
                    if (this._maxApplyJNIBufferArrayPos < pos) {
                        this._maxApplyJNIBufferArrayPos = pos;
                    }
                    return one;
                }
                return null;
            }
            one.clear();
            return one;
        }
        this._maxApplyJNIBufferArrayPos = 20;
        VaIteratableQueue flexLenBufList = this._applyJNIBufferArray[20];
        flexLenBufList.rewind();
        while (flexLenBufList.hasNext()) {
            one = (CacheJNIBuffer)flexLenBufList.next();
            if (one._capability <= length) continue;
            flexLenBufList.remove();
            one.clear();
            return one;
        }
        one = new CacheJNIBuffer();
        etaBufferRef = this.etaCreateRsslBuffer(one, length, error);
        if (etaBufferRef == 0L) {
            return null;
        }
        return one;
    }

    public void releaseCacheApplyJNIBuffer(CacheJNIBuffer buffer) {
        if (buffer._capability > 10000) {
            this._applyJNIBufferArray[20].add((VaNode)buffer);
        } else {
            int pos = buffer._capability / 500 - 1;
            this._applyJNIBufferArray[pos].add((VaNode)buffer);
        }
    }

    public static native int etaInitializeJNICache();

    public static native int etaUninitializeJNICache();

    public static native long etaCreateCache(int var0, CacheError var1);

    public native void etaDestroyCache(long var1);

    public native long etaCreateFIDDictionary(String var1);

    public native int etaLoadDictionaryFromBuffer(long var1, long var3, int var5, CacheError var6);

    public native int etaSetFidDbWithCache(long var1, long var3, String var5, CacheError var6);

    public native long etaCreateCacheEntry(long var1, CacheError var3);

    public native void etaDestroyAllEntries(long var1);

    public native long etaCreateRsslBuffer(CacheJNIBuffer var1, long var2, CacheError var4);

    public native int etaFreeRsslBuffer(long var1);

    static {
        System.loadLibrary("rsslVACacheJNI");
    }

    class KeyETADictRefMap
    extends VaNode {
        String _dictKey = null;
        long _etaDictRef = 0L;

        KeyETADictRefMap(String dictKey, long etaDictRef) {
            this._dictKey = new String(dictKey);
            this._etaDictRef = etaDictRef;
        }
    }
}

