/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.ansipage;

import com.refinitiv.ansi.CharType;
import com.refinitiv.ansi.ListType;
import com.refinitiv.ansi.PageType;
import com.refinitiv.eta.ansipage.CellColor;
import com.refinitiv.eta.ansipage.CellStyle;
import com.refinitiv.eta.ansipage.GraphicSet;
import com.refinitiv.eta.ansipage.NullCell;
import com.refinitiv.eta.ansipage.PageCell;
import com.refinitiv.eta.ansipage.PageUpdate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class Page
implements Cloneable {
    private short _nNumberOfRows = 0;
    private short _nNumberOfColumns = 0;
    private ListType _updateList = null;
    PageType _page = null;

    public Page(short nNumberOfRows, short nNumberOfColumns) {
        this._nNumberOfRows = (short)(nNumberOfRows <= 0 ? 25 : (int)nNumberOfRows);
        this._nNumberOfColumns = (short)(nNumberOfColumns <= 0 ? 80 : (int)nNumberOfColumns);
        this._updateList = new ListType();
        this._page = new PageType(nNumberOfRows, nNumberOfColumns);
        this._page.status.initStatus();
    }

    public Object clone() {
        Page page = new Page(this._nNumberOfRows, this._nNumberOfColumns);
        page._page = (PageType)this._page.clone();
        page._updateList = (ListType)this._updateList.clone();
        return page;
    }

    public long decode(ByteArrayInputStream instream, Vector<PageUpdate> pageUpdateList) {
        if (this._updateList != null) {
            this._updateList = null;
        }
        this._updateList = new ListType();
        long nNumCharsParsed = this._page.getDecoder().qa_decode(this._page, instream, this._updateList);
        pageUpdateList.clear();
        for (int i = 0; i < this._updateList.index + 1; ++i) {
            PageUpdate pageUpdate = new PageUpdate();
            pageUpdate.setRow(this._updateList.upd_list[i].row);
            pageUpdate.setBeginningColumn(this._updateList.upd_list[i].upd_beg);
            pageUpdate.setEndingColumn(this._updateList.upd_list[i].upd_end);
            pageUpdateList.add(pageUpdate);
        }
        return nNumCharsParsed;
    }

    public boolean encode(boolean bFadeEnable, Vector<PageUpdate> pageUpdate, ByteArrayOutputStream outstream) {
        if (this._updateList != null) {
            this._updateList = null;
        }
        this._updateList = new ListType();
        this._updateList.index = (short)(pageUpdate.size() - 1);
        for (int i = 0; i < pageUpdate.size(); ++i) {
            PageUpdate update = pageUpdate.elementAt(i);
            this._updateList.upd_list[i].row = update.getRow();
            this._updateList.upd_list[i].upd_beg = update.getBeginningColumn();
            this._updateList.upd_list[i].upd_end = update.getEndingColumn();
        }
        long nRetVal = this._page.getEncoder().qa_encode(this._page, outstream, bFadeEnable, this._updateList, this._nNumberOfRows, this._nNumberOfColumns);
        if (nRetVal == 0L) {
            this._page.last_mod = 0;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this._nNumberOfRows * this._nNumberOfColumns);
        for (short j = 1; j <= this._nNumberOfRows; j = (short)(j + 1)) {
            for (short k = 1; k <= this._nNumberOfColumns; k = (short)(k + 1)) {
                buf.append(this.getChar(j, k));
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    public String toString(boolean drawBorder) {
        int i;
        StringBuilder buf = new StringBuilder(this._nNumberOfRows * this._nNumberOfColumns);
        if (drawBorder) {
            for (i = 1; i <= this._nNumberOfColumns; ++i) {
                buf.append('-');
            }
        }
        buf.append('\n');
        for (short j = 1; j <= this._nNumberOfRows; j = (short)(j + 1)) {
            if (drawBorder) {
                buf.append('|');
            }
            for (short k = 1; k <= this._nNumberOfColumns; k = (short)(k + 1)) {
                buf.append(this.getChar(j, k));
            }
            if (drawBorder) {
                buf.append('|');
            }
            buf.append('\n');
        }
        if (drawBorder) {
            for (i = 1; i <= this._nNumberOfColumns; ++i) {
                buf.append('-');
            }
        }
        buf.append('\n');
        return buf.toString();
    }

    public short getNumberOfColumns() {
        return this._nNumberOfColumns;
    }

    public short getNumberOfRows() {
        return this._nNumberOfRows;
    }

    @Deprecated
    public PageCell getPageCell(short nRow, short nColumn) {
        if (this.outOfBounds(nRow, nColumn)) {
            return NullCell.Singleton;
        }
        return new PageCell(this.getCharType(nRow, nColumn));
    }

    public char getChar(short nRow, short nColumn) {
        if (this.outOfBounds(nRow, nColumn)) {
            return '\u0000';
        }
        return this.getCharType((short)nRow, (short)nColumn).ch;
    }

    public CellColor getBackgroundColor(short nRow, short nColumn) {
        if (this.outOfBounds(nRow, nColumn)) {
            return CellColor.mono;
        }
        CharType cell = this.getCharType(nRow, nColumn);
        return CellColor.getCellColor(cell.c_attr >> 4);
    }

    public CellColor getBackgroundFadeColor(short nRow, short nColumn) {
        if (this.outOfBounds(nRow, nColumn)) {
            return CellColor.mono;
        }
        CharType cell = this.getCharType(nRow, nColumn);
        return CellColor.getCellColor(cell.c_fade_attr >> 4);
    }

    public boolean hasStyle(short nRow, short nColumn, CellStyle style) {
        if (this.outOfBounds(nRow, nColumn)) {
            return false;
        }
        CharType cell = this.getCharType(nRow, nColumn);
        return (cell.attr & style._value) != 0;
    }

    public boolean hasFadeStyle(short nRow, short nColumn, CellStyle style) {
        if (this.outOfBounds(nRow, nColumn)) {
            return false;
        }
        CharType cell = this.getCharType(nRow, nColumn);
        return (cell.fade_attr & style._value) != 0;
    }

    public CellColor getForegroundColor(short nRow, short nColumn) {
        if (this.outOfBounds(nRow, nColumn)) {
            return CellColor.mono;
        }
        CharType cell = this.getCharType(nRow, nColumn);
        return CellColor.getCellColor(cell.c_attr & 0xF);
    }

    public CellColor getForegroundFadeColor(short nRow, short nColumn) {
        if (this.outOfBounds(nRow, nColumn)) {
            return CellColor.mono;
        }
        CharType cell = this.getCharType(nRow, nColumn);
        return CellColor.getCellColor(cell.c_fade_attr & 0xF);
    }

    public GraphicSet getGraphicSet(short nRow, short nColumn) {
        if (this.outOfBounds(nRow, nColumn)) {
            return GraphicSet.Unknown;
        }
        CharType cell = this.getCharType(nRow, nColumn);
        return GraphicSet.getGraphicSet(cell.gs);
    }

    public void reset(Vector<PageUpdate> pageUpdateList) {
        if (this._updateList != null) {
            this._updateList = null;
        }
        this._updateList = new ListType();
        this._updateList.index = 0;
        this._page.getDecoder().qa_reset(this._page, this._updateList);
        for (int i = 0; i < pageUpdateList.size(); ++i) {
            PageUpdate update = pageUpdateList.elementAt(i);
            update.setRow((short)0);
            update.setBeginningColumn((short)0);
            update.setEndingColumn((short)0);
        }
    }

    public void setPageCell(short nRow, short nColumn, PageCell rPagecell) {
        if (nRow > 0 && nRow <= this._nNumberOfRows && nColumn > 0 && nColumn <= this._nNumberOfColumns) {
            this._page.page[(nRow - 1) * this._nNumberOfColumns + (nColumn - 1)] = (CharType)rPagecell.toCharType().clone();
        }
    }

    public Page() {
        this._nNumberOfRows = (short)25;
        this._nNumberOfColumns = (short)80;
        this._updateList = new ListType();
        this._page = new PageType(25, 80);
        this._page.status.initStatus();
    }

    private CharType getCharType(short nRow, short nColumn) {
        return this._page.page[(nRow - 1) * this._nNumberOfColumns + (nColumn - 1)];
    }

    private boolean outOfBounds(short nRow, short nColumn) {
        return nRow > this._nNumberOfRows || nColumn > this._nNumberOfColumns || nRow <= 0 || nColumn <= 0;
    }
}

