/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.ansipage;

import com.refinitiv.ansi.CharType;
import com.refinitiv.eta.ansipage.CellColor;
import com.refinitiv.eta.ansipage.CellStyle;
import com.refinitiv.eta.ansipage.GraphicSet;

public class PageCell
implements Cloneable {
    private CharType _pageCell;
    private CellStyle _style;
    private CellStyle _fadeStyle;

    public PageCell(char cChar, GraphicSet graphicSet, CellStyle style, CellStyle fadeStyle, CellColor foregroundColor, CellColor backgroundColor, CellColor foregroundFadeColor, CellColor backgroundFadeColor) {
        this._pageCell = new CharType();
        this._pageCell.ch = cChar;
        this._pageCell.gs = (char)graphicSet.toByte();
        this._pageCell.attr = (char)style.toByte();
        this._pageCell.fade_attr = (char)fadeStyle.toByte();
        long nTempVal = backgroundColor.toByte();
        this._pageCell.c_attr = (char)((long)foregroundColor.toByte() | (nTempVal <<= 4));
        nTempVal = backgroundFadeColor.toByte();
        this._pageCell.c_fade_attr = (char)((long)foregroundFadeColor.toByte() | (nTempVal <<= 4));
    }

    PageCell(CharType charType) {
        this._pageCell = (CharType)charType.clone();
    }

    public PageCell() {
        this._pageCell = new CharType();
        this._pageCell.ch = (char)32;
        this._pageCell.gs = (char)GraphicSet.USAscii.toByte();
        this._pageCell.attr = (char)CellStyle.plain.toByte();
        this._pageCell.fade_attr = (char)CellStyle.plain.toByte();
        long nTempVal = CellColor.mono.toByte();
        this._pageCell.c_attr = (char)((long)CellColor.mono.toByte() | (nTempVal <<= 4));
        nTempVal = CellColor.mono.toByte();
        this._pageCell.c_fade_attr = (char)((long)CellColor.mono.toByte() | (nTempVal <<= 4));
    }

    public CellColor getBackgroundColor() {
        return CellColor.getCellColor(this._pageCell.c_attr >> 4);
    }

    public CellColor getBackgroundFadeColor() {
        return CellColor.getCellColor(this._pageCell.c_fade_attr >> 4);
    }

    public char getChar() {
        return this._pageCell.ch;
    }

    public CellStyle getFadeStyle() {
        if (this._fadeStyle == null) {
            this._fadeStyle = new CellStyle((byte)this._pageCell.fade_attr);
        }
        return this._fadeStyle;
    }

    public CellColor getForegroundColor() {
        return CellColor.getCellColor(this._pageCell.c_attr & 0xF);
    }

    public CellColor getForegroundFadeColor() {
        return CellColor.getCellColor(this._pageCell.c_fade_attr & 0xF);
    }

    public GraphicSet getGraphicSet() {
        return GraphicSet.getGraphicSet(this._pageCell.gs);
    }

    public CellStyle getStyle() {
        if (this._style == null) {
            this._style = new CellStyle((byte)this._pageCell.attr);
        }
        return this._style;
    }

    public void setChar(char cChar) {
        this._pageCell.ch = cChar;
    }

    public void setColor(CellColor foregroundColor, CellColor backgroundColor) {
        long nTempBackgroundColor = backgroundColor.toByte();
        this._pageCell.c_attr = (char)((long)foregroundColor.toByte() | (nTempBackgroundColor <<= 4));
    }

    public void setFadeColor(CellColor foregroundFadeColor, CellColor backgroundFadeColor) {
        long nTempBackgroundFadeColor = backgroundFadeColor.toByte();
        this._pageCell.c_fade_attr = (char)((long)foregroundFadeColor.toByte() | (nTempBackgroundFadeColor <<= 4));
    }

    public void setFadeStyle(CellStyle fadeStyle) {
        this._pageCell.fade_attr = (char)fadeStyle.toByte();
    }

    public void setGraphicSet(GraphicSet graphicSet) {
        this._pageCell.gs = (char)graphicSet.toByte();
    }

    public void setStyle(CellStyle style) {
        this._pageCell.attr = (char)style.toByte();
    }

    public Object clone() {
        PageCell newPageCell = new PageCell(this._pageCell);
        newPageCell._style = (CellStyle)this._style.clone();
        newPageCell._fadeStyle = (CellStyle)this._fadeStyle.clone();
        return newPageCell;
    }

    CharType toCharType() {
        return this._pageCell;
    }
}

