/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.ansi;

import com.refinitiv.ansi.Attribute;
import com.refinitiv.ansi.BackgroundColor;
import com.refinitiv.ansi.CharType;
import com.refinitiv.ansi.DoubleSquence;
import com.refinitiv.ansi.ForegroundColor;
import com.refinitiv.ansi.ListType;
import com.refinitiv.ansi.PageType;
import com.refinitiv.ansi.UpdateType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class AnsiEncoder
implements Cloneable {
    static final byte[] ESCCURSOROFF = new byte[]{27, 91, 63, 50, 53, 108};
    static final byte[] ESCSCREENWRAP = new byte[]{27, 91, 63, 55, 104};
    static final byte[] ESCWRAPOFF = new byte[]{27, 91, 63, 55, 108};
    static final byte[] ESCFADEBLINK = new byte[]{27, 91, 62, 53, 109};
    static final byte[] ESCFADEOFF = new byte[]{27, 91, 62, 48, 109};
    static final byte[] ESCRESETSCR = new byte[]{27, 99};
    static final byte[] ESCPLAIN = new byte[]{27, 91, 109};
    static final byte[] ESCCLRLINE = new byte[]{27, 91, 50, 75};
    static final byte[] CSI_FADE = new byte[]{27, 91, 62};
    static final byte[] CSI = new byte[]{27, 91};
    static final byte[] ENDSET = new byte[]{109};
    static final byte[] ESCMVCURS = new byte[]{27, 91, 37, 100, 59, 37, 100, 72};
    static final byte[] ESC_G0_SET = new byte[]{27, 40};
    static final byte[] ESC_G1_SET = new byte[]{27, 41};
    static final byte USE_G0 = 15;
    static final byte USE_G1 = 14;
    static final int MAX_SINGLE_ANSI_SEQUENCE = 30;
    static final short ERROR = -1;
    static final int DONE = 0;
    static final int NOT_DONE = 1;
    static final byte[] tens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56};
    static final byte[] ones = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
    static final byte DB_SFT_BITS = 7;

    public Object clone() {
        AnsiEncoder encoder = null;
        try {
            encoder = (AnsiEncoder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace(System.err);
        }
        return encoder;
    }

    public long qa_encode(PageType page, ByteArrayOutputStream text, boolean fadeEnable, ListType updateList, short _nNumberOfRows, short _nNumberOfColumns) {
        short mod_count;
        boolean db_flag = false;
        int count = 0;
        this._ansi_addstr(text, ESCCURSOROFF);
        this._ansi_addstr(text, ESCSCREENWRAP);
        this._ansi_addstr(text, ESCPLAIN);
        char c_G0 = '\u0000';
        c_G0 = page.status.G0_set;
        if (c_G0 != '\u0000') {
            this._ansi_addstr(text, ESC_G0_SET);
            text.write((byte)c_G0);
        }
        char c_G1 = '\u0000';
        c_G1 = page.status.G1_set;
        if (c_G1 != '\u0000') {
            this._ansi_addstr(text, ESC_G1_SET);
            text.write((byte)c_G1);
        }
        char r_gs_flag = '\u007f';
        char cur_attr = '\u0000';
        char fading = '\u0000';
        char pr_color = '\u00ff';
        char pr_f_color = '\u00ff';
        boolean stop = false;
        int db_attr = 0;
        int page_pos = 0;
        UpdateType modptr = new UpdateType();
        CharType chptr = new CharType();
        int chptr_start = 0;
        char sv_pr_color = '\u0000';
        char sv_cur_attr = '\u0000';
        char sv_fading = '\u0000';
        char sv_pr_f_color = '\u0000';
        char sv_r_gs_flag = '\u0000';
        char changes = '\u0000';
        for (mod_count = page.last_mod != -1 ? page.last_mod : (short)0; mod_count <= updateList.index && !stop; mod_count = (short)(mod_count + 1)) {
            modptr = updateList.upd_list[mod_count];
            short col = modptr.upd_beg;
            page_pos = (modptr.row - 1) * _nNumberOfColumns + (col - 1);
            if (modptr.row == _nNumberOfRows) {
                this._ansi_addstr(text, ESCWRAPOFF);
                text.write((byte)c_G1);
            }
            boolean whole_line_flag = false;
            boolean skip_spc = false;
            if (modptr.upd_beg == 1 && modptr.upd_end == _nNumberOfColumns + 1) {
                skip_spc = true;
                whole_line_flag = true;
            } else {
                skip_spc = false;
            }
            boolean mvflag = true;
            int spc_start = 0;
            while (col < modptr.upd_end) {
                chptr = page.page[page_pos];
                if (chptr.ch == '\u0000') {
                    mvflag = true;
                } else {
                    byte back;
                    byte fore;
                    if (skip_spc && spc_start == 0 && chptr.ch == ' ' && chptr.attr != '\u0000' && (chptr.c_attr == '\u00ff' || (chptr.c_attr & 0xF0) != 0)) {
                        spc_start = text.size();
                        chptr_start = page_pos;
                        sv_cur_attr = cur_attr;
                        sv_pr_color = pr_color;
                        sv_fading = fading;
                        sv_pr_f_color = pr_f_color;
                        sv_r_gs_flag = r_gs_flag;
                    } else if (spc_start != 0 && (chptr.ch != ' ' || chptr.attr != '\u0000' || chptr.c_attr != '\u00ff' && 0 != (chptr.c_attr & 0xF0))) {
                        if (page_pos - chptr_start > 10) {
                            count = spc_start;
                            cur_attr = sv_cur_attr;
                            sv_cur_attr = '\u0000';
                            pr_color = sv_pr_color;
                            fading = sv_fading;
                            pr_f_color = sv_pr_f_color;
                            if ((cur_attr & 0xE0) != 0) {
                                db_flag = true;
                            }
                            r_gs_flag = sv_r_gs_flag;
                            mvflag = true;
                        }
                        spc_start = 0;
                    }
                    if (whole_line_flag) {
                        short save_col = col;
                        col = 1;
                        this._ansi_wrpos(text, (byte)modptr.row, (byte)col);
                        this._ansi_addstr(text, ESCCLRLINE);
                        col = save_col;
                        mvflag = true;
                        whole_line_flag = false;
                    }
                    if (mvflag) {
                        this._ansi_wrpos(text, modptr.row, col);
                        mvflag = false;
                    }
                    if (r_gs_flag != chptr.gs && (r_gs_flag != 'B' || this.isprint(chptr.gs))) {
                        r_gs_flag = chptr.gs;
                        if (!this.isprint(r_gs_flag)) {
                            r_gs_flag = 'B';
                        }
                        if (r_gs_flag == c_G0) {
                            text.write(15);
                        } else if (r_gs_flag == c_G1) {
                            int use_G1 = 14;
                            text.write(use_G1);
                        } else if (c_G0 != '\u0000') {
                            c_G1 = r_gs_flag;
                            this._ansi_addstr(text, ESC_G1_SET);
                            text.write(c_G1);
                            text.write(14);
                        } else {
                            c_G0 = r_gs_flag;
                            this._ansi_addstr(text, ESC_G0_SET);
                            text.write(c_G0);
                            text.write(15);
                        }
                    }
                    changes = (char)(cur_attr ^ chptr.attr);
                    cur_attr = chptr.attr;
                    if (!this.no_attr_ht(changes) || chptr.c_attr != pr_color) {
                        this._ansi_addstr(text, CSI);
                        if (cur_attr < ' ') {
                            if (db_flag) {
                                db_attr = 5;
                            }
                            this._ansi_addstr(text, Attribute.attribute[this.att_bits(cur_attr)].toBytes());
                        } else if ((cur_attr & 0xE0) != 0) {
                            db_flag = true;
                            db_attr = (byte)this.sdb_bits((char)(cur_attr >> 5));
                            this._ansi_addstr(text, Attribute.attribute[this.att_bits(cur_attr)].toBytes());
                        } else {
                            this._ansi_addstr(text, Attribute.attribute[0].toBytes());
                        }
                        fore = (byte)(chptr.c_attr & 0xF);
                        back = (byte)(chptr.c_attr >> 4);
                        if (fore != 15) {
                            this._ansi_addstr(text, ForegroundColor.foregroundColor[fore].toBytes());
                        }
                        if (back != 15) {
                            this._ansi_addstr(text, BackgroundColor.backgroundColor[back].toBytes());
                        }
                        pr_color = chptr.c_attr;
                        this._ansi_addstr(text, ENDSET);
                        if (db_flag) {
                            if (db_attr < 7) {
                                this._ansi_addstr(text, DoubleSquence.doubleSequence[db_attr].toBytes());
                            }
                            if (db_attr == 5) {
                                db_flag = false;
                            }
                        }
                    }
                    if (!fadeEnable) {
                        text.write((byte)chptr.ch);
                    } else {
                        changes = (char)(fading ^ chptr.fade_attr);
                        fading = chptr.fade_attr;
                        if (this.no_attr_ht(changes) && chptr.c_fade_attr == pr_f_color) {
                            text.write((byte)chptr.ch);
                        } else {
                            this._ansi_addstr(text, CSI_FADE);
                            if (chptr.fade_attr < ' ') {
                                this._ansi_addstr(text, Attribute.attribute[chptr.fade_attr].toBytes());
                            } else {
                                this._ansi_addstr(text, Attribute.attribute[0].toBytes());
                            }
                            fore = (byte)(chptr.c_fade_attr & 0xF);
                            back = (byte)(chptr.c_fade_attr >> 4);
                            if (fore != 15) {
                                this._ansi_addstr(text, ForegroundColor.foregroundColor[fore].toBytes());
                            }
                            if (back != 15) {
                                this._ansi_addstr(text, BackgroundColor.backgroundColor[back].toBytes());
                            }
                            pr_f_color = chptr.c_fade_attr;
                            this._ansi_addstr(text, ENDSET);
                            text.write((byte)chptr.ch);
                        }
                    }
                }
                col = (short)(col + 1);
                ++page_pos;
            }
            if (spc_start == 0) continue;
            if (page_pos - chptr_start > 10) {
                count = spc_start;
                cur_attr = sv_cur_attr;
                sv_cur_attr = '\u0000';
                pr_color = sv_pr_color;
                fading = sv_fading;
                pr_f_color = sv_pr_f_color;
                if ((cur_attr & 0xE0) != 0) {
                    db_flag = true;
                }
                r_gs_flag = sv_r_gs_flag;
            }
            spc_start = 0;
        }
        if ((cur_attr & 0xE0) != 0 || 0 != (sv_cur_attr & 0xE0)) {
            this._ansi_addstr(text, DoubleSquence.doubleSequence[5].toBytes());
        }
        this._ansi_addstr(text, ESCFADEOFF);
        text.write(0);
        if (!stop) {
            return 0L;
        }
        page.last_mod = (short)(mod_count - 1);
        return 1L;
    }

    int _ansi_addstr(ByteArrayOutputStream buffer, byte[] str) {
        try {
            buffer.write(str);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return str.length;
    }

    int _ansi_wrpos(ByteArrayOutputStream str, int row, int col) {
        str.write(27);
        str.write(91);
        str.write(tens[row]);
        str.write(ones[row]);
        str.write(59);
        str.write(tens[col]);
        str.write(ones[col]);
        str.write(72);
        return 8;
    }

    boolean isprint(char c) {
        return c >= ' ' && c <= '~';
    }

    boolean no_attr_ht(char attrib) {
        return attrib == '\u0000';
    }

    int att_bits(char gflag) {
        return gflag & 0x1F;
    }

    int sdb_bits(char gflag) {
        return gflag & 7;
    }
}

