/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.ansipage;

public final class CellStyle
implements Cloneable {
    private String _name;
    byte _value;
    boolean _underlineEnable = false;
    boolean _immutable = false;
    public static final CellStyle plain = new CellStyle("plain", 0);
    public static final CellStyle blink = new CellStyle("blink", 1);
    public static final CellStyle reverse = new CellStyle("reverse", 2);
    public static final CellStyle dim = new CellStyle("dim", 4);
    public static final CellStyle underline = new CellStyle("underline", 8);
    public static final CellStyle bright = new CellStyle("bright", 16);

    private CellStyle(String name, byte value) {
        this._name = name;
        this._value = value;
        this._immutable = true;
    }

    public Object clone() {
        return new CellStyle(this._value);
    }

    public String toString() {
        return this._name;
    }

    public CellStyle(byte value) {
        switch (value) {
            case 0: {
                this._name = "plain";
                break;
            }
            case 1: {
                this._name = "blink";
                break;
            }
            case 2: {
                this._name = "reverse";
                break;
            }
            case 4: {
                this._name = "dim";
                break;
            }
            case 8: {
                this._name = "underline";
                break;
            }
            case 16: {
                this._name = "bright";
                break;
            }
        }
        this._value = value;
    }

    public void setUnderline(boolean bUnderlinEnable) {
        this._underlineEnable = bUnderlinEnable;
    }

    public boolean getUnderline() {
        return this._underlineEnable;
    }

    byte toByte() {
        return this._value;
    }

    public CellStyle() {
        this._name = "plain";
        this._value = 0;
        this._underlineEnable = false;
    }

    public boolean hasStyle(CellStyle c) {
        return (this._value & c._value) != 0;
    }

    public void setStyle(CellStyle c) {
        if (this._immutable) {
            throw new UnsupportedOperationException("Cannot modify a CellStyle constant");
        }
        this._value = (byte)(this._value | c._value);
    }

    public void reset() {
        this._value = 0;
    }
}

