/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.ansi;

import com.refinitiv.ansi.Ansi;
import com.refinitiv.ansi.CharType;
import com.refinitiv.ansi.ListType;
import com.refinitiv.ansi.PageType;
import com.refinitiv.ansi.ParserType;
import com.refinitiv.ansi.StatusType;
import com.refinitiv.ansi.UpdateType;
import java.io.ByteArrayInputStream;

public class AnsiDecoder
implements Ansi,
Cloneable {
    ParserType _parser;
    static final short OK = 1;
    static final short ERROR = -1;
    static final short S_UP = 0;
    static final short S_DOWN = 1;
    static final short S_LEFT = 2;
    static final short S_RIGHT = 3;
    static final int DBH_TP = 1;
    static final int DBH_BT = 2;
    static final int DBHW_TP = 3;
    static final int DBHW_BT = 4;
    static final int DB_OFF = 5;
    static final int DBWD = 6;
    static final int DB_MIN = 1;
    static final int DB_MAX = 6;
    static final short[] TAB_TABLE = new short[]{9, 9, 9, 9, 9, 9, 9, 9, 17, 17, 17, 17, 17, 17, 17, 17, 25, 25, 25, 25, 25, 25, 25, 25, 33, 33, 33, 33, 33, 33, 33, 33, 41, 41, 41, 41, 41, 41, 41, 41, 49, 49, 49, 49, 49, 49, 49, 49, 57, 57, 57, 57, 57, 57, 57, 57, 65, 65, 65, 65, 65, 65, 65, 65, 73, 73, 73, 73, 73, 73, 73, 73, 80, 80, 80, 80, 80, 80, 80, 80};
    short PageColumns = (short)80;
    short PageRows = (short)25;
    short ScrollBot = (short)24;
    short EndOfRow = (short)81;
    static final int INIT_STATE = 0;
    static final int ESCAPE_STATE = 1;
    static final int CSI_STATE = 2;
    static final int G0_STATE = 3;
    static final int G1_STATE = 4;
    static final int CHARACTER_SIZE_STATE = 5;
    static final int CR_STATE = 20;
    static final int LF_STATE = 21;
    static final int MAXCSIPARAMS = 20;

    public Object clone() {
        AnsiDecoder decoder = new AnsiDecoder();
        decoder.PageColumns = this.PageColumns;
        decoder.PageRows = this.PageRows;
        decoder.ScrollBot = this.ScrollBot;
        decoder.EndOfRow = this.EndOfRow;
        decoder._parser = (ParserType)this._parser.clone();
        return decoder;
    }

    short ansi_chparm() {
        if (this._parser.param_cnt < 20) {
            this._parser.param_cnt = (short)(this._parser.param_cnt + 1);
            this._parser.params[this._parser.param_cnt - 1] = 0;
        }
        return 1;
    }

    short ansi_cret(PageType page, ListType u_list) {
        page.status.col = 1;
        if (this._parser.cr_state != 21) {
            this.newUpd(u_list, 1, page.status.row, (short)1, (short)1);
        } else {
            u_list.upd_list[u_list.index].upd_beg = 1;
            u_list.upd_list[u_list.index].upd_end = 1;
        }
        this._parser.cr_state = 20;
        this._parser.state = 0;
        this._parser.wrap = false;
        return 1;
    }

    short ansi_csi() {
        this._parser.state = 2;
        return 1;
    }

    short ansi_cub(PageType page, ListType u_list) {
        short num_col;
        short s = num_col = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        if (num_col < 1) {
            num_col = 1;
        }
        page.status.col = page.status.col - num_col <= 0 ? (short)1 : (short)(page.status.col - num_col);
        this.newUpd(u_list, 1, page.status.row, page.status.col, page.status.col);
        this._parser.state = 0;
        this._parser.wrap = false;
        return 1;
    }

    short ansi_cud(PageType page, ListType u_list) {
        short num_rows;
        StatusType sts = page.status;
        short s = num_rows = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        sts.row = sts.row <= page.scroll_bot ? (sts.row + num_rows > page.scroll_bot ? page.scroll_bot : (short)(sts.row + num_rows)) : (sts.row + num_rows > this.PageRows ? this.PageRows : (short)(sts.row + num_rows));
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        this._parser.wrap = false;
        return 1;
    }

    short ansi_cuf(PageType page, ListType u_list) {
        if (this._parser.special_esc != '\u0000') {
            switch (this._parser.special_esc) {
                case '=': {
                    break;
                }
            }
        } else {
            short numcol = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
            page.status.col = page.status.col + numcol > this.PageColumns ? this.PageColumns : (short)(page.status.col + numcol);
            this.newUpd(u_list, 1, page.status.row, page.status.col, page.status.col);
        }
        this._parser.state = 0;
        return 1;
    }

    short ansi_cuu(PageType page, ListType u_list) {
        short num_rows;
        StatusType sts = page.status;
        short s = num_rows = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        sts.row = sts.row >= page.scroll_top ? (sts.row - num_rows < page.scroll_top ? page.scroll_top : (short)(sts.row - num_rows)) : (sts.row - num_rows < 1 ? (short)1 : (short)(sts.row - num_rows));
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        this._parser.wrap = false;
        return 1;
    }

    short ansi_db_p(PageType page, ListType u_list) {
        this._parser.state = 0;
        return 1;
    }

    short ansi_dch(PageType page, ListType u_list) {
        int i;
        short num_chars;
        StatusType sts = page.status;
        short s = num_chars = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        if (num_chars < 1) {
            num_chars = 1;
        }
        short start = this.offset(sts.row, sts.col);
        short end = this.offset(sts.row, this.PageColumns);
        this.newUpd(u_list, 2, sts.row, sts.col, (short)(this.PageColumns + 1));
        for (i = start + num_chars; i <= end; ++i) {
            page.page[i - num_chars].copyFrom(page.page[i]);
        }
        for (i = (int)end; i >= end - num_chars; --i) {
            page.page[i].clear();
        }
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        return 1;
    }

    short ansi_decdhl(PageType page, ListType u_list) {
        return 1;
    }

    short ansi_decdwl(PageType page, ListType u_list) {
        return 1;
    }

    short ansi_decrc(PageType page, ListType u_list) {
        StatusType sts = page.status = page.save;
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        return 1;
    }

    short ansi_decsc(PageType page, ListType u_list) {
        page.save = page.status;
        this._parser.state = 0;
        return 1;
    }

    short ansi_decstbm(PageType page, ListType u_list) {
        short bottom;
        short top;
        StatusType sts = page.status;
        switch (this._parser.param_cnt) {
            case 0: {
                top = 1;
                bottom = this.ScrollBot;
                break;
            }
            case 1: {
                top = this._parser.params[0];
                bottom = this.ScrollBot;
                break;
            }
            case 2: {
                top = this._parser.params[0];
                bottom = this._parser.params[1];
                break;
            }
            default: {
                this._parser.state = 0;
                return 1;
            }
        }
        if (top < 1) {
            top = 1;
        }
        if (bottom > this.PageRows) {
            bottom = this.ScrollBot;
        }
        if (bottom > top) {
            page.scroll_top = top;
            page.scroll_bot = bottom;
            sts.row = 1;
            sts.col = 1;
            this.newUpd(u_list, 1, (short)1, (short)1, (short)1);
            this._parser.wrap = false;
        }
        this._parser.state = 0;
        this._parser.scrolled = false;
        return 1;
    }

    short ansi_decswl(PageType page, ListType u_list) {
        return 1;
    }

    short ansi_dG0(char ch, PageType page) {
        if (this.isprint(ch)) {
            page.status.G0_set = ch;
        }
        this._parser.state = 0;
        return 1;
    }

    short ansi_dG1(char ch, PageType page) {
        if (this.isprint(ch)) {
            page.status.G1_set = ch;
        }
        this._parser.state = 0;
        return 1;
    }

    short ansi_dl(PageType page, ListType u_list) {
        short num_lines;
        StatusType sts = page.status;
        if (sts.row < page.scroll_top || sts.row > page.scroll_bot) {
            this._parser.state = 0;
            return 1;
        }
        short s = num_lines = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        if (num_lines < 1) {
            num_lines = 1;
        }
        if (num_lines + sts.row > page.scroll_bot) {
            num_lines = (short)(page.scroll_bot - sts.row);
        }
        if (this.ansi_scroll(page, u_list, num_lines, (short)0, sts.row) == -1) {
            this._parser.state = 0;
            return -1;
        }
        sts.col = 1;
        this.newUpd(u_list, 1, sts.row, (short)1, (short)1);
        this._parser.state = 0;
        this._parser.wrap = false;
        return 1;
    }

    short ansi_ed(PageType page, ListType u_list) {
        StatusType sts = page.status;
        this._parser.params[0] = this._parser.param_cnt == 0 ? (short)0 : this._parser.params[0];
        short col = sts.col;
        short row = sts.row;
        switch (this._parser.params[0]) {
            case 0: {
                short end = this.offset(this.PageRows, this.PageColumns);
                short pg_pos = this.offset(sts.row, sts.col);
                short rows_needed = (short)(this.PageRows - sts.row + 1);
                u_list.upd_list[u_list.index].upd_end = this.EndOfRow;
                for (short i = pg_pos; i <= end; i = (short)(i + 1)) {
                    if (col <= this.PageColumns) {
                        col = (short)(col + 1);
                    } else {
                        col = 1;
                        row = (short)(row + 1);
                        this.newUpd(u_list, rows_needed, row, (short)1, this.EndOfRow);
                        rows_needed = (short)(rows_needed - 1);
                    }
                    page.page[i].clear();
                }
                this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
                break;
            }
            case 1: {
                short start = this.offset((short)1, (short)1);
                short pg_pos = this.offset(sts.row, sts.col);
                row = 1;
                u_list.upd_list[u_list.index].row = 1;
                u_list.upd_list[u_list.index].upd_beg = 1;
                short rows_needed = sts.row;
                for (short i = start; i <= pg_pos; i = (short)(i + 1)) {
                    if (col <= this.PageColumns) {
                        col = (short)(col + 1);
                    } else {
                        col = 1;
                        row = (short)(row + 1);
                        u_list.upd_list[u_list.index].upd_end = this.EndOfRow;
                        this.newUpd(u_list, rows_needed, row, (short)1, (short)1);
                        rows_needed = (short)(rows_needed - 1);
                    }
                    page.page[i].clear();
                }
                u_list.upd_list[u_list.index].upd_end = sts.col;
                break;
            }
            case 2: {
                short start = this.offset((short)1, (short)1);
                for (row = 1; row <= this.PageRows; row = (short)(row + 1)) {
                    for (col = 1; col <= this.PageColumns; col = (short)(col + 1)) {
                        page.page[col].clear();
                    }
                    this.newUpd(u_list, this.PageRows - row + 2, row, (short)1, this.EndOfRow);
                }
                this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
                break;
            }
        }
        this._parser.state = 0;
        return 1;
    }

    short ansi_el(PageType page, ListType u_list) {
        StatusType sts = page.status;
        this._parser.params[0] = this._parser.param_cnt == 0 ? (short)0 : this._parser.params[0];
        switch (this._parser.params[0]) {
            case 0: {
                short pg_pos;
                short end = this.offset(sts.row, this.PageColumns);
                for (short i = pg_pos = this.offset(sts.row, sts.col); i <= end; i = (short)(i + 1)) {
                    page.page[i].clear();
                }
                u_list.upd_list[u_list.index].upd_end = this.EndOfRow;
                break;
            }
            case 1: {
                short start = this.offset(sts.row, (short)1);
                short pg_pos = this.offset(sts.row, sts.col);
                u_list.upd_list[u_list.index].upd_beg = 1;
                for (short i = start; i <= pg_pos; i = (short)(i + 1)) {
                    page.page[i].clear();
                }
                break;
            }
            case 2: {
                short start = this.offset(sts.row, (short)1);
                short end = this.offset(sts.row, this.PageColumns);
                for (short i = start; i <= end; i = (short)(i + 1)) {
                    page.page[i].clear();
                }
                u_list.upd_list[u_list.index].upd_beg = 1;
                u_list.upd_list[u_list.index].upd_end = this.EndOfRow;
                break;
            }
            default: {
                this._parser.state = 0;
                return 1;
            }
        }
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        return 1;
    }

    short ansi_esc() {
        this._parser.state = 1;
        this._parser.special_esc = '\u0000';
        return 1;
    }

    short ansi_ich(PageType page, ListType u_list) {
        int i;
        short num_cols;
        StatusType sts = page.status;
        int startpg = this.offset(sts.row, sts.col);
        short s = num_cols = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        if (num_cols < 1) {
            num_cols = 1;
        }
        if (num_cols + sts.col > this.PageColumns) {
            num_cols = (short)(this.PageColumns - sts.col + 1);
        }
        int endpg = this.offset(sts.row, this.PageColumns);
        this.newUpd(u_list, 2, sts.row, sts.col, (short)(this.PageColumns + 1));
        for (i = endpg; i >= startpg + num_cols; --i) {
            page.page[i].copyFrom(page.page[i - num_cols]);
        }
        for (i = startpg; i < startpg + num_cols; ++i) {
            page.page[i].clear();
        }
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        return 1;
    }

    short ansi_il(PageType page, ListType u_list) {
        short num_lines;
        StatusType sts = page.status;
        if (sts.row < page.scroll_top || sts.row > page.scroll_bot) {
            this._parser.state = 0;
            return 1;
        }
        short s = num_lines = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        if (num_lines < 1) {
            num_lines = 1;
        }
        if (num_lines + sts.row > page.scroll_bot) {
            num_lines = (short)(page.scroll_bot - sts.row);
        }
        sts.col = 1;
        this._parser.wrap = false;
        if (this.ansi_scroll(page, u_list, num_lines, (short)1, sts.row) == -1) {
            this._parser.state = 0;
            return -1;
        }
        this.newUpd(u_list, 1, sts.row, (short)1, (short)1);
        this._parser.state = 0;
        return 1;
    }

    short ansi_lf(PageType page, ListType u_list) {
        StatusType sts = page.status;
        if (sts.row == page.scroll_bot) {
            if (this.ansi_scroll(page, u_list, (short)1, (short)0, page.scroll_top) == -1) {
                this._parser.state = 0;
                return -1;
            }
            this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
            this._parser.cr_state = 21;
            this._parser.state = 0;
            this._parser.wrap = false;
            return 1;
        }
        if (sts.row == this.PageRows) {
            this._parser.state = 0;
            return 1;
        }
        sts.row = (short)(sts.row + 1);
        if (this._parser.cr_state != 20) {
            this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        } else {
            u_list.upd_list[u_list.index].row = sts.row;
        }
        this._parser.cr_state = 21;
        this._parser.state = 0;
        this._parser.wrap = false;
        return 1;
    }

    short ansi_nel(PageType page, ListType u_list) {
        page.status.col = 1;
        if (this.ansi_lf(page, u_list) < 0) {
            return -1;
        }
        this._parser.wrap = false;
        this._parser.state = 0;
        return 1;
    }

    short ansi_nop() {
        this._parser.state = 0;
        return 1;
    }

    short ansi_param(char ch, PageType page) {
        if (this._parser.param_cnt == 0) {
            this._parser.param_cnt = (short)(this._parser.param_cnt + 1);
        }
        if (this._parser.param_cnt > 20) {
            return 1;
        }
        int n = this._parser.param_cnt - 1;
        this._parser.params[n] = (short)(this._parser.params[n] * 10);
        int n2 = this._parser.param_cnt - 1;
        this._parser.params[n2] = (short)(this._parser.params[n2] + (ch - 48));
        return 1;
    }

    short ansi_pch(char b, PageType page, ByteArrayInputStream data, ListType u_list) {
        int txt_left = this._parser.txt_lngth;
        StatusType status = page.status;
        UpdateType upd_ptr = u_list.upd_list[u_list.index];
        int chptrindex = this.offset(status.row, status.col);
        CharType chptr = page.page[chptrindex];
        this._parser.cr_state = 0;
        while (this.isprint(b) || b == '\u0000') {
            if (b != '\u0000') {
                if (this._parser.wrap) {
                    if (status.row == page.scroll_bot) {
                        if (this.ansi_scroll(page, u_list, (short)1, (short)0, page.scroll_top) == -1) {
                            return (short)(this._parser.txt_lngth - txt_left);
                        }
                        status.col = 1;
                        this.newUpd(u_list, 1, status.row, (short)1, (short)1);
                    } else if (status.row != this.PageRows) {
                        if (u_list.index >= u_list.upd_list.length - 1) {
                            return (short)(this._parser.txt_lngth - txt_left);
                        }
                        status.col = 1;
                        status.row = (short)(status.row + 1);
                        this.newUpd(u_list, 1, status.row, (short)1, (short)1);
                    }
                    chptrindex = this.offset(status.row, status.col);
                    chptr = page.page[chptrindex];
                    upd_ptr = u_list.upd_list[u_list.index];
                    this._parser.wrap = false;
                }
                chptr.ch = b;
                chptr.attr = status.cur_attr;
                chptr.c_attr = status.c_attr;
                chptr.c_fade_attr = status.c_fade_attr;
                chptr.fade_attr = status.fading;
                chptr.gs = status.gr_set == '\u0001' ? status.G1_set : status.G0_set;
                if (status.col >= this.PageColumns) {
                    upd_ptr.upd_end = this.EndOfRow;
                    if (status.wrap_on) {
                        this._parser.wrap = true;
                    }
                } else {
                    status.col = (short)(status.col + 1);
                    upd_ptr.upd_end = (short)(upd_ptr.upd_end + 1);
                    chptr = page.page[++chptrindex];
                }
            }
            data.mark(this._parser.txt_lngth);
            b = (char)(data.read() & 0x7F);
            if (--txt_left != 0 && b >= '\u0000') continue;
        }
        data.reset();
        return (short)(this._parser.txt_lngth - txt_left + 1);
    }

    short ansi_poscur(PageType page, ListType u_list) {
        short col;
        short row;
        StatusType sts = page.status;
        switch (this._parser.param_cnt) {
            case 0: {
                row = 1;
                col = 1;
                break;
            }
            case 1: {
                row = this._parser.params[0];
                col = 1;
                break;
            }
            case 2: {
                row = this._parser.params[0];
                col = this._parser.params[1];
                break;
            }
            default: {
                this._parser.state = 0;
                return 1;
            }
        }
        if (row == 0) {
            row = 1;
        }
        if (col == 0) {
            col = 1;
        }
        if (row > this.PageRows || col > this.PageColumns) {
            this._parser.state = 0;
            return 1;
        }
        sts.row = row;
        sts.col = col;
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        this._parser.wrap = false;
        return 1;
    }

    short ansi_ri(PageType page, ListType u_list) {
        StatusType sts = page.status;
        if (sts.row == page.scroll_top) {
            if (this.ansi_scroll(page, u_list, (short)1, (short)1, sts.row) == -1) {
                this._parser.state = 0;
                return -1;
            }
            this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
            this._parser.state = 0;
            this._parser.wrap = false;
            return 1;
        }
        if (sts.row == 1) {
            this._parser.state = 0;
            this._parser.wrap = false;
            return 1;
        }
        sts.row = (short)(sts.row - 1);
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        this._parser.wrap = false;
        return 1;
    }

    short ansi_rm(PageType page) {
        block9: {
            block8: {
                StatusType sts = page.status;
                if (this._parser.special_esc == '\u0000') break block8;
                switch (this._parser.special_esc) {
                    case '?': {
                        if (this._parser.params[0] == 7) {
                            sts.wrap_on = false;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block9;
            }
            switch (this._parser.params[0]) {
                case 7: {
                    sts.vem = false;
                    break;
                }
                case 16: {
                    sts.hem = false;
                    break;
                }
            }
        }
        this._parser.state = 0;
        return 1;
    }

    short ansi_scroll(PageType page, ListType u_list, short num, short dir, short row) {
        if (num == 0) {
            return 1;
        }
        if (page.scroll_bot - page.scroll_top + u_list.index + 2 >= u_list.upd_list.length) {
            return -1;
        }
        switch (dir) {
            case 1: {
                short j;
                short start = this.offset(row, (short)1);
                short num_chars = (short)(num * this.PageColumns);
                short scroll = (short)(start + num_chars - 1);
                for (j = this.offset(page.scroll_bot, this.EndOfRow); j > scroll; j = (short)(j - 1)) {
                    page.page[j].copyFrom(page.page[j - num_chars]);
                }
                for (j = start; j <= scroll; j = (short)(j + 1)) {
                    page.page[j].clear();
                }
                if (row != page.scroll_top || !this._parser.scrolled) {
                    for (j = row; j <= page.scroll_bot; j = (short)(j + 1)) {
                        this.newUpd(u_list, 1, j, (short)1, this.EndOfRow);
                    }
                }
                if (row != page.scroll_top) break;
                this._parser.scrolled = true;
                break;
            }
            case 0: {
                short j;
                if (row + num > page.scroll_bot) {
                    num = (short)(page.scroll_bot - row + 1);
                }
                short num_chars = (short)(num * this.PageColumns);
                short scroll = this.offset(page.scroll_bot, this.EndOfRow);
                short end = (short)(scroll - num_chars);
                for (j = this.offset(row, 1); j <= end; j = (short)(j + 1)) {
                    page.page[j] = page.page[j + num_chars];
                }
                for (j = (short)(scroll - num_chars); j < scroll; j = (short)(j + 1)) {
                    page.page[j].clear();
                }
                if (row != page.scroll_top || !this._parser.scrolled) {
                    for (j = row; j <= page.scroll_bot; j = (short)(j + 1)) {
                        this.newUpd(u_list, 1, j, (short)1, this.EndOfRow);
                    }
                }
                if (row != page.scroll_top) break;
                this._parser.scrolled = true;
                break;
            }
        }
        return 1;
    }

    short ansi_sd(PageType page, ListType u_list) {
        short num_lines;
        StatusType sts = page.status;
        if (sts.row < page.scroll_top || sts.row > page.scroll_bot) {
            this._parser.state = 0;
            return 1;
        }
        short s = num_lines = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        if (num_lines < 1) {
            num_lines = 1;
        }
        if (this.ansi_scroll(page, u_list, num_lines, (short)1, sts.row) == -1) {
            this._parser.state = 0;
            return -1;
        }
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        return 1;
    }

    short ansi_sgr(PageType page, ListType u_list) {
        StatusType sts = page.status;
        if (this._parser.special_esc == '?') {
            this._parser.state = 0;
            return 1;
        }
        if (this._parser.special_esc == '>') {
            sts.setFade(true);
        } else {
            sts.setFade(false);
        }
        if (this._parser.param_cnt == 0) {
            sts.setplain();
            sts.setcolor('\u00ff');
        }
        block12: for (short i = 0; i < this._parser.param_cnt; i = (short)(i + 1)) {
            if (this._parser.params[i] >= 30 && this._parser.params[i] < 38) {
                if (sts._fade) {
                    sts.c_fade_attr = (char)(sts.c_fade_attr & 0xF0);
                    sts.c_fade_attr = (char)(sts.c_fade_attr + (this._parser.params[i] - 30));
                    continue;
                }
                sts.c_attr = (char)(sts.c_attr & 0xF0);
                sts.c_attr = (char)(sts.c_attr + (this._parser.params[i] - 30));
                continue;
            }
            if (this._parser.params[i] >= 40 && this._parser.params[i] < 48) {
                if (sts._fade) {
                    sts.c_fade_attr = (char)(sts.c_fade_attr & 0xF);
                    sts.c_fade_attr = (char)(sts.c_fade_attr + (this._parser.params[i] - 40 << 4));
                    continue;
                }
                sts.c_attr = (char)(sts.c_attr & 0xF);
                sts.c_attr = (char)(sts.c_attr + (this._parser.params[i] - 40 << 4));
                continue;
            }
            switch (this._parser.params[i]) {
                case 0: {
                    sts.setcolor('\u00ff');
                    sts.setattr('\u0000');
                    continue block12;
                }
                case 1: {
                    sts.onattr('\u0010');
                    continue block12;
                }
                case 2: {
                    sts.onattr('\u0004');
                    continue block12;
                }
                case 4: {
                    sts.onattr('\b');
                    continue block12;
                }
                case 5: {
                    sts.onattr('\u0001');
                    continue block12;
                }
                case 7: {
                    sts.onattr('\u0002');
                    continue block12;
                }
                case 22: {
                    sts.offattr('\u0014');
                    continue block12;
                }
                case 24: {
                    sts.offattr('\b');
                    continue block12;
                }
                case 25: {
                    sts.offattr('\u0001');
                    continue block12;
                }
                case 27: {
                    sts.offattr('\u0002');
                    continue block12;
                }
            }
        }
        this._parser.state = 0;
        return 1;
    }

    short ansi_si(PageType page, ListType u_list) {
        page.status.gr_set = '\u0000';
        this._parser.state = 0;
        return 1;
    }

    short ansi_sm(PageType page) {
        block9: {
            block8: {
                StatusType sts = page.status;
                if (this._parser.special_esc == '\u0000') break block8;
                switch (this._parser.special_esc) {
                    case '?': {
                        if (this._parser.params[0] == 7) {
                            sts.wrap_on = true;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block9;
            }
            switch (this._parser.params[0]) {
                case 7: {
                    sts.vem = true;
                    break;
                }
                case 16: {
                    sts.hem = true;
                    break;
                }
            }
        }
        this._parser.state = 0;
        return 1;
    }

    short ansi_so(PageType page, ListType u_list) {
        page.status.gr_set = '\u0001';
        this._parser.state = 0;
        return 1;
    }

    short ansi_spesc(char ch) {
        this._parser.special_esc = ch;
        return 1;
    }

    short ansi_stG0() {
        this._parser.state = 3;
        return 1;
    }

    short ansi_stG1() {
        this._parser.state = 4;
        return 1;
    }

    short ansi_su(PageType page, ListType u_list) {
        short num_lines;
        StatusType sts = page.status;
        if (sts.row < page.scroll_top || sts.row > page.scroll_bot) {
            this._parser.state = 0;
            return 1;
        }
        short s = num_lines = this._parser.param_cnt == 0 ? (short)1 : this._parser.params[0];
        if (num_lines < 1) {
            num_lines = 1;
        }
        if (this.ansi_scroll(page, u_list, num_lines, (short)0, sts.row) == -1) {
            this._parser.state = 0;
            return -1;
        }
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        this._parser.state = 0;
        return 1;
    }

    short ansi_tab(PageType page, ListType u_list) {
        if (page.status.col <= TAB_TABLE.length) {
            page.status.col = TAB_TABLE[page.status.col - 1];
            this.newUpd(u_list, 1, page.status.row, page.status.col, page.status.col);
        }
        this._parser.state = 0;
        return 1;
    }

    short do_decode(char ch, PageType page, ByteArrayInputStream data, ListType u_list) {
        short ret = 0;
        switch (this._parser.state) {
            case 0: {
                ret = this.do_decode_init(ch, page, data, u_list);
                break;
            }
            case 1: {
                ret = this.do_decode_escape(ch, page, u_list);
                break;
            }
            case 2: {
                ret = this.do_decode_csi(ch, page, u_list);
                break;
            }
            case 3: {
                ret = this.do_decode_G0(ch, page);
                break;
            }
            case 4: {
                ret = this.do_decode_G1(ch, page);
                break;
            }
            case 5: {
                ret = this.do_decode_character_size(ch, page, data, u_list);
                break;
            }
        }
        return ret;
    }

    short do_decode_character_size(char ch, PageType page, ByteArrayInputStream data, ListType u_list) {
        short ret = 0;
        ret = ch == '\u001b' ? this.ansi_esc() : this.ansi_nop();
        return ret;
    }

    short do_decode_csi(char ch, PageType page, ListType u_list) {
        short ret = 0;
        if (ch < '0') {
            ret = this.ansi_nop();
        } else if (ch < ':') {
            ret = this.ansi_param(ch, page);
        } else {
            switch (ch) {
                case ';': {
                    ret = this.ansi_chparm();
                    break;
                }
                case '=': 
                case '>': 
                case '?': {
                    ret = this.ansi_spesc(ch);
                    break;
                }
                case '@': {
                    ret = this.ansi_ich(page, u_list);
                    break;
                }
                case 'A': {
                    ret = this.ansi_cuu(page, u_list);
                    break;
                }
                case 'B': {
                    ret = this.ansi_cud(page, u_list);
                    break;
                }
                case 'C': {
                    ret = this.ansi_cuf(page, u_list);
                    break;
                }
                case 'D': {
                    ret = this.ansi_cub(page, u_list);
                    break;
                }
                case 'H': {
                    ret = this.ansi_poscur(page, u_list);
                    break;
                }
                case 'J': {
                    ret = this.ansi_ed(page, u_list);
                    break;
                }
                case 'K': {
                    ret = this.ansi_el(page, u_list);
                    break;
                }
                case 'L': {
                    ret = this.ansi_il(page, u_list);
                    break;
                }
                case 'M': {
                    ret = this.ansi_dl(page, u_list);
                    break;
                }
                case 'P': {
                    ret = this.ansi_dch(page, u_list);
                    break;
                }
                case 'S': {
                    ret = this.ansi_su(page, u_list);
                    break;
                }
                case 'T': {
                    ret = this.ansi_sd(page, u_list);
                    break;
                }
                case 'Z': {
                    ret = this.ansi_db_p(page, u_list);
                    break;
                }
                case 'f': {
                    ret = this.ansi_poscur(page, u_list);
                    break;
                }
                case 'h': {
                    ret = this.ansi_sm(page);
                    break;
                }
                case 'l': {
                    ret = this.ansi_rm(page);
                    break;
                }
                case 'm': {
                    ret = this.ansi_sgr(page, u_list);
                    break;
                }
                case 'p': {
                    ret = this.qa_reset(page, u_list);
                    break;
                }
                case 'r': {
                    ret = this.ansi_decstbm(page, u_list);
                    break;
                }
                default: {
                    ret = this.ansi_nop();
                }
            }
        }
        return ret;
    }

    short do_decode_escape(char ch, PageType page, ListType u_list) {
        short ret = 0;
        switch (ch) {
            case '\u001b': {
                ret = this.ansi_esc();
                break;
            }
            case '(': {
                ret = this.ansi_stG0();
                break;
            }
            case ')': {
                ret = this.ansi_stG1();
                break;
            }
            case '7': {
                ret = this.ansi_decsc(page, u_list);
                break;
            }
            case '8': {
                ret = this.ansi_decrc(page, u_list);
                break;
            }
            case 'D': {
                ret = this.ansi_lf(page, u_list);
                break;
            }
            case 'E': {
                ret = this.ansi_nel(page, u_list);
                break;
            }
            case 'M': {
                ret = this.ansi_ri(page, u_list);
                break;
            }
            case '[': {
                ret = this.ansi_csi();
                break;
            }
            case 'c': {
                ret = this.qa_reset(page, u_list);
                break;
            }
            default: {
                ret = this.ansi_nop();
            }
        }
        return ret;
    }

    short do_decode_G0(char ch, PageType page) {
        short ret = 0;
        ret = ch < '0' || ch == '\u007f' ? this.ansi_nop() : this.ansi_dG0(ch, page);
        return ret;
    }

    short do_decode_G1(char ch, PageType page) {
        short ret = 0;
        ret = ch < '0' || ch == '\u007f' ? this.ansi_nop() : this.ansi_dG1(ch, page);
        return ret;
    }

    short do_decode_init(char ch, PageType page, ByteArrayInputStream data, ListType u_list) {
        short ret = 0;
        switch (ch) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': {
                ret = this.ansi_nop();
                break;
            }
            case '\b': {
                ret = this.ansi_cub(page, u_list);
                break;
            }
            case '\t': {
                ret = this.ansi_tab(page, u_list);
                break;
            }
            case '\n': {
                ret = this.ansi_lf(page, u_list);
                break;
            }
            case '\u000b': 
            case '\f': {
                ret = this.ansi_nop();
                break;
            }
            case '\r': {
                ret = this.ansi_cret(page, u_list);
                break;
            }
            case '\u000e': {
                ret = this.ansi_so(page, u_list);
                break;
            }
            case '\u000f': {
                ret = this.ansi_si(page, u_list);
                break;
            }
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': {
                ret = this.ansi_nop();
                break;
            }
            case '\u001b': {
                ret = this.ansi_esc();
                break;
            }
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case '\u007f': {
                ret = this.ansi_nop();
                break;
            }
            default: {
                ret = this.ansi_pch(ch, page, data, u_list);
            }
        }
        return ret;
    }

    boolean isprint(char ch) {
        return ' ' <= ch && ch < '\u007f';
    }

    short newUpd(ListType upd, int req, short row, short beg, short end) {
        if (upd.index >= upd.upd_list.length - req) {
            return -1;
        }
        upd.index = (short)(upd.index + 1);
        upd.upd_list[upd.index].row = row;
        upd.upd_list[upd.index].upd_beg = beg;
        upd.upd_list[upd.index].upd_end = end;
        return 1;
    }

    short offset(short row, short col) {
        return (short)((row - 1) * this.PageColumns + (col - 1));
    }

    @Override
    public int qa_decode(PageType page, ByteArrayInputStream is, ListType u_list) {
        this._parser = new ParserType();
        u_list.index = 0;
        u_list.upd_list[u_list.index].row = page.status.row;
        u_list.upd_list[u_list.index].upd_beg = page.status.col;
        u_list.upd_list[u_list.index].upd_end = page.status.col;
        int len = is.available();
        this._parser.txt_lngth = (short)len;
        int start_len = len;
        int datum = is.read();
        while (datum > 0) {
            char ch = (char)(datum & 0x7F);
            short ret = this.do_decode(ch, page, is, u_list);
            if (ret == -1) {
                if (this._parser.txt_lngth == start_len) {
                    return start_len;
                }
                return start_len - this._parser.txt_lngth;
            }
            if (ret == 0) {
                return start_len - this._parser.txt_lngth;
            }
            len -= ret;
            if (this._parser.state == 0) {
                this._parser.txt_lngth = (short)len;
                this._parser.param_cnt = 0;
                this._parser.params[0] = 0;
                this._parser.special_esc = '\u0000';
            }
            datum = is.read();
        }
        return start_len;
    }

    @Override
    public short qa_end_of_row() {
        return this.EndOfRow;
    }

    @Override
    public short qa_page_columns() {
        return this.PageColumns;
    }

    @Override
    public short qa_page_rows() {
        return this.PageRows;
    }

    public short qa_reset(PageType page, ListType u_list) {
        short i;
        StatusType sts = page.status;
        StatusType save = page.save;
        for (i = 0; i < this.PageRows * this.PageColumns; i = (short)((short)(i + 1))) {
            page.page[i].clear();
        }
        save.row = 1;
        sts.row = 1;
        save.col = 1;
        sts.col = 1;
        save.cur_attr = '\u0000';
        sts.cur_attr = '\u0000';
        save.c_attr = (char)255;
        sts.c_attr = (char)255;
        save.c_fade_attr = (char)255;
        sts.c_fade_attr = (char)255;
        save.fading = '\u0000';
        sts.fading = '\u0000';
        save.gr_set = '\u0000';
        sts.gr_set = '\u0000';
        save.wrap_on = false;
        sts.wrap_on = false;
        page.scroll_top = 1;
        page.scroll_bot = (short)(this.PageColumns - 1);
        u_list.index = 0;
        for (i = 1; i <= this.PageRows; i = (short)(i + 1)) {
            this.newUpd(u_list, this.PageRows - i + 1, i, (short)1, (short)(this.PageColumns + 1));
        }
        this.newUpd(u_list, 1, sts.row, sts.col, sts.col);
        if (this._parser != null) {
            this._parser.state = 0;
        }
        return 1;
    }

    @Override
    public short qa_scroll_bot() {
        return this.ScrollBot;
    }

    @Override
    public void qa_set_columns(short cl) {
        this.PageColumns = cl;
    }

    @Override
    public void qa_set_end_of_row(short rw) {
        this.EndOfRow = rw;
    }

    @Override
    public void qa_set_rows(short rw) {
        this.PageRows = rw;
    }

    @Override
    public void qa_set_scroll_bot(short cl) {
        this.ScrollBot = cl;
    }
}

