/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask;

import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.redmadrobot.inputmask.MaskedTextChangedListener;
import com.redmadrobot.inputmask.helper.Mask;
import com.redmadrobot.inputmask.model.CaretString;
import com.redmadrobot.inputmask.model.Notation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rBA\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0010BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J(\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0016J \u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/redmadrobot/inputmask/PolyMaskTextChangedListener;", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener;", "format", "", "affineFormats", "", "field", "Landroid/widget/EditText;", "valueListener", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "(Ljava/lang/String;Ljava/util/List;Landroid/widget/EditText;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "listener", "Landroid/text/TextWatcher;", "(Ljava/lang/String;Ljava/util/List;Landroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "autocomplete", "", "(Ljava/lang/String;Ljava/util/List;ZLandroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "customNotations", "Lcom/redmadrobot/inputmask/model/Notation;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;ZLandroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "calculateAffinity", "", "mask", "Lcom/redmadrobot/inputmask/helper/Mask;", "text", "caretPosition", "onFocusChange", "", "view", "Landroid/view/View;", "hasFocus", "onTextChanged", "", "cursorPosition", "before", "count", "pickMask", "setText", "inputmask_release"})
public final class PolyMaskTextChangedListener
extends MaskedTextChangedListener {
    private List<String> affineFormats;
    private final List<Notation> customNotations;

    @Override
    public void setText(@NotNull String text) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Mask.Result result = this.pickMask(text, text.length(), this.getAutocomplete()).apply(new CaretString(text, text.length()), this.getAutocomplete());
            EditText editText = (EditText)this.getField().get();
            if (editText != null) {
                editText.setText((CharSequence)result.getFormattedText().getString());
            }
            EditText editText2 = (EditText)this.getField().get();
            if (editText2 != null) {
                editText2.setSelection(result.getFormattedText().getCaretPosition());
            }
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener == null) break block2;
            valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
        }
    }

    @Override
    public void onTextChanged(@NotNull CharSequence text, int cursorPosition, int before, int count) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            boolean isDeletion = before > 0 && count == 0;
            Mask.Result result = this.pickMask(((Object)text).toString(), isDeletion ? cursorPosition : cursorPosition + count, this.getAutocomplete() && !isDeletion).apply(new CaretString(((Object)text).toString(), isDeletion ? cursorPosition : cursorPosition + count), this.getAutocomplete() && !isDeletion);
            this.setAfterText(result.getFormattedText().getString());
            this.setCaretPosition(isDeletion ? cursorPosition : result.getFormattedText().getCaretPosition());
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener == null) break block0;
            valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
        }
    }

    @Override
    public void onFocusChange(@Nullable View view, boolean hasFocus) {
        block6: {
            String string;
            CharSequence charSequence;
            if (!this.getAutocomplete() || !hasFocus) break block6;
            EditText editText = (EditText)this.getField().get();
            Object object = editText != null ? editText.getText() : null;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if ((charSequence = (CharSequence)object).length() == 0) {
                string = "";
            } else {
                EditText editText2 = (EditText)this.getField().get();
                string = String.valueOf(editText2 != null ? editText2.getText() : null);
            }
            String text = string;
            Mask.Result result = this.pickMask(text, text.length(), this.getAutocomplete()).apply(new CaretString(text, text.length()), this.getAutocomplete());
            EditText editText3 = (EditText)this.getField().get();
            if (editText3 != null) {
                editText3.setText((CharSequence)result.getFormattedText().getString());
            }
            EditText editText4 = (EditText)this.getField().get();
            if (editText4 != null) {
                editText4.setSelection(result.getFormattedText().getCaretPosition());
            }
            MaskedTextChangedListener.ValueListener valueListener = this.getValueListener();
            if (valueListener != null) {
                valueListener.onTextChanged(result.getComplete(), result.getExtractedValue());
            }
        }
    }

    private final Mask pickMask(String text, int caretPosition, boolean autocomplete) {
        int primaryAffinity = this.calculateAffinity(this.getMask(), text, caretPosition, autocomplete);
        List masks = new ArrayList();
        for (String format : this.affineFormats) {
            Mask mask = Mask.Factory.getOrCreate(format, this.customNotations);
            int affinity = this.calculateAffinity(mask, text, caretPosition, autocomplete);
            masks.add(new Pair((Object)mask, (Object)affinity));
        }
        List $receiver$iv = masks;
        if ($receiver$iv.size() > 1) {
            Object object = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Pair item = (Pair)a;
                    Comparable comparable = Integer.valueOf(((Number)item.getSecond()).intValue());
                    item = (Pair)b;
                    Comparable comparable2 = comparable;
                    Integer n = ((Number)item.getSecond()).intValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)object, (Comparator)comparator);
        }
        int insertIndex = -1;
        for (Object object : CollectionsKt.withIndex((Iterable)masks)) {
            int index = object.component1();
            Pair maskAffinity = (Pair)object.component2();
            if (primaryAffinity < ((Number)maskAffinity.getSecond()).intValue()) continue;
            insertIndex = index;
            break;
        }
        if (insertIndex >= 0) {
            masks.add(insertIndex, new Pair((Object)this.getMask(), (Object)primaryAffinity));
        } else {
            masks.add(new Pair((Object)this.getMask(), (Object)primaryAffinity));
        }
        return (Mask)((Pair)CollectionsKt.first((List)masks)).getFirst();
    }

    private final int calculateAffinity(Mask mask, String text, int caretPosition, boolean autocomplete) {
        return mask.apply(new CaretString(text, caretPosition), autocomplete).getAffinity();
    }

    public PolyMaskTextChangedListener(@NotNull String format, @NotNull List<String> affineFormats, @NotNull List<Notation> customNotations, boolean autocomplete, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable MaskedTextChangedListener.ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(affineFormats, (String)"affineFormats");
        Intrinsics.checkParameterIsNotNull(customNotations, (String)"customNotations");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        super(format, customNotations, autocomplete, field, listener, valueListener);
        this.affineFormats = affineFormats;
        this.customNotations = customNotations;
    }

    public /* synthetic */ PolyMaskTextChangedListener(String string, List list, List list2, boolean bl, EditText editText, TextWatcher textWatcher, MaskedTextChangedListener.ValueListener valueListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            textWatcher = null;
        }
        if ((n & 0x40) != 0) {
            valueListener = null;
        }
        this(string, list, list2, bl, editText, textWatcher, valueListener);
    }

    public PolyMaskTextChangedListener(@NotNull String format, @NotNull List<String> affineFormats, @NotNull EditText field, @Nullable MaskedTextChangedListener.ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(affineFormats, (String)"affineFormats");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this(format, affineFormats, field, null, valueListener);
    }

    public PolyMaskTextChangedListener(@NotNull String format, @NotNull List<String> affineFormats, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable MaskedTextChangedListener.ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(affineFormats, (String)"affineFormats");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this(format, affineFormats, true, field, listener, valueListener);
    }

    public PolyMaskTextChangedListener(@NotNull String format, @NotNull List<String> affineFormats, boolean autocomplete, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable MaskedTextChangedListener.ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull(affineFormats, (String)"affineFormats");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this(format, affineFormats, CollectionsKt.emptyList(), autocomplete, field, listener, valueListener);
    }
}

