/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.CaretStringIterator;
import com.redmadrobot.inputmask.helper.Compiler;
import com.redmadrobot.inputmask.helper.Mask$WhenMappings;
import com.redmadrobot.inputmask.model.CaretString;
import com.redmadrobot.inputmask.model.Next;
import com.redmadrobot.inputmask.model.State;
import com.redmadrobot.inputmask.model.state.EOLState;
import com.redmadrobot.inputmask.model.state.FixedState;
import com.redmadrobot.inputmask.model.state.FreeState;
import com.redmadrobot.inputmask.model.state.OptionalValueState;
import com.redmadrobot.inputmask.model.state.ValueState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u001a\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/redmadrobot/inputmask/helper/Mask;", "", "format", "", "(Ljava/lang/String;)V", "initialState", "Lcom/redmadrobot/inputmask/model/State;", "acceptableTextLength", "", "acceptableValueLength", "appendPlaceholder", "state", "placeholder", "apply", "Lcom/redmadrobot/inputmask/helper/Mask$Result;", "text", "Lcom/redmadrobot/inputmask/model/CaretString;", "autocomplete", "", "totalTextLength", "totalValueLength", "Result", "inputmask-compileReleaseKotlin"})
public final class Mask {
    private final State initialState;

    @NotNull
    public final Result apply(@NotNull CaretString text, boolean autocomplete) {
        Next next;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        CaretStringIterator iterator = new CaretStringIterator(text);
        String extractedValue = "";
        String modifiedString = "";
        int modifiedCaretPosition = text.getCaretPosition();
        State state = this.initialState;
        boolean beforeCaret = iterator.beforeCaret();
        Character character = iterator.next();
        while (character != null) {
            next = state.accept(character.charValue());
            if (next != null) {
                state = next.getState();
                StringBuilder stringBuilder = new StringBuilder().append(modifiedString);
                Object object = next.getInsert();
                if (object == null) {
                    object = "";
                }
                modifiedString = stringBuilder.append(object).toString();
                StringBuilder stringBuilder2 = new StringBuilder().append(extractedValue);
                Object object2 = next.getValue();
                if (object2 == null) {
                    object2 = "";
                }
                extractedValue = stringBuilder2.append(object2).toString();
                if (next.getPass()) {
                    beforeCaret = iterator.beforeCaret();
                    character = iterator.next();
                    continue;
                }
                if (!beforeCaret || next.getInsert() == null) continue;
                ++modifiedCaretPosition;
                continue;
            }
            if (iterator.beforeCaret()) {
                --modifiedCaretPosition;
            }
            beforeCaret = iterator.beforeCaret();
            character = iterator.next();
        }
        while (autocomplete && beforeCaret && (next = state.autocomplete()) != null) {
            state = next.getState();
            modifiedString = modifiedString + (next.getInsert() != null ? next.getInsert() : "");
            extractedValue = extractedValue + (next.getValue() != null ? next.getValue() : "");
            if (next.getInsert() == null) continue;
            ++modifiedCaretPosition;
        }
        return new Result(new CaretString(modifiedString, modifiedCaretPosition), extractedValue);
    }

    @NotNull
    public final String placeholder() {
        return this.appendPlaceholder(this.initialState, "");
    }

    public final int acceptableTextLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof FreeState) && !(state instanceof ValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int totalTextLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof FreeState) && !(state instanceof ValueState) && !(state instanceof OptionalValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int acceptableValueLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof ValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int totalValueLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof ValueState) && !(state instanceof OptionalValueState)) continue;
            ++length;
        }
        return length;
    }

    private final String appendPlaceholder(State state, String placeholder) {
        if (state == null) {
            return placeholder;
        }
        if (state instanceof EOLState) {
            return placeholder;
        }
        if (state instanceof FixedState) {
            return this.appendPlaceholder(state.getChild(), placeholder + ((FixedState)state).getOwnCharacter());
        }
        if (state instanceof FreeState) {
            return this.appendPlaceholder(state.getChild(), placeholder + ((FreeState)state).getOwnCharacter());
        }
        if (state instanceof OptionalValueState) {
            switch (Mask$WhenMappings.$EnumSwitchMapping$0[((OptionalValueState)state).getType().ordinal()]) {
                case 1: {
                    return this.appendPlaceholder(state.getChild(), placeholder + "-");
                }
                case 2: {
                    return this.appendPlaceholder(state.getChild(), placeholder + "a");
                }
                case 3: {
                    return this.appendPlaceholder(state.getChild(), placeholder + "0");
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        if (state instanceof ValueState) {
            switch (Mask$WhenMappings.$EnumSwitchMapping$1[((ValueState)state).getType().ordinal()]) {
                case 1: {
                    return this.appendPlaceholder(state.getChild(), placeholder + "-");
                }
                case 2: {
                    return this.appendPlaceholder(state.getChild(), placeholder + "a");
                }
                case 3: {
                    return this.appendPlaceholder(state.getChild(), placeholder + "0");
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return placeholder;
    }

    public Mask(@NotNull String format) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        this.initialState = new Compiler().compile(format);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/redmadrobot/inputmask/helper/Mask$Result;", "", "formattedText", "Lcom/redmadrobot/inputmask/model/CaretString;", "extractedValue", "", "(Lcom/redmadrobot/inputmask/model/CaretString;Ljava/lang/String;)V", "getExtractedValue", "()Ljava/lang/String;", "getFormattedText", "()Lcom/redmadrobot/inputmask/model/CaretString;", "inputmask-compileReleaseKotlin"})
    public static final class Result {
        @NotNull
        private final CaretString formattedText;
        @NotNull
        private final String extractedValue;

        @NotNull
        public final CaretString getFormattedText() {
            return this.formattedText;
        }

        @NotNull
        public final String getExtractedValue() {
            return this.extractedValue;
        }

        public Result(@NotNull CaretString formattedText, @NotNull String extractedValue) {
            Intrinsics.checkParameterIsNotNull((Object)formattedText, (String)"formattedText");
            Intrinsics.checkParameterIsNotNull((Object)extractedValue, (String)"extractedValue");
            this.formattedText = formattedText;
            this.extractedValue = extractedValue;
        }
    }
}

