/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask;

import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.redmadrobot.inputmask.helper.Mask;
import com.redmadrobot.inputmask.model.CaretString;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002:\u00014B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u001b\u001a\u00020\u000fJ\u0006\u0010\u001c\u001a\u00020\u000fJ\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J*\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0016J\u001a\u0010'\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0006H\u0016J(\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000fH\u0016J\u0006\u00100\u001a\u00020\u0004J\u000e\u00101\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0004J\u0006\u00102\u001a\u00020\u000fJ\u0006\u00103\u001a\u00020\u000fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00065"}, d2={"Lcom/redmadrobot/inputmask/MaskedTextChangedListener;", "Landroid/text/TextWatcher;", "Landroid/view/View$OnFocusChangeListener;", "format", "", "autocomplete", "", "field", "Landroid/widget/EditText;", "listener", "valueListener", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "(Ljava/lang/String;ZLandroid/widget/EditText;Landroid/text/TextWatcher;Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "afterText", "caretPosition", "", "Ljava/lang/ref/WeakReference;", "getListener", "()Landroid/text/TextWatcher;", "setListener", "(Landroid/text/TextWatcher;)V", "mask", "Lcom/redmadrobot/inputmask/helper/Mask;", "getValueListener", "()Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "setValueListener", "(Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;)V", "acceptableTextLength", "acceptableValueLength", "afterTextChanged", "", "edit", "Landroid/text/Editable;", "beforeTextChanged", "p0", "", "p1", "p2", "p3", "onFocusChange", "view", "Landroid/view/View;", "hasFocus", "onTextChanged", "text", "cursorPosition", "before", "count", "placeholder", "setText", "totalTextLength", "totalValueLength", "ValueListener", "inputmask-compileReleaseKotlin"})
public final class MaskedTextChangedListener
implements TextWatcher,
View.OnFocusChangeListener {
    @Nullable
    private TextWatcher listener;
    @Nullable
    private ValueListener valueListener;
    private final Mask mask;
    private final boolean autocomplete;
    private String afterText;
    private int caretPosition;
    private final WeakReference<EditText> field;

    @Nullable
    public final TextWatcher getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable TextWatcher textWatcher) {
        this.listener = textWatcher;
    }

    @Nullable
    public final ValueListener getValueListener() {
        return this.valueListener;
    }

    public final void setValueListener(@Nullable ValueListener valueListener) {
        this.valueListener = valueListener;
    }

    public final void setText(@NotNull String text) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Mask.Result result = this.mask.apply(new CaretString(text, text.length()), this.autocomplete);
            ((EditText)this.field.get()).setText((CharSequence)result.getFormattedText().getString());
            ((EditText)this.field.get()).setSelection(result.getFormattedText().getCaretPosition());
            ValueListener valueListener = this.valueListener;
            if (valueListener != null) {
                valueListener.onExtracted(result.getExtractedValue());
            }
            ValueListener valueListener2 = this.valueListener;
            if (valueListener2 == null) break block1;
            valueListener2.onMandatoryCharactersFilled(result.getExtractedValue().length() >= this.acceptableValueLength());
        }
    }

    @NotNull
    public final String placeholder() {
        return this.mask.placeholder();
    }

    public final int acceptableTextLength() {
        return this.mask.acceptableTextLength();
    }

    public final int totalTextLength() {
        return this.mask.totalTextLength();
    }

    public final int acceptableValueLength() {
        return this.mask.acceptableValueLength();
    }

    public final int totalValueLength() {
        return this.mask.totalValueLength();
    }

    public void afterTextChanged(@Nullable Editable edit) {
        block2: {
            ((EditText)this.field.get()).removeTextChangedListener((TextWatcher)this);
            Editable editable = edit;
            if (editable != null) {
                editable.clear();
            }
            Editable editable2 = edit;
            if (editable2 != null) {
                editable2.append((CharSequence)this.afterText);
            }
            ((EditText)this.field.get()).setSelection(this.caretPosition);
            ((EditText)this.field.get()).addTextChangedListener((TextWatcher)this);
            TextWatcher textWatcher = this.listener;
            if (textWatcher == null) break block2;
            textWatcher.afterTextChanged(edit);
        }
    }

    public void beforeTextChanged(@Nullable CharSequence p0, int p1, int p2, int p3) {
        block0: {
            TextWatcher textWatcher = this.listener;
            if (textWatcher == null) break block0;
            textWatcher.beforeTextChanged(p0, p1, p2, p3);
        }
    }

    public void onTextChanged(@NotNull CharSequence text, int cursorPosition, int before, int count) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            boolean isDeletion = before > 0;
            Mask.Result result = this.mask.apply(new CaretString(((Object)text).toString(), isDeletion ? cursorPosition : cursorPosition + count), this.autocomplete && !isDeletion);
            this.afterText = result.getFormattedText().getString();
            this.caretPosition = result.getFormattedText().getCaretPosition();
            ValueListener valueListener = this.valueListener;
            if (valueListener != null) {
                valueListener.onExtracted(result.getExtractedValue());
            }
            ValueListener valueListener2 = this.valueListener;
            if (valueListener2 == null) break block1;
            valueListener2.onMandatoryCharactersFilled(result.getExtractedValue().length() >= this.acceptableValueLength());
        }
    }

    public void onFocusChange(@Nullable View view, boolean hasFocus) {
        block2: {
            if (!this.autocomplete || !hasFocus) break block2;
            CharSequence charSequence = (CharSequence)((EditText)this.field.get()).getText();
            String text = charSequence.length() == 0 ? "" : ((EditText)this.field.get()).getText().toString();
            Mask.Result result = this.mask.apply(new CaretString(text, text.length()), this.autocomplete);
            ((EditText)this.field.get()).setText((CharSequence)result.getFormattedText().getString());
            ((EditText)this.field.get()).setSelection(result.getFormattedText().getCaretPosition());
            ValueListener valueListener = this.valueListener;
            if (valueListener != null) {
                valueListener.onExtracted(result.getExtractedValue());
            }
            ValueListener valueListener2 = this.valueListener;
            if (valueListener2 != null) {
                valueListener2.onMandatoryCharactersFilled(result.getExtractedValue().length() >= this.acceptableValueLength());
            }
        }
    }

    public MaskedTextChangedListener(@NotNull String format, boolean autocomplete, @NotNull EditText field, @Nullable TextWatcher listener, @Nullable ValueListener valueListener) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        this.afterText = "";
        this.mask = new Mask(format);
        this.autocomplete = autocomplete;
        this.listener = listener;
        this.valueListener = valueListener;
        this.field = new WeakReference<EditText>(field);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/redmadrobot/inputmask/MaskedTextChangedListener$ValueListener;", "", "onExtracted", "", "value", "", "onMandatoryCharactersFilled", "complete", "", "inputmask-compileReleaseKotlin"})
    public static interface ValueListener {
        public void onExtracted(@NotNull String var1);

        public void onMandatoryCharactersFilled(boolean var1);
    }
}

