/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.CaretStringIterator;
import com.redmadrobot.inputmask.helper.Compiler;
import com.redmadrobot.inputmask.model.CaretString;
import com.redmadrobot.inputmask.model.Next;
import com.redmadrobot.inputmask.model.Notation;
import com.redmadrobot.inputmask.model.State;
import com.redmadrobot.inputmask.model.state.EOLState;
import com.redmadrobot.inputmask.model.state.FixedState;
import com.redmadrobot.inputmask.model.state.FreeState;
import com.redmadrobot.inputmask.model.state.OptionalValueState;
import com.redmadrobot.inputmask.model.state.ValueState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001d\u001e\u001fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u001a\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u000eJ\u0006\u0010\u001c\u001a\u00020\u000eR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/redmadrobot/inputmask/helper/Mask;", "", "format", "", "(Ljava/lang/String;)V", "customNotations", "", "Lcom/redmadrobot/inputmask/model/Notation;", "(Ljava/lang/String;Ljava/util/List;)V", "getCustomNotations", "()Ljava/util/List;", "initialState", "Lcom/redmadrobot/inputmask/model/State;", "acceptableTextLength", "", "acceptableValueLength", "appendPlaceholder", "state", "placeholder", "apply", "Lcom/redmadrobot/inputmask/helper/Mask$Result;", "text", "Lcom/redmadrobot/inputmask/model/CaretString;", "makeIterator", "Lcom/redmadrobot/inputmask/helper/CaretStringIterator;", "noMandatoryCharactersLeftAfterState", "", "totalTextLength", "totalValueLength", "AutocompletionStack", "Factory", "Result", "inputmask_release"})
public class Mask {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final List<Notation> customNotations;
    @NotNull
    private final State initialState;
    @NotNull
    private static final Map<String, Mask> cache = new HashMap();

    public Mask(@NotNull String format, @NotNull List<Notation> customNotations) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(customNotations, (String)"customNotations");
        this.customNotations = customNotations;
        this.initialState = new Compiler(this.customNotations).compile(format);
    }

    @NotNull
    protected final List<Notation> getCustomNotations() {
        return this.customNotations;
    }

    public Mask(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this(format, CollectionsKt.emptyList());
    }

    @NotNull
    public Result apply(@NotNull CaretString text) {
        Next next;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CaretStringIterator iterator = this.makeIterator(text);
        int affinity = 0;
        String extractedValue = "";
        String modifiedString = "";
        int modifiedCaretPosition = text.getCaretPosition();
        State state = this.initialState;
        AutocompletionStack autocompletionStack = new AutocompletionStack();
        boolean insertionAffectsCaret = iterator.insertionAffectsCaret();
        boolean deletionAffectsCaret = iterator.deletionAffectsCaret();
        Character character = iterator.next();
        while (character != null) {
            next = state.accept(character.charValue());
            if (next != null) {
                if (deletionAffectsCaret) {
                    autocompletionStack.push(state.autocomplete());
                }
                state = next.getState();
                StringBuilder stringBuilder = new StringBuilder().append(modifiedString);
                Object object = next.getInsert();
                if (object == null) {
                    object = "";
                }
                modifiedString = stringBuilder.append(object).toString();
                StringBuilder stringBuilder2 = new StringBuilder().append(extractedValue);
                Object object2 = next.getValue();
                if (object2 == null) {
                    object2 = "";
                }
                extractedValue = stringBuilder2.append(object2).toString();
                if (next.getPass()) {
                    insertionAffectsCaret = iterator.insertionAffectsCaret();
                    deletionAffectsCaret = iterator.deletionAffectsCaret();
                    character = iterator.next();
                    ++affinity;
                    continue;
                }
                if (insertionAffectsCaret && next.getInsert() != null) {
                    ++modifiedCaretPosition;
                }
                --affinity;
                continue;
            }
            if (deletionAffectsCaret) {
                --modifiedCaretPosition;
            }
            insertionAffectsCaret = iterator.insertionAffectsCaret();
            deletionAffectsCaret = iterator.deletionAffectsCaret();
            character = iterator.next();
            --affinity;
        }
        while (text.getCaretGravity().getAutocomplete() && insertionAffectsCaret && state.autocomplete() != null) {
            state = next.getState();
            StringBuilder stringBuilder = new StringBuilder().append(modifiedString);
            Object object = next.getInsert();
            if (object == null) {
                object = "";
            }
            modifiedString = stringBuilder.append(object).toString();
            StringBuilder stringBuilder3 = new StringBuilder().append(extractedValue);
            Object object3 = next.getValue();
            if (object3 == null) {
                object3 = "";
            }
            extractedValue = stringBuilder3.append(object3).toString();
            if (next.getInsert() == null) continue;
            ++modifiedCaretPosition;
        }
        State tailState = state;
        String tail = "";
        while (text.getCaretGravity().getAutoskip() && !autocompletionStack.empty()) {
            Object e = autocompletionStack.pop();
            Intrinsics.checkNotNullExpressionValue(e, (String)"autocompletionStack.pop()");
            Next skip = (Next)e;
            if (modifiedString.length() == modifiedCaretPosition) {
                char c;
                if (skip.getInsert() != null) {
                    Character c2 = skip.getInsert();
                    c = StringsKt.last((CharSequence)modifiedString);
                    if (c2 != null && c2.charValue() == c) {
                        modifiedString = StringsKt.dropLast((String)modifiedString, (int)1);
                        --modifiedCaretPosition;
                    }
                }
                if (skip.getValue() != null) {
                    Character c3 = skip.getValue();
                    c = StringsKt.last((CharSequence)extractedValue);
                    if (c3 != null && c3.charValue() == c) {
                        extractedValue = StringsKt.dropLast((String)extractedValue, (int)1);
                    }
                }
            } else if (skip.getInsert() != null) {
                --modifiedCaretPosition;
            }
            tailState = skip.getState();
            tail = skip.getInsert() != null ? skip.getInsert().toString() : tail;
        }
        String tailPlaceholder = this.appendPlaceholder(tailState, tail);
        return new Result(new CaretString(modifiedString, modifiedCaretPosition, text.getCaretGravity()), extractedValue, affinity, this.noMandatoryCharactersLeftAfterState(state), tailPlaceholder);
    }

    @NotNull
    public CaretStringIterator makeIterator(@NotNull CaretString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new CaretStringIterator(text, 0, 2, null);
    }

    @NotNull
    public final String placeholder() {
        return this.appendPlaceholder(this.initialState, "");
    }

    public final int acceptableTextLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof FreeState) && !(state instanceof ValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int totalTextLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof FreeState) && !(state instanceof ValueState) && !(state instanceof OptionalValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int acceptableValueLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof ValueState)) continue;
            ++length;
        }
        return length;
    }

    public final int totalValueLength() {
        int length = 0;
        for (State state = this.initialState; state != null && !(state instanceof EOLState); state = state.getChild()) {
            if (!(state instanceof FixedState) && !(state instanceof ValueState) && !(state instanceof OptionalValueState)) continue;
            ++length;
        }
        return length;
    }

    private final String appendPlaceholder(State state, String placeholder) {
        if (state == null) {
            return placeholder;
        }
        if (state instanceof EOLState) {
            return placeholder;
        }
        if (state instanceof FixedState) {
            return this.appendPlaceholder(((FixedState)state).getChild(), placeholder + ((FixedState)state).getOwnCharacter());
        }
        if (state instanceof FreeState) {
            return this.appendPlaceholder(((FreeState)state).getChild(), placeholder + ((FreeState)state).getOwnCharacter());
        }
        if (state instanceof OptionalValueState) {
            String string;
            OptionalValueState.StateType stateType = ((OptionalValueState)state).getType();
            if (stateType instanceof OptionalValueState.StateType.AlphaNumeric) {
                string = this.appendPlaceholder(((OptionalValueState)state).getChild(), placeholder + '-');
            } else if (stateType instanceof OptionalValueState.StateType.Literal) {
                string = this.appendPlaceholder(((OptionalValueState)state).getChild(), placeholder + 'a');
            } else if (stateType instanceof OptionalValueState.StateType.Numeric) {
                string = this.appendPlaceholder(((OptionalValueState)state).getChild(), placeholder + '0');
            } else if (stateType instanceof OptionalValueState.StateType.Custom) {
                string = this.appendPlaceholder(((OptionalValueState)state).getChild(), placeholder + ((OptionalValueState.StateType.Custom)((OptionalValueState)state).getType()).getCharacter());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
        if (state instanceof ValueState) {
            String string;
            ValueState.StateType stateType = ((ValueState)state).getType();
            if (stateType instanceof ValueState.StateType.AlphaNumeric) {
                string = this.appendPlaceholder(((ValueState)state).getChild(), placeholder + '-');
            } else if (stateType instanceof ValueState.StateType.Literal) {
                string = this.appendPlaceholder(((ValueState)state).getChild(), placeholder + 'a');
            } else if (stateType instanceof ValueState.StateType.Numeric) {
                string = this.appendPlaceholder(((ValueState)state).getChild(), placeholder + '0');
            } else if (stateType instanceof ValueState.StateType.Ellipsis) {
                string = placeholder;
            } else if (stateType instanceof ValueState.StateType.Custom) {
                string = this.appendPlaceholder(((ValueState)state).getChild(), placeholder + ((ValueState.StateType.Custom)((ValueState)state).getType()).getCharacter());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
        return placeholder;
    }

    private final boolean noMandatoryCharactersLeftAfterState(State state) {
        boolean bl;
        State state2 = state;
        if (state2 instanceof EOLState) {
            bl = true;
        } else {
            if (state2 instanceof ValueState) {
                return ((ValueState)state).isElliptical();
            }
            bl = state2 instanceof FixedState ? false : this.noMandatoryCharactersLeftAfterState(state.nextState());
        }
        return bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001J\u0006\u0010\u001e\u001a\u00020\u0000J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/redmadrobot/inputmask/helper/Mask$Result;", "", "formattedText", "Lcom/redmadrobot/inputmask/model/CaretString;", "extractedValue", "", "affinity", "", "complete", "", "tailPlaceholder", "(Lcom/redmadrobot/inputmask/model/CaretString;Ljava/lang/String;IZLjava/lang/String;)V", "getAffinity", "()I", "getComplete", "()Z", "getExtractedValue", "()Ljava/lang/String;", "getFormattedText", "()Lcom/redmadrobot/inputmask/model/CaretString;", "getTailPlaceholder", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "reversed", "toString", "inputmask_release"})
    public static final class Result {
        @NotNull
        private final CaretString formattedText;
        @NotNull
        private final String extractedValue;
        private final int affinity;
        private final boolean complete;
        @NotNull
        private final String tailPlaceholder;

        public Result(@NotNull CaretString formattedText, @NotNull String extractedValue, int affinity, boolean complete, @NotNull String tailPlaceholder) {
            Intrinsics.checkNotNullParameter((Object)formattedText, (String)"formattedText");
            Intrinsics.checkNotNullParameter((Object)extractedValue, (String)"extractedValue");
            Intrinsics.checkNotNullParameter((Object)tailPlaceholder, (String)"tailPlaceholder");
            this.formattedText = formattedText;
            this.extractedValue = extractedValue;
            this.affinity = affinity;
            this.complete = complete;
            this.tailPlaceholder = tailPlaceholder;
        }

        @NotNull
        public final CaretString getFormattedText() {
            return this.formattedText;
        }

        @NotNull
        public final String getExtractedValue() {
            return this.extractedValue;
        }

        public final int getAffinity() {
            return this.affinity;
        }

        public final boolean getComplete() {
            return this.complete;
        }

        @NotNull
        public final String getTailPlaceholder() {
            return this.tailPlaceholder;
        }

        @NotNull
        public final Result reversed() {
            return new Result(this.formattedText.reversed(), ((Object)StringsKt.reversed((CharSequence)this.extractedValue)).toString(), this.affinity, this.complete, ((Object)StringsKt.reversed((CharSequence)this.tailPlaceholder)).toString());
        }

        @NotNull
        public final CaretString component1() {
            return this.formattedText;
        }

        @NotNull
        public final String component2() {
            return this.extractedValue;
        }

        public final int component3() {
            return this.affinity;
        }

        public final boolean component4() {
            return this.complete;
        }

        @NotNull
        public final String component5() {
            return this.tailPlaceholder;
        }

        @NotNull
        public final Result copy(@NotNull CaretString formattedText, @NotNull String extractedValue, int affinity, boolean complete, @NotNull String tailPlaceholder) {
            Intrinsics.checkNotNullParameter((Object)formattedText, (String)"formattedText");
            Intrinsics.checkNotNullParameter((Object)extractedValue, (String)"extractedValue");
            Intrinsics.checkNotNullParameter((Object)tailPlaceholder, (String)"tailPlaceholder");
            return new Result(formattedText, extractedValue, affinity, complete, tailPlaceholder);
        }

        public static /* synthetic */ Result copy$default(Result result, CaretString caretString, String string, int n, boolean bl, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                caretString = result.formattedText;
            }
            if ((n2 & 2) != 0) {
                string = result.extractedValue;
            }
            if ((n2 & 4) != 0) {
                n = result.affinity;
            }
            if ((n2 & 8) != 0) {
                bl = result.complete;
            }
            if ((n2 & 0x10) != 0) {
                string2 = result.tailPlaceholder;
            }
            return result.copy(caretString, string, n, bl, string2);
        }

        @NotNull
        public String toString() {
            return "Result(formattedText=" + this.formattedText + ", extractedValue=" + this.extractedValue + ", affinity=" + this.affinity + ", complete=" + this.complete + ", tailPlaceholder=" + this.tailPlaceholder + ')';
        }

        public int hashCode() {
            int result = this.formattedText.hashCode();
            result = result * 31 + this.extractedValue.hashCode();
            result = result * 31 + Integer.hashCode(this.affinity);
            int n = this.complete ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + this.tailPlaceholder.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual((Object)this.formattedText, (Object)result.formattedText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extractedValue, (Object)result.extractedValue)) {
                return false;
            }
            if (this.affinity != result.affinity) {
                return false;
            }
            if (this.complete != result.complete) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tailPlaceholder, (Object)result.tailPlaceholder);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/redmadrobot/inputmask/helper/Mask$AutocompletionStack;", "Ljava/util/Stack;", "Lcom/redmadrobot/inputmask/model/Next;", "()V", "push", "item", "inputmask_release"})
    private static final class AutocompletionStack
    extends Stack<Next> {
        @Override
        @Nullable
        public Next push(@Nullable Next item) {
            Next next;
            if (item != null) {
                next = super.push(item);
            } else {
                this.removeAllElements();
                next = null;
            }
            return next;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/redmadrobot/inputmask/helper/Mask$Factory;", "", "()V", "cache", "", "", "Lcom/redmadrobot/inputmask/helper/Mask;", "getOrCreate", "format", "customNotations", "", "Lcom/redmadrobot/inputmask/model/Notation;", "isValid", "", "inputmask_release"})
    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public final Mask getOrCreate(@NotNull String format, @NotNull List<Notation> customNotations) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter(customNotations, (String)"customNotations");
            Mask cachedMask = (Mask)cache.get(format);
            if (cachedMask == null) {
                cachedMask = new Mask(format, customNotations);
                cache.put(format, cachedMask);
            }
            return cachedMask;
        }

        public final boolean isValid(@NotNull String format, @NotNull List<Notation> customNotations) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter(customNotations, (String)"customNotations");
            try {
                new Mask(format, customNotations);
                bl = true;
            }
            catch (Compiler.FormatError e) {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

