/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.FormatSanitizer;
import com.redmadrobot.inputmask.model.State;
import com.redmadrobot.inputmask.model.state.EOLState;
import com.redmadrobot.inputmask.model.state.FixedState;
import com.redmadrobot.inputmask.model.state.FreeState;
import com.redmadrobot.inputmask.model.state.OptionalValueState;
import com.redmadrobot.inputmask.model.state.ValueState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J/\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/redmadrobot/inputmask/helper/Compiler;", "", "()V", "compile", "Lcom/redmadrobot/inputmask/model/State;", "formatString", "", "valueable", "", "fixed", "lastCharacter", "", "(Ljava/lang/String;ZZLjava/lang/Character;)Lcom/redmadrobot/inputmask/model/State;", "determineInheritedType", "Lcom/redmadrobot/inputmask/model/state/ValueState$StateType;", "(Ljava/lang/Character;)Lcom/redmadrobot/inputmask/model/state/ValueState$StateType;", "FormatError", "inputmask_release"})
public final class Compiler {
    @NotNull
    public final State compile(@NotNull String formatString) throws FormatError {
        Intrinsics.checkParameterIsNotNull((Object)formatString, (String)"formatString");
        String sanitizedString = new FormatSanitizer().sanitize(formatString);
        return this.compile(sanitizedString, false, false, null);
    }

    private final State compile(String formatString, boolean valueable, boolean fixed, Character lastCharacter) {
        CharSequence charSequence = formatString;
        if (charSequence.length() == 0) {
            return new EOLState();
        }
        char c = StringsKt.first((CharSequence)formatString);
        switch (c) {
            case '[': {
                return this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c));
            }
            case '{': {
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, true, Character.valueOf(c));
            }
            case ']': {
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c));
            }
            case '}': {
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c));
            }
        }
        if (valueable) {
            switch (c) {
                case '0': {
                    return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new ValueState.StateType.Numeric());
                }
                case 'A': {
                    return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new ValueState.StateType.Literal());
                }
                case '_': {
                    return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new ValueState.StateType.AlphaNumeric());
                }
                case '\u2026': {
                    return new ValueState(this.determineInheritedType(lastCharacter));
                }
                case '9': {
                    return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), OptionalValueState.StateType.Numeric);
                }
                case 'a': {
                    return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), OptionalValueState.StateType.Literal);
                }
                case '-': {
                    return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), OptionalValueState.StateType.AlphaNumeric);
                }
            }
            throw (Throwable)new FormatError();
        }
        if (fixed) {
            return new FixedState(this.compile(StringsKt.drop((String)formatString, (int)1), false, true, Character.valueOf(c)), c);
        }
        return new FreeState(this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c)), c);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ValueState.StateType determineInheritedType(Character lastCharacter) {
        ValueState.StateType stateType;
        Character c;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                Character c2 = c = lastCharacter;
                                if (c2 != null && c2.charValue() == '0') break block11;
                                Character c3 = c;
                                if (c3 == null || c3.charValue() != '9') break block12;
                            }
                            stateType = new ValueState.StateType.Numeric();
                            return stateType;
                        }
                        Character c4 = c;
                        if (c4 != null && c4.charValue() == 'A') break block13;
                        Character c5 = c;
                        if (c5 == null || c5.charValue() != 'a') break block14;
                    }
                    stateType = new ValueState.StateType.Literal();
                    return stateType;
                }
                Character c6 = c;
                if (c6 != null && c6.charValue() == '_') break block15;
                Character c7 = c;
                if (c7 == null || c7.charValue() != '-') break block16;
            }
            stateType = new ValueState.StateType.AlphaNumeric();
            return stateType;
        }
        Character c8 = c;
        if (c8 != null && c8.charValue() == '\u2026') {
            stateType = new ValueState.StateType.AlphaNumeric();
            return stateType;
        }
        Character c9 = c;
        if (c9 == null) {
            throw (Throwable)new FormatError();
        }
        if (c9.charValue() != '[') throw (Throwable)new FormatError();
        stateType = new ValueState.StateType.AlphaNumeric();
        return stateType;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/redmadrobot/inputmask/helper/Compiler$FormatError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "inputmask_release"})
    public static final class FormatError
    extends Exception {
    }
}

