package com.redking.view.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.LinearLayout;

import com.redking.x5.R;

/**
 * Created by wangjingyun on 2018/9/11.
 */

public class DragLinearLayout extends LinearLayout{

    private int width;
    private int height;
    private int screenWidth;
    private int screenHeight;
    private Context context;

    //是否拖动
    private boolean isDrag=false;

    public DragLinearLayout(Context context) {
        super(context);
        this.context = context;
    }

    public DragLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public DragLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    public int getScreenWidth(Context context){
        WindowManager wm1 = ((Activity)context).getWindowManager();
        return wm1.getDefaultDisplay().getWidth();
    }

    public int getScreenHeight(Context context){
        WindowManager wm1 = ((Activity)context).getWindowManager();
        return wm1.getDefaultDisplay().getHeight();
    }
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        width=getMeasuredWidth();
        height=getMeasuredHeight();
        screenWidth = getScreenWidth(context);
        screenHeight = getScreenHeight(context)-getStatusBarHeight();
        setMeasuredDimension(width, height);
    }
    public int getStatusBarHeight(){
        int resourceId = getResources().getIdentifier("status_bar_height", "dimen", "android");
        return getResources().getDimensionPixelSize(resourceId);
    }


    private float downX;
    private float downY;

    View topView;
    public void setTopView(View topView){
        this.topView = topView;
    }
    @Override
    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.isEnabled()) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    isDrag=false;
                    downX = event.getX();
                    downY = event.getY();
                    break;
                case MotionEvent.ACTION_MOVE:
                    Log.e("kid","ACTION_MOVE");
                    final float xDistance = event.getX() - downX;
                    final float yDistance = event.getY() - downY;
                    int l,r,t,b;
                    //当水平或者垂直滑动距离大于10,才算拖动事件
                    if (Math.abs(xDistance) >10 ||Math.abs(yDistance)>10) {
                        Log.e("kid","Drag");
                        isDrag=true;
                        l = (int) (getLeft() + xDistance);
                        r = l+width;
                        t = (int) (getTop() + yDistance);
                        b = t+height;
                        //不划出边界判断,此处应按照项目实际情况,因为本项目需求移动的位置是手机全屏,
                        // 所以才能这么写,如果是固定区域,要得到父控件的宽高位置后再做处理
                        if(l<0){
                            l=0;
                            r=l+width;
                        }else if(r>screenWidth){
                            r=screenWidth;
                            l=r-width;
                        }
                        if(t<0){
                            t=0;
                            b=t+height;
                        }else if(b>screenHeight){
                            b=screenHeight;
                            t=b-height;
                        }
                        if(topView != null) topView.layout(l, t, r, b);
                        this.layout(l, t, r, b);
                    }
                    break;
                case MotionEvent.ACTION_UP:
                    setPressed(false);
                    break;
                case MotionEvent.ACTION_CANCEL:
                    setPressed(false);
                    break;
            }
            return true;
        }
        return false;
    }
    private Matrix matrix=new Matrix();
    private Bitmap bitmap= BitmapFactory.decodeResource(getResources(), R.drawable.red_net);

    @Override
    protected void onDraw(Canvas canvas) {

        super.onDraw(canvas);
//		canvas.translate(240.0f, 400.0f);//画布移动
//		canvas.rotate(50);//画布旋转
//		canvas.scale(2, 2, 240.0f, 400.0f);

//		matrix.postRotate(30);//绕原点旋转30度
//		matrix.postRotate(30, width/2, heigth/2);//绕某个点旋转30度，这里选择的原点是图片的中心点
//		matrix.postScale(2, 1);//两个参数为缩放比例。按比例缩放，宽为原来的2倍，1为正常所以高不变，但参考点事坐标原点
//		matrix.postTranslate(240-width/2, 400-heigth/2);//参考点为坐标原点（0，0）移动到（240-width/2,400-heigth/2）
//		matrix.postScale(2, 2, 240-width/2,400-heigth/2);//以 （240-width/2,400-heigth/2）为缩放中心
//		matrix.postSkew(0.2f, 0.2f);//参数为x,y轴倾斜角度

//		matrix.postScale(2.0f, 2.0f);
//        matrix.postTranslate(100, 100);
//		matrix.postTranslate(100, 100);
//        matrix.postTranslate(-100, -100);

        canvas.drawBitmap(bitmap, matrix, null);



		/*canvas.scale(2, 2, 240.0f, 400.0f);的原型为如下：
		 * scale(float sx, float sy, float px, float py){
            translate(px,py);
            scale(sx,sy);
            translate(-px,-py);
        }*/
    }
}
