package com.redking.view.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.ProgressBar;

import com.redking.x5.R;

/**
 * Created by redking on 2018/8/20.
 */

public class DownLoadProgress extends ProgressBar {

        private final int TEXT_SIZE_12 = 20;
        private String mPercentText = "0.0%";
        private String mPauseText = getResources().getString(R.string.redPause);
        private String mDefaultText = getResources().getString(R.string.redDownload);
        private String mFinishText = getResources().getString(R.string.redFinish);
        private Rect mPauseRect;
        private Rect mPercentRect;
        private Context mContext;
        private Paint mPaint;
        private PorterDuffXfermode mPorterDuffXfermode;
        private float mProgress;
        private float mWidth;
        private int mStateType = 0;

        public DownLoadProgress(Context context) {
            super(context);
            mContext = context;
            init();
        }

        public DownLoadProgress(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            mContext = context;
            init();
        }


        public DownLoadProgress(Context context, AttributeSet attrs) {
            super(context, attrs);
            mContext = context;
            init();
        }

        public synchronized void setStateType(int stateType){
            mStateType = stateType;
            invalidate();
        }

        public synchronized void setProgress(float progress) {
            mProgress = progress;
            mPercentText = String.format("%.1f%%", progress);
            super.setProgress((int) progress);
        }

        @Override
        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            mWidth = getWidth() * mProgress / 100;//进度作一下处理，解决不同分辨率的适配问题
            mPaint.getTextBounds(mPercentText, 0, mPercentText.length(), mPercentRect);//为了获取文字的宽高以及坐标位置，get之后，rect.centerX才有值
            mPaint.getTextBounds(mPauseText, 0, mPauseText.length(), mPauseRect);
            int textX = (getWidth() / 2) - mPauseRect.centerX();//获取“暂停”文字的中心横坐标
            int textY = (getHeight() / 2) - mPauseRect.centerY();
            int percentX = (getWidth() / 2) - mPercentRect.centerX();//获取百分比文字的中心横坐标
            int percentY = (getHeight() / 2) - mPercentRect.centerY();
            Bitmap srcBitmap = Bitmap.createBitmap(getWidth(), getHeight(), Bitmap.Config.ARGB_8888);
            Canvas srcCanvas = new Canvas(srcBitmap);
            switch (mStateType) {
                case Constant.DEFAULT://默认初始化状态
                    drawTextUI(canvas, textX, textY, mDefaultText, srcBitmap, srcCanvas);
                    break;
                case Constant.PAUSE:
                    drawTextUI(canvas, textX, textY, mPauseText, srcBitmap, srcCanvas);
                    break;
                case Constant.DOWNLOAD:
                    drawTextUI(canvas, percentX, percentY, mPercentText, srcBitmap, srcCanvas);
                    break;
                case Constant.FINISH:
                    mPaint.setColor(Color.WHITE);
                    canvas.drawText(mFinishText, textX, textY, mPaint);
                    break;
                default:
                    drawTextUI(canvas, textX, textY, mDefaultText, srcBitmap, srcCanvas);
                    break;
            }
        }

        private void drawTextUI(Canvas canvas, int x, int y, String textContent, Bitmap srcBitmap, Canvas srcCanvas) {
            mPaint.setColor(Color.parseColor("#0894EC"));
            canvas.drawText(textContent, x, y, mPaint);
            srcCanvas.drawText(textContent, x, y, mPaint);

            // 设置混合模式
            mPaint.setXfermode(mPorterDuffXfermode);
            mPaint.setColor(Color.WHITE);
            RectF rectF = new RectF(0, 0, mWidth, getHeight());//mWidth是不断变化的
            // 绘制源图形
            srcCanvas.drawRect(rectF, mPaint);
            // 绘制目标图
            canvas.drawBitmap(srcBitmap, 0, 0, null);
            // 清除混合模式
            mPaint.setXfermode(null);
            // 恢复画笔颜色
            mPaint.setColor(Color.parseColor("#0894EC"));
        }

        public void init() {
            mPauseRect = new Rect();
            mPercentRect = new Rect();
            mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
            mPaint.setAntiAlias(true);
            mPorterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
            mPaint.setColor(Color.parseColor("#0894EC"));
            mPaint.setTextSize(TEXT_SIZE_12);
            mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            mPaint.setXfermode(null);
            mPaint.setTextAlign(Paint.Align.LEFT);
        }
    }
