package com.redking.view.activity;

import android.app.Activity;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.redking.x5.R;
import com.redking.view.fragment.DocOpenFragment;

import java.io.File;

/**
 * Created by redking on 2018/7/26.
 *
 * 声明：该DocOpenDemoActivity只是使用方式演示，要实现自己的页面应该写自己的activity嵌入DocOpenFragment
 *
 * 1、app的首页Activity调用TencentSdkX5.initX5(this);提前加载好内核，第一次大概需要90秒
 *
 * 2、按照DemoActivity方式把DocOpenFragment 放入activity
 *
 * 3、通过docOpenFragment.setFilePath(fileUrl)设置文件路径（可以是本地路径，也可以是网络下载地址），在beginTransaction.commit();之前调用
 *
 */
public class DocOpenDemoActivity extends Activity implements View.OnClickListener{
    FragmentManager fragmentManager;
    FragmentTransaction beginTransaction;
    DocOpenFragment docOpenFragment;
    String fileUrl = "http://mozilla.github.io/pdf.js/web/compressed.tracemonkey-pldi-09.pdf";//http://www.hrssgz.gov.cn/bgxz/sydwrybgxz/201101/P020110110748901718161.doc
    private TextView tvTitle, tvClose;
    private ImageView netOpen, openFiles;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.red_act_doc_demo);

        initView();
        initData();
        initListener();
    }

    private void initView(){
        tvTitle = (TextView) findViewById(R.id.tv_title);
        netOpen = (ImageView) findViewById(R.id.open_net);
        openFiles = (ImageView) findViewById(R.id.open_files);
        tvClose = (TextView) findViewById(R.id.tv_close);
    }

    private void initData(){
        if(getIntent().getStringExtra("fileUrl") != null && getIntent().getStringExtra("fileUrl") != "" )
            fileUrl = getIntent().getStringExtra("fileUrl");
        if(fileUrl.startsWith("http") && !fileUrl.endsWith("pdf")){
            netOpen.setVisibility(View.VISIBLE);
        }else {
            netOpen.setVisibility(View.GONE);
        }
        fragmentManager = getFragmentManager();
        beginTransaction = fragmentManager.beginTransaction();
        docOpenFragment = new DocOpenFragment();

        //设置文件路径
        docOpenFragment.setFilePath(fileUrl);

        beginTransaction.add(R.id.ll_doc_frag, docOpenFragment);
        beginTransaction.commit();
        tvTitle.setText(docOpenFragment.getFileName(this));
    }

    private void initListener(){
        netOpen.setOnClickListener(this);
        openFiles.setOnClickListener(this);
        tvClose.setOnClickListener(this);
    }
    @Override
    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_close) {
            finish();

        } else if (i == R.id.open_net) {
//            File file = new File(docOpenFragment.getLocalCachePath());
//            //获取父目录
//            File parentFlie = new File(file.getParent());
//            Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
//            intent.setDataAndType(Uri.fromFile(file), "*/*");
//            intent.addCategory(Intent.CATEGORY_OPENABLE);
//            startActivity(intent);
            Intent intent = new Intent(this, X5WebActivity.class);
            intent.putExtra("url", "https://view.officeapps.live.com/op/view.aspx?src=" + fileUrl);
            startActivity(intent);
        } else if (i == R.id.open_files) {
            docOpenFragment.openByLocalOtherApp();
        }
    }
}
