package com.redking.tbs.docs;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.StrictMode;
import android.util.Log;
import android.widget.Toast;

import com.redking.view.fragment.DocOpenFragment;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by redking on 2018/8/16.
 */

public class DownLoadUtil {

    /**
     * @param urlPath
     *            下载路径
     * @param downloadDir
     *            下载存放目录,如果文件已存在不再下载
     * @param mHandler
     *             更新下载进度用
     * @return 返回下载文件
     */
    static File file = null;
    static String path;
    private static List<String> currentDownUrls = new ArrayList<>();
    private static Handler mHandler;
    public static File downloadFile(String urlPath, String downloadDir, Handler handler) {
        mHandler = handler;
        if(currentDownUrls.contains(urlPath)) return null;
        else currentDownUrls.add(urlPath);


        path  = (downloadDir == null || downloadDir == "") ?
                (Environment.getExternalStorageDirectory().getAbsolutePath() + "/redDoc/" +
                        Md5Tool.hashKey(urlPath)+"." +
                        urlPath.split("\\.")[urlPath.split("\\.").length - 1]) : downloadDir;

        file = new File(path);
//        if("".equals(SharedPrefHelper.getInstance().getFileName(Md5Tool.hashKey(urlPath)))){
//            if(file.exists()) file.delete();
//        }

        Message msg = new Message();
        Map<String, String> obj = new HashMap<>();
        obj.put("url", urlPath);//下载链接
        obj.put("path", path);//存储路径

        //如果文件已存在，并且有原始文件名记录（完全下载完（100%）才会有该记录）,按下载完成处理，直接返回不在重新下载。
        if(file.exists() && !"".equals(SharedPrefHelper.getInstance().getFileName(Md5Tool.hashKey(urlPath)))){
            obj.put("fileName", SharedPrefHelper.getInstance().getFileName(Md5Tool.hashKey(urlPath)));
            msg.what = 100;
            msg.obj = obj;
            mHandler.sendMessage(msg);
            currentDownUrls.remove(urlPath);
            return file;
        }

        try {
            // 统一资源
            URL url = new URL(urlPath);
            //StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder().detectDiskReads().detectDiskWrites().detectNetwork().penaltyLog().build());
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
            HttpURLConnection httpURLConnection = (HttpURLConnection) urlConnection;
            httpURLConnection.setConnectTimeout(20000);
            httpURLConnection.setReadTimeout(300000);
//            httpURLConnection.setUseCaches(false);
//            httpURLConnection.setDefaultUseCaches(false);
            //设置允许得到服务器的输入流,默认为true可以不用设置
            httpURLConnection.setDoInput(true);
            // 设定请求的方法，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            //防止屏蔽程序抓取而返回403错误
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            httpURLConnection.setRequestProperty("Content-Type", "plain/text; charset=UTF-8");
            // 设置通用的请求属性
            httpURLConnection.setRequestProperty("accept", "*/*");
            httpURLConnection.setRequestProperty("connection", "Keep-Alive");
            // 设置此 HttpURLConnection 实例是否应该自动执行 HTTP 重定向
            httpURLConnection.setInstanceFollowRedirects(true);
            // 打开到此 URL 引用的资源的通信链接（如果尚未建立这样的连接）
            httpURLConnection.connect();
            // 文件大小
            long fileLength = httpURLConnection.getContentLength();
            // 文件名
            String filePathUrl = httpURLConnection.getURL().getFile();

            String fileFullName = filePathUrl.substring(filePathUrl.lastIndexOf(File.separatorChar) + 1);
            if(httpURLConnection.getResponseCode() != 200){
                currentDownUrls.remove(urlPath);
                return null;
            }
            BufferedInputStream bin = new BufferedInputStream(httpURLConnection.getInputStream());

//按照真实文件名创建路径
//            path = (downloadDir == null || downloadDir == "") ?
//                    (Environment.getExternalStorageDirectory().getAbsolutePath() + "/redDoc/"
//                            + URLDecoder.decode(fileFullName, "UTF-8")) : downloadDir;
//            file = new File(path);

            Log.e("ccc", "=========fileLength========" + fileLength);
            if(file.exists() && file.length() < fileLength){//如果有该文件，但是文件大小，小于应有大小，删除重新下载
                file.delete();
            }else if(file.exists() && file.length() >= fileLength){//如果有该文件,并且大小正好，按下载完成处理，直接返回该文件
                obj.put("fileName", URLDecoder.decode(fileFullName, "UTF-8"));
                msg.what = 100;
                msg.obj = obj;
                mHandler.sendMessage(msg);
                currentDownUrls.remove(urlPath);
                return file;
            }


            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            OutputStream out = new FileOutputStream(file);
            int size = 0;
            long len = 0;
            byte[] buf = new byte[1024 * 100];
            obj.put("fileName", URLDecoder.decode(fileFullName, "UTF-8"));
            msg = new Message();
            msg.what = 0;
            msg.obj = obj;
            while ((size = bin.read(buf)) != -1) {
                len += size;
                out.write(buf, 0, size);
                msg = new Message();
                msg.what = (int) (len * 100 / fileLength);
                msg.obj = obj;
                mHandler.sendMessage(msg);
            }
            bin.close();
            out.close();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            currentDownUrls.remove(urlPath);
            return file;
        }

    }

    public static File httpClient(String urlPath, String downloadDir, Handler handler){
        mHandler = handler;
        if(currentDownUrls.contains(urlPath)) return null;
        else currentDownUrls.add(urlPath);


        path  = (downloadDir == null || downloadDir == "") ?
                (Environment.getExternalStorageDirectory().getAbsolutePath() + "/redDoc/" +
                        Md5Tool.hashKey(urlPath)+"." +
                        urlPath.split("\\.")[urlPath.split("\\.").length - 1]) : downloadDir;

        file = new File(path);
//        if("".equals(SharedPrefHelper.getInstance().getFileName(Md5Tool.hashKey(urlPath)))){
//            if(file.exists()) file.delete();
//        }

        Message msg = new Message();
        Map<String, String> obj = new HashMap<>();
        obj.put("url", urlPath);//下载链接
        obj.put("path", path);//存储路径

        //如果文件已存在，并且有原始文件名记录（完全下载完（100%）才会有该记录）,按下载完成处理，直接返回不在重新下载。
        if(file.exists() && !"".equals(SharedPrefHelper.getInstance().getFileName(Md5Tool.hashKey(urlPath)))){
            obj.put("fileName", SharedPrefHelper.getInstance().getFileName(Md5Tool.hashKey(urlPath)));
            msg.what = 100;
            msg.obj = obj;
            mHandler.sendMessage(msg);
            currentDownUrls.remove(urlPath);
            return file;
        }
        HttpClient httpClient  = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(urlPath);
        byte[] bytes;
        try {
            HttpResponse httpResponse = httpClient.execute(httpGet);
            // 4 判断是否请求成功
            if(httpResponse.getStatusLine().getStatusCode() == 200){
                HttpEntity entity = httpResponse.getEntity();// 实体
                bytes = EntityUtils.toByteArray(entity);
            }else {
                currentDownUrls.remove(urlPath);
                return null;
            }
            String fileFullName = urlPath.substring(urlPath.lastIndexOf(File.separatorChar) + 1);
            if(file.exists() && file.length() < bytes.length){//如果有该文件，但是文件大小，小于应有大小，删除重新下载
                file.delete();
            }else if(file.exists() && file.length() >= bytes.length){//如果有该文件,并且大小正好，按下载完成处理，直接返回该文件
                obj.put("fileName", URLDecoder.decode(fileFullName, "UTF-8"));
                msg.what = 100;
                msg.obj = obj;
                mHandler.sendMessage(msg);
                currentDownUrls.remove(urlPath);
                return file;
            }

            OutputStream out = new FileOutputStream(file);
            out.write(bytes, 0, bytes.length);
            msg = new Message();
            msg.what = (int) (bytes.length * 100 / bytes.length);
            msg.obj = obj;
            mHandler.sendMessage(msg);
            out.close();
        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            currentDownUrls.remove(urlPath);
            return file;
        }
    }

    private static boolean isWifiConnect(Context mContext) {
        ConnectivityManager connManager = (ConnectivityManager) mContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo mWifiInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
        return mWifiInfo.isConnected();
    }
    /**
     * 检查wifi强弱
     */
    public static void checkWifiState(Context mContext) {
        if (isWifiConnect(mContext)) {
            WifiManager mWifiManager = (WifiManager) mContext.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
            WifiInfo mWifiInfo = mWifiManager.getConnectionInfo();
            int wifi = mWifiInfo.getRssi();//获取wifi信号强度
            if (wifi > -50 && wifi < 0) {//最强
                Toast.makeText(mContext, "WIFI信号已达到最强王者", Toast.LENGTH_LONG).show();
            } else if (wifi > -70 && wifi < -50) {//较强
                Toast.makeText(mContext, "WIFI信号已达到永恒钻石", Toast.LENGTH_LONG).show();
            } else if (wifi > -80 && wifi < -70) {//较弱
                Toast.makeText(mContext, "WIFI信号已达不屈白银", Toast.LENGTH_LONG).show();
            } else if (wifi > -100 && wifi < -80) {//微弱
                Toast.makeText(mContext, "WIFI信号已达到倔强青铜", Toast.LENGTH_LONG).show();
            }
        } else {
            //无连接
            Toast.makeText(mContext, "WIFI已断开，下载可能会消耗移动流量。", Toast.LENGTH_LONG).show();
        }
    }
}
