package com.redking.view.fragment;

import android.app.Fragment;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;

import com.redking.tbs.video.X5WebView;
import com.tencent.smtt.export.external.interfaces.WebResourceResponse;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import com.redking.x5.R;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by redking on 2018/8/22.
 */

public class VideoPlayFragment extends Fragment{
    String TAG = "VideoPlayFragment";
    X5WebView x5WebView;
    List<View> list;
    String videoPlayUrl;
    String html = "<!DOCTYPE html>\n" +
            "<html>\n" +
            "<head>\n" +
            "    <style>*,body,html,div,p,img{border:0;margin:0;padding:0;} </style>\n" +
            "    <meta name=\"viewport\" content=\"width=device-width\">\n" +
            "</head>\n" +
            "<body >\n" +
            "<video id=\"vi\" style=\"width:100%; height: auto;\" controls=\"\" autoplay=\"\" name=\"media\">\n" +
            "    <source src=\"videoPlayUrl\">\n" +
            "</video>\n" +
            "</body>\n" +
            "<script type=\"text/javascript\">\n" +
            "\n" +
            "    function startPlay()\n" +
            "    {\n" +
            "        var videos = document.getElementById('vi');\n" +
            "        videos.loop = 'loop';\n" +
            "        videos.play();\n" +
            "    }\n" +
            " </script>\n" +
            "</html>";

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.red_fragment_video, null);
        x5WebView = (X5WebView) view.findViewById(R.id.x5_wv);//new X5WebView(getActivity());//
        initData();
        return view;
    }

    private void initData(){
        getActivity().getWindow().setFormat(PixelFormat.TRANSLUCENT);
        x5WebView.loadData(html.replace("videoPlayUrl", videoPlayUrl), "text/html", "utf-8");
        x5WebView.getView().setOverScrollMode(View.OVER_SCROLL_ALWAYS);
        x5WebView.setWebViewClient(new WebViewClient(){

            @Override
            public WebResourceResponse shouldInterceptRequest(WebView webView, String s) {
                return super.shouldInterceptRequest(webView, s);
            }

            @Override
            public void onPageStarted(WebView webView, String s, Bitmap bitmap) {
                super.onPageStarted(webView, s, bitmap);
            }

            @Override
            public void onPageFinished(WebView webView, String s) {
                super.onPageFinished(webView, s);
                webView.loadUrl("javascript:startPlay()");
            }
        });
        getActivity().getWindow().getDecorView().addOnLayoutChangeListener(new View.OnLayoutChangeListener() {
            @Override
            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                ArrayList<View> outView = new ArrayList<>();
                getActivity().getWindow().getDecorView().findViewsWithText(outView, "QQ浏览器", View.FIND_VIEWS_WITH_TEXT);
                if (outView != null && outView.size() > 0) {
                    outView.get(0).setVisibility(View.GONE);
                }
                getActivity().getWindow().getDecorView().findViewsWithText(outView, "缓存", View.FIND_VIEWS_WITH_TEXT);
                if (outView != null && outView.size() > 0) {
                    outView.get(0).setVisibility(View.GONE);
                }

                list = getAllChildViews(getActivity().getWindow().getDecorView());
                if(getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE){
                    if(getActivity().getWindow().getDecorView().findViewById(45) != null)
                        getActivity().getWindow().getDecorView().findViewById(45).setVisibility(View.VISIBLE);
                    if(getActivity().getWindow().getDecorView().findViewById(59) != null)
                        getActivity().getWindow().getDecorView().findViewById(59).setVisibility(View.GONE);
                    if(getActivity().getWindow().getDecorView().findViewById(35) != null)
                        getActivity().getWindow().getDecorView().findViewById(35).setVisibility(View.GONE);
                }else if(getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT){
                    if(getActivity().getWindow().getDecorView().findViewById(45) != null)
                        getActivity().getWindow().getDecorView().findViewById(45).setVisibility(View.VISIBLE);
                    if(getActivity().getWindow().getDecorView().findViewById(59) != null)
                        getActivity().getWindow().getDecorView().findViewById(59).setVisibility(View.GONE);
                }
            }
        });
    }

    public void setVideoPlayUrl(String videoPlayUrl){
        this.videoPlayUrl = videoPlayUrl;

    }
    /**
     *
     * @param videoPlayUrl
     * 要播放的视频地址
     * */
    public void startPlay(String videoPlayUrl){
        this.videoPlayUrl = videoPlayUrl;
        if(x5WebView == null){
            Toast.makeText(getActivity(), "在beginTransaction.commit()之后调用", Toast.LENGTH_LONG).show();
            return;
        }
        x5WebView.loadData(html.replace("videoPlayUrl", videoPlayUrl), "text/html", "utf-8");
    }
    private List<View> getAllChildViews(View view) {
        List<View> allchildren = new ArrayList<View>();
        if (view instanceof ViewGroup) {
            ViewGroup vp = (ViewGroup) view;
            for (int i = 0; i < vp.getChildCount(); i++) {
                View viewchild = vp.getChildAt(i);
                allchildren.add(viewchild);
                //再次 调用本身（递归）
                allchildren.addAll(getAllChildViews(viewchild));
            }
        }
        return allchildren;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        try {
            super.onConfigurationChanged(newConfig);
            if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                WindowManager.LayoutParams attrs = getActivity().getWindow().getAttributes();
                attrs.flags |= WindowManager.LayoutParams.FLAG_FULLSCREEN;
                getActivity().getWindow().setAttributes(attrs);
                getActivity().getWindow().addFlags(
                        WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS);
            } else if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
                WindowManager.LayoutParams attrs = getActivity().getWindow().getAttributes();
                attrs.flags &= (WindowManager.LayoutParams.FLAG_FULLSCREEN);
                getActivity().getWindow().setAttributes(attrs);
                getActivity().getWindow().clearFlags(
                        WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onDestroy() {
        if(x5WebView != null){
            ((ViewGroup)x5WebView.getParent()).removeView(x5WebView);
            x5WebView.stopLoading();
            // 退出时调用此方法，移除绑定的服务，否则某些特定系统会报错
            x5WebView.getSettings().setJavaScriptEnabled(false);
            x5WebView.clearHistory();
            x5WebView.clearView();
            x5WebView.removeAllViews();
            x5WebView.destroy();
            x5WebView = null;
        }
        super.onDestroy();
    }
}
