package com.redking.view.fragment;

import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.redking.tbs.docs.DocView;
import com.redking.tbs.docs.DownLoadUtil;
import com.redking.tbs.docs.FileTypeUtil;
import com.redking.tbs.docs.Md5Tool;
import com.redking.tbs.docs.SharedPrefHelper;
import com.redking.tbs.docs.TencentSdkX5;
import com.redking.view.widget.DownLoadProgress;
import com.redking.x5.R;
import com.tencent.smtt.sdk.QbSdk;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.util.Map;

/**
 * Created by redking on 2018/8/16.
 */

public class DocOpenFragment extends Fragment{

    private String TAG = "DocOpenFragment";
    private DocView docView;
    private RelativeLayout rlPg;
    private TextView tvPg;
    private DownLoadProgress downLoadProgress;
    private String fileUrl = "";
    private ProgressHandler mHandler;
    private String localCachePath;
    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.red_fragment_doc, null);
        initView(view);
        initListener();
        initData();
        return view;
    }

    private void initView(View view){
        docView = (DocView)view.findViewById(R.id.dv);
        downLoadProgress = (DownLoadProgress) view.findViewById(R.id.dlp);
        rlPg = (RelativeLayout) view.findViewById(R.id.rl_pg);
        tvPg = (TextView) view.findViewById(R.id.tv_pg);
    }
    private void initData(){
        mHandler = new ProgressHandler(this);
        docView.show();
    }

    public void initListener() {
        docView.setOnGetFilePathListener(new DocView.OnGetFilePathListener() {
            @Override
            public void onGetFilePath(DocView docView) {
                getFilePathAndShowFile();
            }
        });
    }

    private File file;
    private void getFilePathAndShowFile() {
        if (getFilePath().startsWith("http")) {//网络地址要先下载

            new Thread(new Runnable() {
                @Override
                public void run() {
//                    try{
//                        DownLoadUtil.checkWifiState(getActivity());
//                    }catch (Exception e){
//
//                    }
                    DownLoadUtil.downloadFile(fileUrl, localCachePath, mHandler);
//                    Log.e(TAG, "=========http======文件存储路径为：" + file.getPath());
//                    getActivity().runOnUiThread(new Runnable() {
//                        @Override
//                        public void run() {
//                            openFile();
//                            Log.e(TAG, "========http=======文件名字：" + getFileName(getActivity()));
//                        }
//                    });
                }
            }).start();
        } else {
            file = new File(fileUrl);
            Log.e(TAG, "=========local======文件存储路径为：" + file.getPath());
            Log.e(TAG, "========local=======文件名字：" + getFileName(getActivity()));
            openFile();
        }

    }

    private void openFile(){
//        HashMap<String, String> params = new HashMap<>();
//        params.put("style", "1");
//        params.put("local", "true");
//        QbSdk.openFileReader(getActivity(), file.getPath(), null, new ValueCallback<String>() {
//            @Override
//            public void onReceiveValue(String s) {
//
//            }
//        });
        if(TencentSdkX5.IS_LOADED_X5 == 1){
            Toast.makeText(getActivity(), "内核重新加载中，请稍后再试。", Toast.LENGTH_LONG).show();
            QbSdk.initX5Environment(getActivity(), new QbSdk.PreInitCallback() {
                @Override
                public void onCoreInitFinished() {
                }
                @Override
                public void onViewInitFinished(boolean b) {
                    if(b){
                        if(!getActivity().isFinishing()){
                            rlPg.setVisibility(View.GONE);
                            docView.setVisibility(View.VISIBLE);
                            docView.displayFile(file);
                        }
                    }else {
                        Toast.makeText(getActivity(), "内核加载失败，请稍后再试。", Toast.LENGTH_LONG).show();
                    }
                }
            });
        }else {
            if(!getActivity().isFinishing()){
                rlPg.setVisibility(View.GONE);
                docView.setVisibility(View.VISIBLE);
                docView.displayFile(file);
            }
        }
    }
    /**
     *
     * 获取已下载文件的原始文件名
     *
     * */
    public String getFileName(Context mContext){
        try {
            return URLDecoder.decode((fileUrl.contains("http")) ?
                    (SharedPrefHelper.getInstance(mContext).getFileName(Md5Tool.hashKey(fileUrl)) == "" ?
                            fileUrl.split("/")[fileUrl.split("/").length - 1] :
                            SharedPrefHelper.getInstance(getActivity()).getFileName(Md5Tool.hashKey(fileUrl))):
                    fileUrl.split("/")[fileUrl.split("/").length - 1], "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "文件yula";
    }
    /**
     * 文件地址，可以是网络下载地址也可以是本地路径
     * @param fileUrl
     * */
    public void setFilePath(String fileUrl) {
        this.fileUrl = fileUrl;
    }
    /**
     *
     * 在线文件本地缓存路径设置
     *
     * @param localCachePath
     *
     * 例如： Environment.getExternalStorageDirectory().getAbsolutePath() + "/2039.pdf"
     *
     * */
    public void setLocalCachePath(String localCachePath){
        this.localCachePath = localCachePath;
    }
    /**
     *
     * 在线文件本地缓存路径获取
     *
     * */
    public String getLocalCachePath(){
        if(file == null){
            return null;
        }
        return file.getPath();
    }
    private String getFilePath() {
        return fileUrl;
    }
    @Override
    public void onDestroy() {
        super.onDestroy();
        if (docView != null) {
            docView.onStopDisplay();
        }
    }

    static class ProgressHandler extends Handler{

        WeakReference<DocOpenFragment> mWeakReference;

        public ProgressHandler(DocOpenFragment docOpenFragment){
            mWeakReference = new WeakReference<>(docOpenFragment);
        }
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            final DocOpenFragment docOpenFragment=mWeakReference.get();
            //if(docOpenFragment.getActivity().isFinishing()) return;
            Map<String, String> obj = (Map<String, String>) msg.obj;
            if(obj != null && docOpenFragment!=null && docOpenFragment.fileUrl != null && docOpenFragment.fileUrl.equals(obj.get("url"))) {
                if(msg.what == -1){
                    docOpenFragment.rlPg.setVisibility(View.VISIBLE);
                }else {
                    docOpenFragment.downLoadProgress.setProgress((float) msg.what);
                    docOpenFragment.tvPg.setText(msg.what + "%");
                    if(msg.what == 100){
                        SharedPrefHelper.getInstance(docOpenFragment.getActivity()).setFilename(Md5Tool.hashKey(docOpenFragment.fileUrl), obj.get("fileName"));
                        docOpenFragment.file = new File(obj.get("path"));
                        if(docOpenFragment.getActivity() != null && !docOpenFragment.getActivity().isFinishing())
                        docOpenFragment.openFile();
                    }
                }
            }
        }
    }

    /**
     *
     * 如果无法打开或者格式不支持，
     *
     * 可以调用此方法用本地安装的第三方应用打开
     *
     * */
    public void openByLocalOtherApp(){
        if(getLocalCachePath() == null) {
            Toast.makeText(getActivity(), "文件加载中，稍后再试...", Toast.LENGTH_LONG).show();
            return;
        }
        File files = new File(getLocalCachePath());
        Intent inten = new Intent();
        inten.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        //设置intent的Action属性
        inten.setAction(Intent.ACTION_VIEW);
        //获取文件file的MIME类型
        String type = FileTypeUtil.getMIMEType(files);
        //设置intent的data和Type属性。
        Log.e("DocOpenDemoActivity","=====type: "+type);
        inten.setDataAndType(/*uri*/Uri.fromFile(files), type);
        //跳转
        try {
            startActivity(inten);
        }catch (ActivityNotFoundException e){
            Toast.makeText(getActivity(),"未找到打开此文件的第三方应用", Toast.LENGTH_LONG).show();
        }
    }
}
