package com.redking.tbs.docs;

import android.content.Context;
import android.content.SharedPreferences;

import java.util.List;

/**
 * Created by redking on 2018/8/20.
 */

public class SharedPrefHelper {

    /**
     * SharedPreferences的名字
     */
    private static final String SP_FILE_NAME = "redDocs";
    private static SharedPrefHelper sharedPrefHelper = null;
    private static SharedPreferences sharedPreferences;
    private Context mContext;
    public static synchronized SharedPrefHelper getInstance(Context mContext) {
        if (null == sharedPrefHelper) {
            sharedPrefHelper = new SharedPrefHelper(mContext);
        }
        return sharedPrefHelper;
    }

    public static synchronized SharedPrefHelper getInstance() {

        return sharedPrefHelper;
    }

    private SharedPrefHelper(Context mContext) {
        this.mContext = mContext;
        sharedPreferences = mContext.getSharedPreferences(SP_FILE_NAME, Context.MODE_PRIVATE);
    }

    /**
     *
     * @param key fileUrl的MD5值， value文件原始名字
     *
     */
    public void setFilename(String key, String value) {
        sharedPreferences.edit().putString(key, value).commit();
    }

    /**
     *
     * @param key fileUrl的MD5值
     *
     */
    public String getFileName(String key){
        return sharedPreferences.getString(key, "");
    }
}
