/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch.aggregation.reducers;

import io.redisearch.aggregation.SortedField;
import io.redisearch.aggregation.reducers.Reducer;
import java.util.List;

public class Reducers {
    public static Reducer count() {
        return new Reducer(){

            @Override
            public String getName() {
                return "COUNT";
            }
        };
    }

    private static Reducer singleFieldReducer(final String name, String field) {
        return new Reducer(field){

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public static Reducer count_distinct(String field) {
        return Reducers.singleFieldReducer("COUNT_DISTINCT", field);
    }

    public static Reducer count_distinctish(String field) {
        return Reducers.singleFieldReducer("COUNT_DISTINCTISH", field);
    }

    public static Reducer sum(String field) {
        return Reducers.singleFieldReducer("SUM", field);
    }

    public static Reducer min(String field) {
        return Reducers.singleFieldReducer("MIN", field);
    }

    public static Reducer max(String field) {
        return Reducers.singleFieldReducer("MAX", field);
    }

    public static Reducer avg(String field) {
        return Reducers.singleFieldReducer("AVG", field);
    }

    public static Reducer stddev(String field) {
        return Reducers.singleFieldReducer("STDDEV", field);
    }

    public static Reducer quantile(String field, final double percentile) {
        return new Reducer(field){

            @Override
            public String getName() {
                return "QUANTILE";
            }

            @Override
            protected List<String> getOwnArgs() {
                List<String> args = super.getOwnArgs();
                args.add(Double.toString(percentile));
                return args;
            }
        };
    }

    public static Reducer first_value(String field, final SortedField sortBy) {
        return new Reducer(field){

            @Override
            public String getName() {
                return "FIRST_VALUE";
            }

            @Override
            protected List<String> getOwnArgs() {
                List<String> args = super.getOwnArgs();
                if (sortBy != null) {
                    args.add("BY");
                    args.add(sortBy.getField());
                    args.add(sortBy.getOrder());
                }
                return args;
            }
        };
    }

    public static Reducer first_value(String field) {
        return Reducers.first_value(field, null);
    }

    public static Reducer to_list(String field) {
        return Reducers.singleFieldReducer("TOLIST", field);
    }

    public static Reducer random_sample(String field, final int size) {
        return new Reducer(field){

            @Override
            public String getName() {
                return "RANDOM_SAMPLE";
            }

            @Override
            protected List<String> getOwnArgs() {
                List<String> args = super.getOwnArgs();
                args.add(Integer.toString(size));
                return args;
            }
        };
    }
}

