/*
 * Decompiled with CFR 0.152.
 */
package com.redis.enterprise;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.redis.enterprise.RedisModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hc.core5.util.Asserts;
import org.springframework.util.unit.DataSize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Database {
    private Long uid;
    private String name;
    private boolean replication;
    private boolean sharding;
    private long memory;
    private Integer port;
    private String type;
    private boolean ossCluster;
    private ProxyPolicy proxyPolicy;
    private IPType ossClusterAPIPreferredIPType;
    private List<ShardKeyRegex> shardKeyRegex;
    private Integer shardCount;
    private ShardPlacement shardPlacement;
    private List<ModuleConfig> modules;

    private Database() {
    }

    private Database(Builder builder) {
        this.uid = builder.uid;
        this.name = builder.name;
        this.replication = builder.replication;
        this.sharding = builder.sharding;
        this.memory = builder.memory.toBytes();
        this.port = builder.port;
        this.type = builder.type;
        this.ossCluster = builder.ossCluster;
        this.proxyPolicy = builder.proxyPolicy;
        this.ossClusterAPIPreferredIPType = builder.ossClusterAPIPreferredIPType;
        this.shardKeyRegex = builder.shardKeyRegexes.stream().map(ShardKeyRegex::new).collect(Collectors.toList());
        this.shardCount = builder.shardCount;
        this.shardPlacement = builder.shardPlacement;
        this.modules = builder.moduleConfigs;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReplication() {
        return this.replication;
    }

    public void setReplication(boolean replication) {
        this.replication = replication;
    }

    public boolean isSharding() {
        return this.sharding;
    }

    public void setSharding(boolean sharding) {
        this.sharding = sharding;
    }

    @JsonProperty(value="memory_size")
    public long getMemory() {
        return this.memory;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="oss_cluster")
    public boolean isOssCluster() {
        return this.ossCluster;
    }

    public void setOssCluster(boolean ossCluster) {
        this.ossCluster = ossCluster;
    }

    @JsonProperty(value="proxy_policy")
    public ProxyPolicy getProxyPolicy() {
        return this.proxyPolicy;
    }

    public void setProxyPolicy(ProxyPolicy proxyPolicy) {
        this.proxyPolicy = proxyPolicy;
    }

    @JsonProperty(value="oss_cluster_api_preferred_ip_type")
    public IPType getOssClusterAPIPreferredIPType() {
        return this.ossClusterAPIPreferredIPType;
    }

    public void setOssClusterAPIPreferredIPType(IPType ossClusterAPIPreferredIPType) {
        this.ossClusterAPIPreferredIPType = ossClusterAPIPreferredIPType;
    }

    @JsonProperty(value="shard_key_regex")
    public List<ShardKeyRegex> getShardKeyRegex() {
        return this.shardKeyRegex;
    }

    public void setShardKeyRegex(List<ShardKeyRegex> shardKeyRegex) {
        this.shardKeyRegex = shardKeyRegex;
    }

    @JsonProperty(value="shards_count")
    public Integer getShardCount() {
        return this.shardCount;
    }

    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    @JsonProperty(value="shards_placement")
    public ShardPlacement getShardPlacement() {
        return this.shardPlacement;
    }

    public void setShardPlacement(ShardPlacement shardPlacement) {
        this.shardPlacement = shardPlacement;
    }

    @JsonProperty(value="module_list")
    public List<ModuleConfig> getModules() {
        return this.modules;
    }

    public void setModules(List<ModuleConfig> modules) {
        this.modules = modules;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.memory, this.modules, this.name, this.ossCluster, this.ossClusterAPIPreferredIPType, this.port, this.proxyPolicy, this.replication, this.shardCount, this.shardKeyRegex, this.shardPlacement, this.sharding, this.type, this.uid});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Database other = (Database)obj;
        return this.memory == other.memory && Objects.equals(this.modules, other.modules) && Objects.equals(this.name, other.name) && this.ossCluster == other.ossCluster && this.ossClusterAPIPreferredIPType == other.ossClusterAPIPreferredIPType && Objects.equals(this.port, other.port) && this.proxyPolicy == other.proxyPolicy && this.replication == other.replication && Objects.equals(this.shardCount, other.shardCount) && Objects.equals(this.shardKeyRegex, other.shardKeyRegex) && this.shardPlacement == other.shardPlacement && this.sharding == other.sharding && Objects.equals(this.type, other.type) && Objects.equals(this.uid, other.uid);
    }

    public static Builder name(String name) {
        return new Builder().name(name);
    }

    public static final class Builder {
        public static final long DEFAULT_MEMORY_MB = 100L;
        public static final int DEFAULT_CLUSTER_SHARD_COUNT = 3;
        public static final String[] DEFAULT_SHARD_KEY_REGEXES = new String[]{".*\\{(?<tag>.*)\\}.*", "(?<tag>.*)"};
        private Long uid;
        private String name;
        private boolean replication;
        private boolean sharding;
        private DataSize memory = DataSize.ofMegabytes(100L);
        private Integer port;
        private String type;
        private boolean ossCluster;
        private ProxyPolicy proxyPolicy;
        private IPType ossClusterAPIPreferredIPType;
        private List<String> shardKeyRegexes = new ArrayList<String>();
        private Integer shardCount;
        private ShardPlacement shardPlacement;
        private List<ModuleConfig> moduleConfigs = new ArrayList<ModuleConfig>();

        private Builder() {
        }

        public Builder uid(Long uid) {
            this.uid = uid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder replication(boolean replication) {
            this.replication = replication;
            return this;
        }

        public Builder sharding(boolean sharding) {
            this.sharding = sharding;
            return this;
        }

        public Builder memory(DataSize memory) {
            this.memory = memory;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder ossCluster(boolean ossCluster) {
            this.ossCluster = ossCluster;
            if (ossCluster) {
                this.proxyPolicy(ProxyPolicy.ALL_MASTER_SHARDS);
                this.ossClusterAPIPreferredIPType(IPType.EXTERNAL);
                if (this.shardCount == null || this.shardCount < 2) {
                    this.shardCount(3);
                }
            }
            return this;
        }

        public Builder proxyPolicy(ProxyPolicy proxyPolicy) {
            this.proxyPolicy = proxyPolicy;
            return this;
        }

        public Builder ossClusterAPIPreferredIPType(IPType ossClusterAPIPreferredIPType) {
            this.ossClusterAPIPreferredIPType = ossClusterAPIPreferredIPType;
            return this;
        }

        public Builder shardKeyRegex(String regex) {
            this.shardKeyRegexes.add(regex);
            return this;
        }

        public Builder shardKeyRegexes(String ... regexes) {
            for (String regex : regexes) {
                this.shardKeyRegex(regex);
            }
            return this;
        }

        public Builder shardCount(int shardCount) {
            Asserts.check((shardCount > 0 ? 1 : 0) != 0, (String)"Shard count must be strictly positive");
            this.shardCount = shardCount;
            if (shardCount > 1) {
                this.sharding(true);
                this.shardKeyRegexes(DEFAULT_SHARD_KEY_REGEXES);
            }
            return this;
        }

        public Builder shardPlacement(ShardPlacement shardPlacement) {
            this.shardPlacement = shardPlacement;
            return this;
        }

        public Builder module(RedisModule module) {
            this.moduleConfigs.add(new ModuleConfig(module.getModuleName()));
            return this;
        }

        public Builder modules(RedisModule ... modules) {
            for (RedisModule module : modules) {
                this.module(module);
            }
            return this;
        }

        public Builder moduleConfig(ModuleConfig moduleConfig) {
            this.moduleConfigs.add(moduleConfig);
            return this;
        }

        public Builder moduleConfigs(ModuleConfig ... moduleConfigs) {
            this.moduleConfigs = Arrays.asList(moduleConfigs);
            return this;
        }

        public Database build() {
            return new Database(this);
        }
    }

    public static enum ProxyPolicy {
        SINGLE,
        ALL_MASTER_SHARDS,
        ALL_NODES;

    }

    public static enum IPType {
        INTERNAL,
        EXTERNAL;

    }

    public static enum ShardPlacement {
        DENSE,
        SPARSE;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ShardKeyRegex {
        private String regex;

        public ShardKeyRegex() {
        }

        public ShardKeyRegex(String regex) {
            this.regex = regex;
        }

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ModuleConfig {
        private String name;
        private String id;
        private String args = "";

        public ModuleConfig() {
        }

        public ModuleConfig(String name) {
            this.name = name;
        }

        @JsonProperty(value="module_name")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="module_id")
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="module_args")
        public String getArgs() {
            return this.args;
        }

        public void setArgs(String args) {
            this.args = args;
        }
    }
}

