/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.util;

import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import com.redis.lettucemod.util.AbstractClientBuilder;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.resource.ClientResources;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractClusterClientBuilder<B extends AbstractClusterClientBuilder<B>>
extends AbstractClientBuilder<B> {
    private int maxRedirects = 5;
    private boolean validateClusterNodeMembership = true;
    private Predicate<RedisClusterNode> nodeFilter = DEFAULT_NODE_FILTER;
    private Optional<ClusterTopologyRefreshOptions> topologyRefreshOptions = Optional.empty();

    protected AbstractClusterClientBuilder(RedisURI redisURI) {
        super(redisURI);
    }

    public B maxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return (B)this;
    }

    public B validateClusterNodeMembership(boolean validateClusterNodeMembership) {
        this.validateClusterNodeMembership = validateClusterNodeMembership;
        return (B)this;
    }

    public B nodeFilter(Predicate<RedisClusterNode> nodeFilter) {
        this.nodeFilter = nodeFilter;
        return (B)this;
    }

    public B topologyRefreshOptions(ClusterTopologyRefreshOptions topologyRefreshOptions) {
        return this.topologyRefreshOptions(Optional.of(topologyRefreshOptions));
    }

    public B topologyRefreshOptions(Optional<ClusterTopologyRefreshOptions> topologyRefreshOptions) {
        this.topologyRefreshOptions = topologyRefreshOptions;
        return (B)this;
    }

    protected RedisModulesClusterClient clusterClient() {
        ClientResources clientResources = this.clientResources();
        ClusterClientOptions.Builder clientOptions = this.configure(ClusterClientOptions.builder());
        clientOptions.maxRedirects(this.maxRedirects);
        clientOptions.validateClusterNodeMembership(this.validateClusterNodeMembership);
        clientOptions.nodeFilter(this.nodeFilter);
        this.topologyRefreshOptions.ifPresent(arg_0 -> ((ClusterClientOptions.Builder)clientOptions).topologyRefreshOptions(arg_0));
        RedisModulesClusterClient client = RedisModulesClusterClient.create(clientResources, this.redisURI);
        client.setOptions(clientOptions.build());
        return client;
    }
}

