/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.gears.Execution;
import com.redis.lettucemod.output.OutputFactory;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ExecutionListOutput<K, V>
extends CommandOutput<K, V, List<Execution>>
implements StreamingOutput<Execution> {
    private boolean initialized;
    private StreamingOutput.Subscriber<Execution> subscriber;
    private Execution execution;
    private String field;

    public ExecutionListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Execution>)ListSubscriber.instance());
    }

    public void set(ByteBuffer bytes) {
        if (this.field == null) {
            this.field = this.decodeAscii(bytes);
            return;
        }
        if (this.fieldEquals("executionId")) {
            this.execution = new Execution();
            this.execution.setId(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (this.fieldEquals("status")) {
            this.execution.setStatus(this.decodeAscii(bytes));
            this.field = null;
        }
    }

    private boolean fieldEquals(String name) {
        return name.equals(this.field);
    }

    public void set(long integer) {
        if (this.fieldEquals("registered")) {
            this.execution.setRegistered(integer);
            this.field = null;
            this.subscriber.onNext((Collection)this.output, (Object)this.execution);
            this.execution = null;
        }
    }

    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    public void setSubscriber(StreamingOutput.Subscriber<Execution> subscriber) {
        this.subscriber = subscriber;
    }

    public StreamingOutput.Subscriber<Execution> getSubscriber() {
        return this.subscriber;
    }
}

