/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims.fingerprint;

import com.redhat.victims.fingerprint.AbstractFile;
import com.redhat.victims.fingerprint.Artifact;
import com.redhat.victims.fingerprint.Key;
import com.redhat.victims.fingerprint.Metadata;
import com.redhat.victims.fingerprint.Processor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;

public class JarFile
extends AbstractFile {
    public static final boolean RECURSIVE = true;
    private static final int BUFFER = 2048;
    protected ArrayList<Object> contents = new ArrayList();
    protected ArrayList<Object> embedded = new ArrayList();
    protected HashMap<String, Metadata> metadata = new HashMap();
    protected JarInputStream jis;

    protected synchronized void putMetadata(String filename, Metadata md) {
        this.metadata.put(filename, md);
    }

    protected synchronized void addContent(Artifact record, String filename) {
        if (record != null) {
            if (filename.endsWith(".jar")) {
                this.embedded.add(record);
            } else {
                this.contents.add(record);
            }
        }
    }

    protected void processContent(Content file) {
        String lowerCaseFileName = file.name.toLowerCase();
        if (lowerCaseFileName.endsWith("pom.properties")) {
            ByteArrayInputStream is = new ByteArrayInputStream(file.bytes);
            Metadata md = Metadata.fromPomProperties(is);
            this.putMetadata(file.name, md);
        }
        Artifact record = Processor.process(file.bytes, file.name, true);
        this.addContent(record, file.name);
    }

    protected void submitJob(ExecutorService executor, Content file) {
        class OneShotTask
        implements Runnable {
            Content file;

            OneShotTask(Content file) {
                this.file = file;
            }

            @Override
            public void run() {
                JarFile.this.processContent(this.file);
            }
        }
        executor.submit(new OneShotTask(file));
    }

    public JarFile(byte[] bytes, String fileName) throws IOException {
        Content file;
        this.fileName = fileName;
        this.jis = new JarInputStream(new ByteArrayInputStream(bytes));
        ExecutorService executor = Executors.newCachedThreadPool();
        while ((file = this.getNextFile()) != null) {
            this.submitJob(executor, file);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("There was an issue while waiting for the ExecutorService to terminate.", e);
        }
        Manifest mf = this.jis.getManifest();
        if (mf != null) {
            this.metadata.put("MANIFEST.MF", Metadata.fromManifest(mf));
        }
        this.fingerprint = Processor.fingerprint(bytes);
        this.jis.close();
    }

    public JarFile(String fileName) throws IOException {
        this(new FileInputStream(fileName), fileName);
    }

    public JarFile(InputStream is, String fileName) throws IOException {
        this(IOUtils.toByteArray((InputStream)is), fileName);
    }

    @Override
    public Artifact getRecord() {
        Artifact result = super.getRecord();
        result.put(Key.CONTENT, this.contents);
        result.put(Key.METADATA, this.metadata);
        result.put(Key.EMBEDDED, this.embedded);
        return result;
    }

    protected Content getNextFile() throws IOException {
        JarEntry entry = this.jis.getNextJarEntry();
        if (entry != null) {
            int size;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] data = new byte[2048];
            while ((size = this.jis.read(data, 0, data.length)) != -1) {
                bos.write(data, 0, size);
            }
            Content file = new Content(entry.getName(), bos.toByteArray());
            bos.close();
            return file;
        }
        return null;
    }

    protected static class Content {
        public String name;
        public byte[] bytes;

        public Content(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }
    }
}

