/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.VictimsConfig;
import com.redhat.victims.VictimsRecord;
import com.redhat.victims.fingerprint.Artifact;
import com.redhat.victims.fingerprint.Processor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class VictimsScanner {
    private static void scanArtifact(Artifact artifact, VictimsOutputStream vos) throws IOException {
        ArrayList<Artifact> embedded = artifact.embedded();
        if (embedded != null) {
            for (Artifact eartifact : artifact.embedded()) {
                VictimsScanner.scanArtifact(eartifact, vos);
            }
        }
        VictimsRecord record = new VictimsRecord(artifact);
        vos.write(record);
    }

    private static void scanFile(File file, VictimsOutputStream vos) throws IOException {
        File f = file;
        String path = f.getAbsolutePath();
        Artifact artifact = Processor.process(path);
        VictimsScanner.scanArtifact(artifact, vos);
    }

    private static void scanDir(File dir, VictimsOutputStream vos) throws IOException {
        Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)new RegexFileFilter("^(.*?)\\.jar"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        Iterator fi = files.iterator();
        while (fi.hasNext()) {
            VictimsScanner.scanFile((File)fi.next(), vos);
        }
    }

    private static void scanSource(String source, VictimsOutputStream vos) throws IOException {
        File f = new File(FilenameUtils.normalize((String)source));
        if (f.isDirectory()) {
            VictimsScanner.scanDir(f, vos);
        } else if (f.isFile()) {
            VictimsScanner.scanFile(f, vos);
        } else {
            throw new IOException(String.format("Invalid source file: '%s'", source));
        }
    }

    public static void scan(String source, OutputStream os) throws IOException {
        VictimsScanner.scanSource(source, new StringOutputStream(os));
    }

    public static void scan(String source, ArrayList<VictimsRecord> results) throws IOException {
        VictimsScanner.scanSource(source, new ArrayOutputStream(results));
    }

    public static ArrayList<VictimsRecord> getRecords(String source) throws IOException {
        ArrayList<VictimsRecord> records = new ArrayList<VictimsRecord>();
        VictimsScanner.scan(source, records);
        return records;
    }

    public static ArrayList<VictimsRecord> getRecords(InputStream in, String filename) throws IOException {
        ArrayList<VictimsRecord> records = new ArrayList<VictimsRecord>();
        Artifact artifact = Processor.process(in, filename);
        VictimsScanner.scanArtifact(artifact, new ArrayOutputStream(records));
        return records;
    }

    private static class StringOutputStream
    extends VictimsOutputStream {
        private final OutputStream os;

        public StringOutputStream(OutputStream os) {
            this.os = os;
        }

        @Override
        public void write(VictimsRecord record) throws IOException {
            String line = record.toString();
            line = line + "\n";
            this.os.write(line.getBytes(VictimsConfig.charset()));
        }
    }

    private static class ArrayOutputStream
    extends VictimsOutputStream {
        private final ArrayList<VictimsRecord> records;

        public ArrayOutputStream(ArrayList<VictimsRecord> records) {
            this.records = records;
        }

        @Override
        public void write(VictimsRecord record) {
            this.records.add(record);
        }
    }

    private static abstract class VictimsOutputStream {
        private VictimsOutputStream() {
        }

        public abstract void write(VictimsRecord var1) throws IOException;
    }
}

