/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.VictimsConfig;
import com.redhat.victims.VictimsException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class VictimsResultCache {
    protected static String CACHE_NAME = "lib.results.cache";
    protected static String location = null;
    protected static boolean purged = false;

    protected void create(File cache) throws VictimsException {
        try {
            FileUtils.forceMkdir((File)cache);
        }
        catch (IOException e) {
            throw new VictimsException("Could not create an on disk cache", e);
        }
    }

    public void purge() throws VictimsException {
        try {
            File cache = new File(location);
            if (cache.exists()) {
                FileUtils.deleteDirectory((File)cache);
            }
            this.create(cache);
        }
        catch (IOException e) {
            throw new VictimsException("Could not purge on disk cache.", e);
        }
    }

    public VictimsResultCache() throws VictimsException {
        location = FilenameUtils.concat((String)VictimsConfig.home().toString(), (String)CACHE_NAME);
        File cache = new File(location);
        if (!cache.exists()) {
            this.create(cache);
        } else if (VictimsConfig.purgeCache() && !purged) {
            this.purge();
            purged = true;
        }
    }

    protected String hash(String key) throws VictimsException {
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-256");
            return Hex.encodeHexString((byte[])mda.digest(key.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new VictimsException(String.format("Could not hash key: %s", key), e);
        }
    }

    public boolean exists(String key) {
        try {
            key = this.hash(key);
            return FileUtils.getFile((String[])new String[]{location, key}).exists();
        }
        catch (VictimsException e) {
            return false;
        }
    }

    public void delete(String key) throws VictimsException {
        key = this.hash(key);
        try {
            FileUtils.forceDelete((File)FileUtils.getFile((String[])new String[]{location, key}));
        }
        catch (IOException e) {
            throw new VictimsException(String.format("Could not delete the cached entry from disk: %s", key), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, Collection<String> cves) throws VictimsException {
        if (this.exists(key = this.hash(key))) {
            this.delete(key);
        }
        String result = "";
        if (cves != null) {
            result = StringUtils.join(cves, (String)",");
        }
        try {
            FileOutputStream fos = new FileOutputStream(FileUtils.getFile((String[])new String[]{location, key}));
            try {
                fos.write(result.getBytes());
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            throw new VictimsException(String.format("Could not add disk entry for key: %s", key), e);
        }
    }

    public HashSet<String> get(String key) throws VictimsException {
        key = this.hash(key);
        try {
            HashSet<String> cves = new HashSet<String>();
            String result = FileUtils.readFileToString((File)FileUtils.getFile((String[])new String[]{location, key})).trim();
            for (String cve : StringUtils.split((String)result, (String)",")) {
                cves.add(cve);
            }
            return cves;
        }
        catch (IOException e) {
            throw new VictimsException(String.format("Could not read contents of entry with key: %s", key), e);
        }
    }
}

