/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redhat.victims.VictimsConfig;
import com.redhat.victims.fingerprint.Algorithms;
import com.redhat.victims.fingerprint.Artifact;
import com.redhat.victims.fingerprint.Fingerprint;
import com.redhat.victims.fingerprint.Metadata;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.commons.io.FilenameUtils;

public class VictimsRecord {
    protected static final String UNKNOWN = Placeholder.UNKNOWN.toString();
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String SCHEMA_VERSION = "2.0";
    public String db_version = "2.0";
    public RecordStatus status;
    public Integer id;
    public Date date;
    public Date submittedon;
    public String submitter;
    public ArrayList<String> cves;
    public String name = UNKNOWN;
    public String format;
    public String vendor = UNKNOWN;
    public String version = UNKNOWN;
    public ArrayList<MetaRecord> meta;
    public String hash;
    public HashRecords hashes;

    public static VictimsRecord fromJSON(String jsonStr) {
        Gson gson = new GsonBuilder().setDateFormat(DATE_FORMAT).create();
        return (VictimsRecord)gson.fromJson(jsonStr, VictimsRecord.class);
    }

    public String toString() {
        Gson gson = new GsonBuilder().setDateFormat(DATE_FORMAT).create();
        return gson.toJson((Object)this);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof VictimsRecord)) {
            return false;
        }
        VictimsRecord that = (VictimsRecord)rhs;
        for (Algorithms algorithm : VictimsConfig.algorithms()) {
            HashSet<String> thatHashes = new HashSet<String>(that.getHashes(algorithm).keySet());
            HashSet<String> thisHashes = new HashSet<String>(this.getHashes(algorithm).keySet());
            if (thisHashes.equals(thatHashes)) continue;
            return false;
        }
        return this.hash.equals(that.hash);
    }

    public boolean containsAlgorithm(Algorithms algorithm) {
        return this.hashes.containsKey(VictimsRecord.normalizeKey(algorithm));
    }

    public boolean containsAll(Object o) {
        if (!(o instanceof VictimsRecord)) {
            return false;
        }
        VictimsRecord that = (VictimsRecord)o;
        for (Algorithms algorithm : VictimsConfig.algorithms()) {
            if (!this.containsAlgorithm(algorithm) || !that.containsAlgorithm(algorithm)) continue;
            HashSet<String> thatHashes = new HashSet<String>(that.getHashes(algorithm).keySet());
            HashSet<String> thisHashes = new HashSet<String>(this.getHashes(algorithm).keySet());
            if (thisHashes.isEmpty() || thatHashes.isEmpty() || !thisHashes.containsAll(thatHashes)) continue;
            return true;
        }
        return this.hash.equals(that.hash);
    }

    private void setFromMetadata(Metadata md) {
        String vendorkey = Attributes.Name.IMPLEMENTATION_VENDOR.toString();
        String versionkey = Attributes.Name.IMPLEMENTATION_VERSION.toString();
        String namekey = Attributes.Name.IMPLEMENTATION_TITLE.toString();
        if (this.vendor.equals(UNKNOWN) && md.containsKey(vendorkey)) {
            this.vendor = (String)md.get(vendorkey);
        }
        if (this.version.equals(UNKNOWN) && md.containsKey(versionkey)) {
            this.version = (String)md.get(versionkey);
        }
        if (this.name.equals(UNKNOWN) && md.containsKey(namekey)) {
            this.name = (String)md.get(namekey);
        }
    }

    public VictimsRecord(Artifact artifact) {
        ArrayList<Artifact> artifacts;
        Fingerprint fingerprint;
        this.status = RecordStatus.NEW;
        this.meta = new ArrayList();
        this.hashes = new HashRecords();
        this.cves = new ArrayList();
        HashMap<String, Metadata> metadatas = artifact.metadata();
        if (metadatas != null) {
            for (String key : metadatas.keySet()) {
                Metadata md = metadatas.get(key);
                this.setFromMetadata(md);
                MetaRecord mr = new MetaRecord();
                mr.put("filename", (Object)key);
                mr.put("properties", (Object)md);
                this.meta.add(mr);
            }
        }
        this.format = FormatMap.mapType(artifact.filetype());
        if (this.name.equals(UNKNOWN)) {
            this.name = FilenameUtils.getBaseName((String)artifact.filename());
        }
        if ((fingerprint = artifact.fingerprint()) != null) {
            for (Algorithms alg : fingerprint.keySet()) {
                String key = VictimsRecord.normalizeKey(alg);
                if (this.hashes.containsKey(key)) continue;
                Record hashRecord = new Record();
                hashRecord.put("files", new StringMap());
                hashRecord.put("combined", artifact.fingerprint().get((Object)alg));
                this.hashes.put(key, hashRecord);
            }
        }
        if ((artifacts = artifact.contents()) != null) {
            for (Artifact file : artifacts) {
                if (!file.filetype().equals(".class") || (fingerprint = file.fingerprint()) == null) continue;
                for (Algorithms alg : fingerprint.keySet()) {
                    String key = VictimsRecord.normalizeKey(alg);
                    ((StringMap)((Record)this.hashes.get(key)).get("files")).put(fingerprint.get((Object)alg), file.filename());
                }
            }
        }
        this.hash = (String)artifact.fingerprint().get((Object)Algorithms.SHA512);
    }

    public static String normalizeKey(Algorithms alg) {
        if (alg.equals((Object)Algorithms.SHA512)) {
            return "sha512";
        }
        return alg.toString().toLowerCase();
    }

    public String getHash(Algorithms alg) {
        Record record;
        String key = VictimsRecord.normalizeKey(alg);
        if (this.hashes.containsKey(key) && (record = (Record)this.hashes.get(key)).containsKey("combined")) {
            return (String)record.get("combined");
        }
        return "";
    }

    public Map<String, String> getHashes(Algorithms alg) {
        Record record;
        String key = VictimsRecord.normalizeKey(alg);
        if (this.hashes.containsKey(key) && (record = (Record)this.hashes.get(key)).containsKey("files")) {
            return (Map)record.get("files");
        }
        return new HashMap<String, String>();
    }

    public HashMap<String, String> getFlattenedMetaData() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (MetaRecord mr : this.meta) {
            result.putAll((Map)mr.get("properties"));
        }
        return result;
    }

    public static class MetaRecord
    extends Record {
        public static final ArrayList<Class<?>> PERMITTED_VALUE_TYPES = new ArrayList();

        @Override
        public Object put(String key, Object value) {
            for (Class<?> candidate : PERMITTED_VALUE_TYPES) {
                if (!candidate.isAssignableFrom(value.getClass())) continue;
                return super.put(key, value);
            }
            System.out.println(key.toString());
            throw new IllegalArgumentException(String.format("Values of class type <%s> are not permitted in <%s>", value.getClass().getName(), this.getClass().getName()));
        }

        static {
            PERMITTED_VALUE_TYPES.add(Metadata.class);
            PERMITTED_VALUE_TYPES.add(String.class);
            PERMITTED_VALUE_TYPES.add(Map.class);
        }
    }

    public static class HashRecords
    extends HashMap<String, Record> {
    }

    public static class Record
    extends HashMap<String, Object> {
    }

    public static class StringMap
    extends HashMap<String, String> {
    }

    public static class FormatMap {
        protected static final HashMap<String, String> MAP = new HashMap();

        public static String mapType(String filetype) {
            if (MAP.containsKey(filetype.toLowerCase())) {
                return MAP.get(filetype.toLowerCase());
            }
            return "Unknown";
        }

        static {
            MAP.put(".jar", "Jar");
            MAP.put(".class", "Class");
            MAP.put(".pom", "Pom");
        }
    }

    public static class FieldName {
        public static final String FILE_HASHES = "files";
        public static final String COMBINED_HASH = "combined";
        public static final String SHA512 = "sha512";
        public static final String META_PROPERTIES = "properties";
        public static final String META_FILENAME = "filename";
    }

    public static enum Placeholder {
        UNKNOWN;

    }

    public static enum RecordStatus {
        SUBMITTED,
        RELEASED,
        NEW;

    }
}

