/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.redhat.lightblue.crud.MetadataResolver;
import com.redhat.lightblue.crud.mongo.CannotTranslateException;
import com.redhat.lightblue.crud.mongo.Merge;
import com.redhat.lightblue.metadata.ArrayElement;
import com.redhat.lightblue.metadata.ArrayField;
import com.redhat.lightblue.metadata.EntityMetadata;
import com.redhat.lightblue.metadata.FieldCursor;
import com.redhat.lightblue.metadata.FieldTreeNode;
import com.redhat.lightblue.metadata.ObjectArrayElement;
import com.redhat.lightblue.metadata.ObjectField;
import com.redhat.lightblue.metadata.ReferenceField;
import com.redhat.lightblue.metadata.SimpleArrayElement;
import com.redhat.lightblue.metadata.SimpleField;
import com.redhat.lightblue.metadata.Type;
import com.redhat.lightblue.query.ArrayContainsExpression;
import com.redhat.lightblue.query.ArrayMatchExpression;
import com.redhat.lightblue.query.ArrayUpdateExpression;
import com.redhat.lightblue.query.BinaryComparisonOperator;
import com.redhat.lightblue.query.CompositeSortKey;
import com.redhat.lightblue.query.FieldAndRValue;
import com.redhat.lightblue.query.FieldComparisonExpression;
import com.redhat.lightblue.query.NaryLogicalExpression;
import com.redhat.lightblue.query.NaryLogicalOperator;
import com.redhat.lightblue.query.NaryRelationalExpression;
import com.redhat.lightblue.query.NaryRelationalOperator;
import com.redhat.lightblue.query.PartialUpdateExpression;
import com.redhat.lightblue.query.PrimitiveUpdateExpression;
import com.redhat.lightblue.query.Projection;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.query.RValueExpression;
import com.redhat.lightblue.query.RegexMatchExpression;
import com.redhat.lightblue.query.SetExpression;
import com.redhat.lightblue.query.Sort;
import com.redhat.lightblue.query.SortKey;
import com.redhat.lightblue.query.UnaryLogicalExpression;
import com.redhat.lightblue.query.UnaryLogicalOperator;
import com.redhat.lightblue.query.UnsetExpression;
import com.redhat.lightblue.query.UpdateExpression;
import com.redhat.lightblue.query.UpdateExpressionList;
import com.redhat.lightblue.query.Value;
import com.redhat.lightblue.query.ValueComparisonExpression;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonDoc;
import com.redhat.lightblue.util.JsonNodeCursor;
import com.redhat.lightblue.util.Path;
import com.redhat.lightblue.util.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Translator {
    public static final String OBJECT_TYPE_STR = "objectType";
    public static final Path OBJECT_TYPE = new Path("objectType");
    public static final Path ID_PATH = new Path("_id");
    public static final String ERR_NO_OBJECT_TYPE = "NO_OBJECT_TYPE";
    public static final String ERR_INVALID_OBJECTTYPE = "INVALID_OBJECTTYPE";
    public static final String ERR_INVALID_FIELD = "INVALID_FIELD";
    public static final String ERR_INVALID_COMPARISON = "INVALID_COMPARISON";
    private static final Logger LOGGER = LoggerFactory.getLogger(Translator.class);
    private final MetadataResolver mdResolver;
    private final JsonNodeFactory factory;
    private static final Map<BinaryComparisonOperator, String> BINARY_COMPARISON_OPERATOR_JS_MAP = new HashMap<BinaryComparisonOperator, String>();
    private static final Map<BinaryComparisonOperator, String> BINARY_COMPARISON_OPERATOR_MAP;
    private static final Map<NaryLogicalOperator, String> NARY_LOGICAL_OPERATOR_MAP;
    private static final Map<UnaryLogicalOperator, String> UNARY_LOGICAL_OPERATOR_MAP;
    private static final Map<NaryRelationalOperator, String> NARY_RELATIONAL_OPERATOR_MAP;
    private static final String LITERAL_THIS_DOT = "this.";

    public Translator(MetadataResolver mdResolver, JsonNodeFactory factory) {
        this.mdResolver = mdResolver;
        this.factory = factory;
    }

    public static String translatePath(Path p) {
        StringBuilder str = new StringBuilder();
        int n = p.numSegments();
        for (int i = 0; i < n; ++i) {
            String s = p.head(i);
            if (s.equals("*")) continue;
            if (i > 0) {
                str.append('.');
            }
            str.append(s);
        }
        return str.toString();
    }

    public static String translateJsPath(Path p) {
        StringBuilder str = new StringBuilder();
        int n = p.numSegments();
        for (int i = 0; i < n; ++i) {
            String s = p.head(i);
            if (s.equals("*")) {
                throw Error.get((String)"mongo-crud:TranslationError", (String)p.toString());
            }
            if (p.isIndex(i)) {
                str.append('[').append(s).append(']');
                continue;
            }
            if (i > 0) {
                str.append('.');
            }
            str.append(s);
        }
        return str.toString();
    }

    public DBObject[] toBson(List<? extends JsonDoc> docs) {
        DBObject[] ret = new DBObject[docs.size()];
        int i = 0;
        for (JsonDoc jsonDoc : docs) {
            ret[i++] = this.toBson(jsonDoc);
        }
        return ret;
    }

    public DBObject toBson(JsonDoc doc) {
        LOGGER.debug("toBson() enter");
        JsonNode node = doc.get(OBJECT_TYPE);
        if (node == null) {
            throw Error.get((String)ERR_NO_OBJECT_TYPE);
        }
        EntityMetadata md = this.mdResolver.getEntityMetadata(node.asText());
        if (md == null) {
            throw Error.get((String)ERR_INVALID_OBJECTTYPE, (String)node.asText());
        }
        BasicDBObject ret = this.toBson(doc, md);
        LOGGER.debug("toBson() return");
        return ret;
    }

    public JsonDoc toJson(DBObject object) {
        LOGGER.debug("toJson() enter");
        Object type = object.get(OBJECT_TYPE_STR);
        if (type == null) {
            throw Error.get((String)ERR_NO_OBJECT_TYPE);
        }
        EntityMetadata md = this.mdResolver.getEntityMetadata(type.toString());
        if (md == null) {
            throw Error.get((String)ERR_INVALID_OBJECTTYPE, (String)type.toString());
        }
        JsonDoc doc = this.toJson(object, md);
        LOGGER.debug("toJson() return");
        return doc;
    }

    public List<JsonDoc> toJson(List<DBObject> objects) {
        ArrayList<JsonDoc> list = new ArrayList<JsonDoc>(objects.size());
        for (DBObject object : objects) {
            list.add(this.toJson(object));
        }
        return list;
    }

    public void addInvisibleFields(DBObject oldDBObject, DBObject newObject, EntityMetadata md) {
        Merge merge = new Merge(md);
        merge.merge(oldDBObject, newObject);
    }

    public static Object getDBObject(DBObject start, Path p) {
        int n = p.numSegments();
        Object trc = start;
        for (int seg = 0; seg < n; ++seg) {
            String segment = p.head(seg);
            if (segment.equals("*")) {
                throw Error.get((String)"mongo-crud:TranslationError", (String)p.toString());
            }
            trc = Util.isNumber((String)segment) ? ((List)trc).get(Integer.valueOf(segment)) : trc.get(segment);
            if (trc != null) continue;
            throw Error.get((String)"mongo-crud:TranslationError", (String)p.toString());
        }
        return trc;
    }

    public DBObject translate(Sort sort) {
        DBObject ret;
        LOGGER.debug("translate {}", (Object)sort);
        Error.push((String)"translateSort");
        try {
            ret = sort instanceof CompositeSortKey ? this.translateCompositeSortKey((CompositeSortKey)sort) : this.translateSortKey((SortKey)sort);
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw Error.get((String)"mongo-crud:InvalidObject", (String)e.getMessage());
        }
        finally {
            Error.pop();
        }
        return ret;
    }

    public DBObject translate(EntityMetadata md, QueryExpression query) {
        LOGGER.debug("translate {}", (Object)query);
        Error.push((String)"translateQuery");
        FieldTreeNode mdRoot = md.getFieldTreeRoot();
        try {
            DBObject dBObject = this.translate(mdRoot, query);
            return dBObject;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw Error.get((String)"mongo-crud:InvalidObject", (String)e.getMessage());
        }
        finally {
            Error.pop();
        }
    }

    public DBObject translate(EntityMetadata md, UpdateExpression expr) throws CannotTranslateException {
        LOGGER.debug("translate {}", (Object)expr);
        Error.push((String)"translateUpdate");
        try {
            BasicDBObject ret = new BasicDBObject();
            this.translateUpdate(md.getFieldTreeRoot(), expr, ret);
            LOGGER.debug("translated={}", (Object)ret);
            BasicDBObject basicDBObject = ret;
            return basicDBObject;
        }
        catch (CannotTranslateException | Error e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw Error.get((String)"mongo-crud:InvalidObject", (String)e.getMessage());
        }
        finally {
            Error.pop();
        }
    }

    public static Set<Path> getRequiredFields(EntityMetadata md, Projection p, QueryExpression q, Sort s) {
        LOGGER.debug("getRequiredFields: p={}, q={}, s={}", new Object[]{p, q, s});
        HashSet<Path> fields = new HashSet<Path>();
        FieldCursor cursor = md.getFieldCursor();
        while (cursor.next()) {
            Path field = cursor.getCurrentPath();
            FieldTreeNode node = (FieldTreeNode)cursor.getCurrentNode();
            if (node instanceof ObjectField || node instanceof ArrayField && ((ArrayField)node).getElement() instanceof ObjectArrayElement) continue;
            if (p != null && p.isFieldRequiredToEvaluateProjection(field) || q != null && q.isRequired(field) || s != null && s.isRequired(field)) {
                LOGGER.debug("{}: required", (Object)field);
                fields.add(field);
                continue;
            }
            LOGGER.debug("{}: not required", (Object)field);
        }
        return fields;
    }

    public DBObject translateProjection(EntityMetadata md, Projection p, QueryExpression q, Sort s) {
        Set<Path> fields = Translator.getRequiredFields(md, p, q, s);
        LOGGER.debug("translateProjection, p={}, q={}, s={}, fields={}", new Object[]{p, q, s, fields});
        BasicDBObject ret = new BasicDBObject();
        Integer one = new Integer(1);
        for (Path f : fields) {
            ret.append(Translator.translatePath(f), (Object)1);
        }
        LOGGER.debug("Resulting projection:{}", (Object)ret);
        return ret;
    }

    private void translateUpdate(FieldTreeNode root, UpdateExpression expr, BasicDBObject dest) throws CannotTranslateException {
        if (expr instanceof ArrayUpdateExpression) {
            throw new CannotTranslateException(expr);
        }
        if (expr instanceof PrimitiveUpdateExpression) {
            this.translatePrimitiveUpdate(root, (PrimitiveUpdateExpression)expr, dest);
        } else if (expr instanceof UpdateExpressionList) {
            for (PartialUpdateExpression x : ((UpdateExpressionList)expr).getList()) {
                this.translateUpdate(root, (UpdateExpression)x, dest);
            }
        }
    }

    private void translatePrimitiveUpdate(FieldTreeNode root, PrimitiveUpdateExpression expr, BasicDBObject dest) throws CannotTranslateException {
        if (expr instanceof SetExpression) {
            this.translateSet(root, (SetExpression)expr, dest);
        } else if (expr instanceof UnsetExpression) {
            this.translateUnset(root, (UnsetExpression)expr, dest);
        } else {
            throw new CannotTranslateException((UpdateExpression)expr);
        }
    }

    private void translateSet(FieldTreeNode root, SetExpression expr, BasicDBObject dest) throws CannotTranslateException {
        String op;
        switch (expr.getOp()) {
            case _set: {
                op = "$set";
                break;
            }
            case _add: {
                op = "$inc";
                break;
            }
            default: {
                throw new CannotTranslateException((UpdateExpression)expr);
            }
        }
        BasicDBObject obj = (BasicDBObject)dest.get(op);
        if (obj == null) {
            obj = new BasicDBObject();
            dest.put(op, (Object)obj);
        }
        for (FieldAndRValue frv : expr.getFields()) {
            Path field = frv.getField();
            if (this.hasArray(root, field)) {
                throw new CannotTranslateException((UpdateExpression)expr);
            }
            RValueExpression rvalue = frv.getRValue();
            if (rvalue.getType() == RValueExpression.RValueType._value) {
                Value value = rvalue.getValue();
                FieldTreeNode ftn = root.resolve(field);
                if (ftn == null) {
                    throw new CannotTranslateException((UpdateExpression)expr);
                }
                if (!(ftn instanceof SimpleField)) {
                    throw new CannotTranslateException((UpdateExpression)expr);
                }
                Object valueObject = ftn.getType().cast(value.getValue());
                if (field.equals((Object)ID_PATH)) {
                    valueObject = Translator.createIdFrom(valueObject);
                }
                obj.put(Translator.translatePath(field), valueObject);
                continue;
            }
            throw new CannotTranslateException((UpdateExpression)expr);
        }
    }

    private void translateUnset(FieldTreeNode root, UnsetExpression expr, BasicDBObject dest) throws CannotTranslateException {
        BasicDBObject obj = (BasicDBObject)dest.get("$unset");
        if (obj == null) {
            obj = new BasicDBObject();
            dest.put("$unset", (Object)obj);
        }
        for (Path field : expr.getFields()) {
            if (this.hasArray(root, field)) {
                throw new CannotTranslateException((UpdateExpression)expr);
            }
            obj.put(Translator.translatePath(field), (Object)"");
        }
    }

    private boolean hasArray(FieldTreeNode root, Path field) throws CannotTranslateException {
        FieldTreeNode node = root.resolve(field);
        if (node == null) {
            throw new CannotTranslateException(field);
        }
        do {
            if (!(node instanceof ArrayField) && !(node instanceof ArrayElement)) continue;
            return true;
        } while ((node = node.getParent()) != null);
        return false;
    }

    private DBObject translateSortKey(SortKey sort) {
        return new BasicDBObject(Translator.translatePath(sort.getField()), (Object)(sort.isDesc() ? -1 : 1));
    }

    private DBObject translateCompositeSortKey(CompositeSortKey sort) {
        DBObject ret = null;
        for (SortKey key : sort.getKeys()) {
            if (ret == null) {
                ret = this.translateSortKey(key);
                continue;
            }
            ret.put(Translator.translatePath(key.getField()), (Object)(key.isDesc() ? -1 : 1));
        }
        return ret;
    }

    private DBObject translate(FieldTreeNode context, QueryExpression query) {
        DBObject ret = query instanceof ArrayContainsExpression ? this.translateArrayContains(context, (ArrayContainsExpression)query) : (query instanceof ArrayMatchExpression ? this.translateArrayElemMatch(context, (ArrayMatchExpression)query) : (query instanceof FieldComparisonExpression ? this.translateFieldComparison((FieldComparisonExpression)query) : (query instanceof NaryLogicalExpression ? this.translateNaryLogicalExpression(context, (NaryLogicalExpression)query) : (query instanceof NaryRelationalExpression ? this.translateNaryRelationalExpression(context, (NaryRelationalExpression)query) : (query instanceof RegexMatchExpression ? this.translateRegexMatchExpression((RegexMatchExpression)query) : (query instanceof UnaryLogicalExpression ? this.translateUnaryLogicalExpression(context, (UnaryLogicalExpression)query) : this.translateValueComparisonExpression(context, (ValueComparisonExpression)query)))))));
        return ret;
    }

    private FieldTreeNode resolve(FieldTreeNode context, Path field) {
        FieldTreeNode node = context.resolve(field);
        if (node == null) {
            throw Error.get((String)ERR_INVALID_FIELD, (String)field.toString());
        }
        return node;
    }

    private List<Object> translateValueList(Type t, List<Value> values) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("mongo-crud:EmptyValueList");
        }
        ArrayList<Object> ret = new ArrayList<Object>(values.size());
        for (Value v : values) {
            Object value;
            Object object = value = v == null ? null : v.getValue();
            if (value != null) {
                value = t.cast(value);
            }
            ret.add(value);
        }
        return ret;
    }

    private DBObject translateValueComparisonExpression(FieldTreeNode context, ValueComparisonExpression expr) {
        Type t = this.resolve(context, expr.getField()).getType();
        if (expr.getOp() == BinaryComparisonOperator._eq || expr.getOp() == BinaryComparisonOperator._neq ? !t.supportsEq() : !t.supportsOrdering()) {
            throw Error.get((String)ERR_INVALID_COMPARISON, (String)expr.toString());
        }
        Object valueObject = t.cast(expr.getRvalue().getValue());
        if (expr.getField().equals((Object)ID_PATH)) {
            valueObject = Translator.createIdFrom(valueObject);
        }
        if (expr.getOp() == BinaryComparisonOperator._eq) {
            return new BasicDBObject(Translator.translatePath(expr.getField()), valueObject);
        }
        return new BasicDBObject(Translator.translatePath(expr.getField()), (Object)new BasicDBObject(BINARY_COMPARISON_OPERATOR_MAP.get(expr.getOp()), valueObject));
    }

    private DBObject translateRegexMatchExpression(RegexMatchExpression expr) {
        String opStr;
        StringBuilder options = new StringBuilder();
        BasicDBObject regex = new BasicDBObject("$regex", (Object)expr.getRegex());
        if (expr.isCaseInsensitive()) {
            options.append('i');
        }
        if (expr.isMultiline()) {
            options.append('m');
        }
        if (expr.isExtended()) {
            options.append('x');
        }
        if (expr.isDotAll()) {
            options.append('s');
        }
        if ((opStr = options.toString()).length() > 0) {
            regex.append("$options", (Object)opStr);
        }
        return new BasicDBObject(Translator.translatePath(expr.getField()), (Object)regex);
    }

    private DBObject translateNaryRelationalExpression(FieldTreeNode context, NaryRelationalExpression expr) {
        Type t = this.resolve(context, expr.getField()).getType();
        if (t.supportsEq()) {
            List<Object> values = this.translateValueList(t, expr.getValues());
            return new BasicDBObject(Translator.translatePath(expr.getField()), (Object)new BasicDBObject(NARY_RELATIONAL_OPERATOR_MAP.get(expr.getOp()), values));
        }
        throw Error.get((String)ERR_INVALID_FIELD, (String)expr.toString());
    }

    private DBObject translateUnaryLogicalExpression(FieldTreeNode context, UnaryLogicalExpression expr) {
        return new BasicDBObject(UNARY_LOGICAL_OPERATOR_MAP.get(expr.getOp()), (Object)this.translate(context, expr.getQuery()));
    }

    private DBObject translateNaryLogicalExpression(FieldTreeNode context, NaryLogicalExpression expr) {
        List queries = expr.getQueries();
        ArrayList<DBObject> list = new ArrayList<DBObject>(queries.size());
        for (QueryExpression query : queries) {
            list.add(this.translate(context, query));
        }
        return new BasicDBObject(NARY_LOGICAL_OPERATOR_MAP.get(expr.getOp()), list);
    }

    private String writeJSForLoop(StringBuilder bld, Path p, String varPrefix) {
        StringBuilder arr = new StringBuilder();
        int n = p.numSegments();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            String seg = p.head(i);
            if ("*".equals(seg)) {
                bld.append(String.format("for(var %s%d=0;%s%d<this.%s.length;%s%d++) {", varPrefix, j, varPrefix, j, arr.toString(), varPrefix, j));
                arr.append('[').append(varPrefix).append(j).append(']');
                ++j;
                continue;
            }
            if (p.isIndex(i)) {
                arr.append('[').append(seg).append(']');
                continue;
            }
            if (i > 0) {
                arr.append('.');
            }
            arr.append(seg);
        }
        return arr.toString();
    }

    private DBObject translateFieldComparison(FieldComparisonExpression expr) {
        StringBuilder str = new StringBuilder(128);
        Path rField = expr.getRfield();
        Path lField = expr.getField();
        int rn = rField.nAnys();
        int ln = lField.nAnys();
        if (rn > 0 && ln > 0) {
            str.append("function() {");
            String rJSField = this.writeJSForLoop(str, rField, "r");
            String lJSField = this.writeJSForLoop(str, lField, "l");
            str.append("if(this.").append(lJSField).append(BINARY_COMPARISON_OPERATOR_JS_MAP.get(expr.getOp())).append(LITERAL_THIS_DOT).append(rJSField).append(") { return true; }");
            for (int i = 0; i < rn + ln; ++i) {
                str.append('}');
            }
            str.append("return false;}");
        } else if (rn > 0 || ln > 0) {
            str.append("function() {");
            String jsField = this.writeJSForLoop(str, rn > 0 ? rField : lField, "i");
            str.append("if(this.").append(ln > 0 ? jsField : Translator.translateJsPath(lField)).append(BINARY_COMPARISON_OPERATOR_JS_MAP.get(expr.getOp())).append(LITERAL_THIS_DOT).append(rn > 0 ? jsField : Translator.translateJsPath(rField)).append(") {return true;}");
            for (int i = 0; i < rn + ln; ++i) {
                str.append('}');
            }
            str.append("return false;}");
        } else {
            str.append(LITERAL_THIS_DOT).append(Translator.translateJsPath(expr.getField())).append(BINARY_COMPARISON_OPERATOR_JS_MAP.get(expr.getOp())).append(LITERAL_THIS_DOT).append(Translator.translateJsPath(expr.getRfield()));
        }
        return new BasicDBObject("$where", (Object)str.toString());
    }

    private DBObject translateArrayElemMatch(FieldTreeNode context, ArrayMatchExpression expr) {
        ArrayElement el;
        FieldTreeNode arrayNode = this.resolve(context, expr.getArray());
        if (arrayNode instanceof ArrayField && (el = ((ArrayField)arrayNode).getElement()) instanceof ObjectArrayElement) {
            return new BasicDBObject(Translator.translatePath(expr.getArray()), (Object)new BasicDBObject("$elemMatch", (Object)this.translate((FieldTreeNode)el, expr.getElemMatch())));
        }
        throw Error.get((String)ERR_INVALID_FIELD, (String)expr.toString());
    }

    private DBObject translateArrayContains(FieldTreeNode context, ArrayContainsExpression expr) {
        DBObject ret = null;
        FieldTreeNode arrayNode = this.resolve(context, expr.getArray());
        if (arrayNode instanceof ArrayField) {
            Type t = ((ArrayField)arrayNode).getElement().getType();
            switch (expr.getOp()) {
                case _all: {
                    ret = this.translateArrayContainsAll(t, expr.getArray(), expr.getValues());
                    break;
                }
                case _any: {
                    ret = this.translateArrayContainsAny(t, expr.getArray(), expr.getValues());
                    break;
                }
                case _none: {
                    ret = this.translateArrayContainsNone(t, expr.getArray(), expr.getValues());
                }
            }
        } else {
            throw Error.get((String)ERR_INVALID_FIELD, (String)expr.toString());
        }
        return ret;
    }

    private DBObject translateArrayContainsAll(Type t, Path array, List<Value> values) {
        return new BasicDBObject(Translator.translatePath(array), (Object)new BasicDBObject("$all", this.translateValueList(t, values)));
    }

    private DBObject translateArrayContainsAny(Type t, Path array, List<Value> values) {
        ArrayList<BasicDBObject> l = new ArrayList<BasicDBObject>(values.size());
        for (Value x : values) {
            l.add(new BasicDBObject(Translator.translatePath(array), x == null ? null : (x.getValue() == null ? null : t.cast(x.getValue()))));
        }
        return new BasicDBObject("$or", l);
    }

    private DBObject translateArrayContainsNone(Type t, Path array, List<Value> values) {
        return new BasicDBObject("$not", (Object)this.translateArrayContainsAny(t, array, values));
    }

    private JsonDoc toJson(DBObject object, EntityMetadata md) {
        FieldCursor cursor = md.getFieldCursor();
        if (cursor.firstChild()) {
            return new JsonDoc((JsonNode)this.objectToJson(object, md, cursor));
        }
        return null;
    }

    private ObjectNode objectToJson(DBObject object, EntityMetadata md, FieldCursor mdCursor) {
        ObjectNode node = this.factory.objectNode();
        do {
            Path p = mdCursor.getCurrentPath();
            FieldTreeNode field = (FieldTreeNode)mdCursor.getCurrentNode();
            String fieldName = field.getName();
            LOGGER.debug("{}", (Object)p);
            Object value = object.get(fieldName);
            if (value == null) continue;
            if (field instanceof SimpleField) {
                this.convertSimpleFieldToJson(node, field, value, fieldName);
                continue;
            }
            if (field instanceof ObjectField) {
                this.convertObjectFieldToJson(node, fieldName, md, mdCursor, value, p);
                continue;
            }
            if (field instanceof ArrayField && value instanceof List && mdCursor.firstChild()) {
                this.convertArrayFieldToJson(node, fieldName, md, mdCursor, value);
                continue;
            }
            if (!(field instanceof ReferenceField)) continue;
            this.convertReferenceFieldToJson();
        } while (mdCursor.nextSibling());
        return node;
    }

    private void convertSimpleFieldToJson(ObjectNode node, FieldTreeNode field, Object value, String fieldName) {
        JsonNode valueNode = ((SimpleField)field).getType().toJson(this.factory, value);
        if (valueNode != null) {
            node.set(fieldName, valueNode);
        }
    }

    private void convertObjectFieldToJson(ObjectNode node, String fieldName, EntityMetadata md, FieldCursor mdCursor, Object value, Path p) {
        if (value instanceof DBObject) {
            if (mdCursor.firstChild()) {
                ObjectNode valueNode = this.objectToJson((DBObject)value, md, mdCursor);
                if (valueNode != null) {
                    node.set(fieldName, (JsonNode)valueNode);
                }
                mdCursor.parent();
            }
        } else {
            LOGGER.error("Expected DBObject, found {} for {}", value.getClass(), (Object)p);
        }
    }

    private void convertArrayFieldToJson(ObjectNode node, String fieldName, EntityMetadata md, FieldCursor mdCursor, Object value) {
        ArrayNode valueNode = this.factory.arrayNode();
        node.set(fieldName, (JsonNode)valueNode);
        FieldTreeNode x = (FieldTreeNode)mdCursor.getCurrentNode();
        if (x instanceof ArrayElement) {
            for (Object item : (List)value) {
                valueNode.add(this.arrayElementToJson(item, (ArrayElement)x, md, mdCursor));
            }
        }
        mdCursor.parent();
    }

    private void convertReferenceFieldToJson() {
        LOGGER.debug("Converting reference field: ");
    }

    private JsonNode arrayElementToJson(Object value, ArrayElement el, EntityMetadata md, FieldCursor mdCursor) {
        JsonNode ret = null;
        if (el instanceof SimpleArrayElement) {
            if (value != null) {
                ret = ((SimpleArrayElement)el).getType().toJson(this.factory, value);
            }
        } else if (value != null) {
            if (value instanceof DBObject) {
                if (mdCursor.firstChild()) {
                    ret = this.objectToJson((DBObject)value, md, mdCursor);
                    mdCursor.parent();
                }
            } else {
                LOGGER.error("Expected DBObject, got {}", (Object)value.getClass().getName());
            }
        }
        return ret;
    }

    private BasicDBObject toBson(JsonDoc doc, EntityMetadata md) {
        LOGGER.debug("Entity: {}", (Object)md.getName());
        BasicDBObject ret = null;
        JsonNodeCursor cursor = doc.cursor();
        if (cursor.firstChild()) {
            ret = this.objectToBson(cursor, md);
        }
        return ret;
    }

    private Object toValue(Type t, JsonNode node) {
        if (node == null || node instanceof NullNode) {
            return null;
        }
        return t.fromJson(node);
    }

    private void toBson(BasicDBObject dest, SimpleField fieldMd, Path path, JsonNode node) {
        Object value = this.toValue(fieldMd.getType(), node);
        if (value != null) {
            LOGGER.debug("{} = {}", (Object)path, value);
            if (path.equals((Object)ID_PATH)) {
                value = Translator.createIdFrom(value);
            }
            if (value instanceof BigDecimal || value instanceof BigInteger) {
                value = value.toString();
            }
            dest.append(path.tail(0), value);
        }
    }

    private BasicDBObject objectToBson(JsonNodeCursor cursor, EntityMetadata md) {
        BasicDBObject ret = new BasicDBObject();
        do {
            Path path = cursor.getCurrentPath();
            JsonNode node = (JsonNode)cursor.getCurrentNode();
            LOGGER.debug("field: {}", (Object)path);
            FieldTreeNode fieldMdNode = md.resolve(path);
            if (fieldMdNode == null) {
                throw Error.get((String)ERR_INVALID_FIELD, (String)path.toString());
            }
            if (fieldMdNode instanceof SimpleField) {
                this.toBson(ret, (SimpleField)fieldMdNode, path, node);
                continue;
            }
            if (fieldMdNode instanceof ObjectField) {
                this.convertObjectFieldToBson(node, cursor, ret, path, md);
                continue;
            }
            if (fieldMdNode instanceof ArrayField) {
                this.convertArrayFieldToBson(node, cursor, ret, fieldMdNode, path, md);
                continue;
            }
            if (!(fieldMdNode instanceof ReferenceField)) continue;
            this.convertReferenceFieldToBson();
        } while (cursor.nextSibling());
        return ret;
    }

    private void convertObjectFieldToBson(JsonNode node, JsonNodeCursor cursor, BasicDBObject ret, Path path, EntityMetadata md) {
        if (node != null) {
            if (node instanceof ObjectNode) {
                if (cursor.firstChild()) {
                    ret.append(path.tail(0), (Object)this.objectToBson(cursor, md));
                    cursor.parent();
                }
            } else {
                throw Error.get((String)ERR_INVALID_FIELD, (String)path.toString());
            }
        }
    }

    private void convertArrayFieldToBson(JsonNode node, JsonNodeCursor cursor, BasicDBObject ret, FieldTreeNode fieldMdNode, Path path, EntityMetadata md) {
        if (node != null) {
            if (node instanceof ArrayNode) {
                if (cursor.firstChild()) {
                    ret.append(path.tail(0), (Object)this.arrayToBson(cursor, ((ArrayField)fieldMdNode).getElement(), md));
                    cursor.parent();
                }
            } else {
                throw Error.get((String)ERR_INVALID_FIELD, (String)path.toString());
            }
        }
    }

    private void convertReferenceFieldToBson() {
        throw new UnsupportedOperationException();
    }

    private List arrayToBson(JsonNodeCursor cursor, ArrayElement el, EntityMetadata md) {
        ArrayList<Object> l = new ArrayList<Object>();
        if (el instanceof SimpleArrayElement) {
            Type t = el.getType();
            do {
                Object value = this.toValue(t, (JsonNode)cursor.getCurrentNode());
                l.add(value);
            } while (cursor.nextSibling());
        } else {
            do {
                JsonNode node;
                if ((node = (JsonNode)cursor.getCurrentNode()) == null || node instanceof NullNode) {
                    l.add(null);
                    continue;
                }
                if (cursor.firstChild()) {
                    l.add(this.objectToBson(cursor, md));
                    cursor.parent();
                    continue;
                }
                l.add(null);
            } while (cursor.nextSibling());
        }
        return l;
    }

    public static Object createIdFrom(Object source) {
        if (source == null) {
            return null;
        }
        if (ObjectId.isValid((String)source.toString())) {
            return new ObjectId(source.toString());
        }
        return source.toString();
    }

    static {
        BINARY_COMPARISON_OPERATOR_JS_MAP.put(BinaryComparisonOperator._eq, "==");
        BINARY_COMPARISON_OPERATOR_JS_MAP.put(BinaryComparisonOperator._neq, "!=");
        BINARY_COMPARISON_OPERATOR_JS_MAP.put(BinaryComparisonOperator._lt, "<");
        BINARY_COMPARISON_OPERATOR_JS_MAP.put(BinaryComparisonOperator._gt, ">");
        BINARY_COMPARISON_OPERATOR_JS_MAP.put(BinaryComparisonOperator._lte, "<=");
        BINARY_COMPARISON_OPERATOR_JS_MAP.put(BinaryComparisonOperator._gte, ">=");
        BINARY_COMPARISON_OPERATOR_MAP = new HashMap<BinaryComparisonOperator, String>();
        BINARY_COMPARISON_OPERATOR_MAP.put(BinaryComparisonOperator._eq, "$eq");
        BINARY_COMPARISON_OPERATOR_MAP.put(BinaryComparisonOperator._neq, "$ne");
        BINARY_COMPARISON_OPERATOR_MAP.put(BinaryComparisonOperator._lt, "$lt");
        BINARY_COMPARISON_OPERATOR_MAP.put(BinaryComparisonOperator._gt, "$gt");
        BINARY_COMPARISON_OPERATOR_MAP.put(BinaryComparisonOperator._lte, "$lte");
        BINARY_COMPARISON_OPERATOR_MAP.put(BinaryComparisonOperator._gte, "$gte");
        NARY_LOGICAL_OPERATOR_MAP = new HashMap<NaryLogicalOperator, String>();
        NARY_LOGICAL_OPERATOR_MAP.put(NaryLogicalOperator._and, "$and");
        NARY_LOGICAL_OPERATOR_MAP.put(NaryLogicalOperator._or, "$or");
        UNARY_LOGICAL_OPERATOR_MAP = new HashMap<UnaryLogicalOperator, String>();
        UNARY_LOGICAL_OPERATOR_MAP.put(UnaryLogicalOperator._not, "$not");
        NARY_RELATIONAL_OPERATOR_MAP = new HashMap<NaryRelationalOperator, String>();
        NARY_RELATIONAL_OPERATOR_MAP.put(NaryRelationalOperator._in, "$in");
        NARY_RELATIONAL_OPERATOR_MAP.put(NaryRelationalOperator._not_in, "$nin");
    }
}

