/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.redhat.lightblue.common.mongo.DBResolver;
import com.redhat.lightblue.common.mongo.MongoDataStore;
import com.redhat.lightblue.crud.CRUDController;
import com.redhat.lightblue.crud.CRUDDeleteResponse;
import com.redhat.lightblue.crud.CRUDFindResponse;
import com.redhat.lightblue.crud.CRUDInsertionResponse;
import com.redhat.lightblue.crud.CRUDOperationContext;
import com.redhat.lightblue.crud.CRUDSaveResponse;
import com.redhat.lightblue.crud.CRUDUpdateResponse;
import com.redhat.lightblue.crud.ConstraintValidator;
import com.redhat.lightblue.crud.DocCtx;
import com.redhat.lightblue.crud.MetadataResolver;
import com.redhat.lightblue.crud.mongo.BasicDocFinder;
import com.redhat.lightblue.crud.mongo.BasicDocSaver;
import com.redhat.lightblue.crud.mongo.DocSaver;
import com.redhat.lightblue.crud.mongo.IterateAndUpdate;
import com.redhat.lightblue.crud.mongo.IterateDeleter;
import com.redhat.lightblue.crud.mongo.Translator;
import com.redhat.lightblue.eval.FieldAccessRoleEvaluator;
import com.redhat.lightblue.eval.Projector;
import com.redhat.lightblue.eval.Updater;
import com.redhat.lightblue.interceptor.InterceptPoint;
import com.redhat.lightblue.metadata.EntityInfo;
import com.redhat.lightblue.metadata.EntityMetadata;
import com.redhat.lightblue.metadata.EntitySchema;
import com.redhat.lightblue.metadata.Field;
import com.redhat.lightblue.metadata.FieldConstraint;
import com.redhat.lightblue.metadata.FieldTreeNode;
import com.redhat.lightblue.metadata.Index;
import com.redhat.lightblue.metadata.Indexes;
import com.redhat.lightblue.metadata.Metadata;
import com.redhat.lightblue.metadata.MetadataListener;
import com.redhat.lightblue.metadata.SimpleField;
import com.redhat.lightblue.metadata.constraints.IdentityConstraint;
import com.redhat.lightblue.metadata.types.StringType;
import com.redhat.lightblue.query.FieldProjection;
import com.redhat.lightblue.query.Projection;
import com.redhat.lightblue.query.ProjectionList;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.query.Sort;
import com.redhat.lightblue.query.SortKey;
import com.redhat.lightblue.query.UpdateExpression;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonDoc;
import com.redhat.lightblue.util.MutablePath;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoCRUDController
implements CRUDController,
MetadataListener {
    public static final String ID_STR = "_id";
    public static final String PROP_SAVER = "MongoCRUDController:saver";
    public static final String PROP_UPDATER = "MongoCRUDController:updater";
    public static final String PROP_DELETER = "MongoCRUDController:deleter";
    public static final String PROP_FINDER = "MongoCRUDController:finder";
    public static final String OP_INSERT = "insert";
    public static final String OP_SAVE = "save";
    public static final String OP_FIND = "find";
    public static final String OP_UPDATE = "update";
    public static final String OP_DELETE = "delete";
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoCRUDController.class);
    private static final Projection ID_PROJECTION = new FieldProjection(new Path("_id"), true, false);
    private final DBResolver dbResolver;

    public MongoCRUDController(DBResolver dbResolver) {
        this.dbResolver = dbResolver;
    }

    public CRUDInsertionResponse insert(CRUDOperationContext ctx, Projection projection) {
        LOGGER.debug("insert() start");
        CRUDInsertionResponse response = new CRUDInsertionResponse();
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_INSERT, ctx);
        int n = this.saveOrInsert(ctx, false, projection, OP_INSERT);
        response.setNumInserted(n);
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_INSERT, ctx);
        return response;
    }

    public CRUDSaveResponse save(CRUDOperationContext ctx, boolean upsert, Projection projection) {
        LOGGER.debug("save() start");
        CRUDSaveResponse response = new CRUDSaveResponse();
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_SAVE, ctx);
        int n = this.saveOrInsert(ctx, upsert, projection, OP_SAVE);
        response.setNumSaved(n);
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_SAVE, ctx);
        return response;
    }

    private int saveOrInsert(CRUDOperationContext ctx, boolean upsert, Projection projection, String operation) {
        List documents;
        int ret;
        block13: {
            ret = 0;
            documents = ctx.getDocumentsWithoutErrors();
            if (documents == null || documents.isEmpty()) {
                return ret;
            }
            for (DocCtx doc : documents) {
                doc.setOriginalDocument((JsonDoc)doc);
            }
            LOGGER.debug("saveOrInsert() start");
            Error.push((String)operation);
            Translator translator = new Translator((MetadataResolver)ctx, ctx.getFactory().getNodeFactory());
            try {
                FieldAccessRoleEvaluator roleEval = new FieldAccessRoleEvaluator(ctx.getEntityMetadata(ctx.getEntityName()), ctx.getCallerRoles());
                LOGGER.debug("saveOrInsert: Translating docs");
                EntityMetadata md = ctx.getEntityMetadata(ctx.getEntityName());
                DBObject[] dbObjects = translator.toBson(documents);
                if (dbObjects == null) break block13;
                LOGGER.debug("saveOrInsert: {} docs translated to bson", (Object)dbObjects.length);
                MongoDataStore store = (MongoDataStore)md.getDataStore();
                DB db = this.dbResolver.get(store);
                DBCollection collection = db.getCollection(store.getCollectionName());
                Projection combinedProjection = Projection.add((Projection)projection, (Projection)roleEval.getExcludedFields(FieldAccessRoleEvaluator.Operation.find));
                Projector projector = combinedProjection != null ? Projector.getInstance((Projection)combinedProjection, (EntityMetadata)md) : null;
                BasicDocSaver saver = new BasicDocSaver(translator, roleEval);
                ctx.setProperty(PROP_SAVER, (Object)saver);
                for (int docIndex = 0; docIndex < dbObjects.length; ++docIndex) {
                    DBObject dbObject = dbObjects[docIndex];
                    DocCtx inputDoc = (DocCtx)documents.get(docIndex);
                    try {
                        saver.saveDoc(ctx, operation.equals(OP_INSERT) ? DocSaver.Op.insert : DocSaver.Op.save, upsert, collection, md, dbObject, inputDoc);
                        ctx.getHookManager().queueHooks(ctx);
                    }
                    catch (Exception e) {
                        LOGGER.error("saveOrInsert failed: {}", (Throwable)e);
                        inputDoc.addError(Error.get((String)operation, (String)"mongo-crud:SaveError", (Throwable)e));
                    }
                    if (projector != null) {
                        JsonDoc jsonDoc = translator.toJson(dbObject);
                        LOGGER.debug("Translated doc: {}", (Object)jsonDoc);
                        inputDoc.setOutputDocument(projector.project(jsonDoc, ctx.getFactory().getNodeFactory()));
                    } else {
                        inputDoc.setOutputDocument(new JsonDoc((JsonNode)new ObjectNode(ctx.getFactory().getNodeFactory())));
                    }
                    LOGGER.debug("projected doc: {}", (Object)inputDoc.getOutputDocument());
                    if (inputDoc.hasErrors()) continue;
                    ++ret;
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Error during insert: {}", (Throwable)e);
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw Error.get((String)"crud", (String)e.getMessage());
            }
            finally {
                Error.pop();
            }
        }
        LOGGER.debug("saveOrInsert() end: {} docs requested, {} saved", (Object)documents.size(), (Object)ret);
        return ret;
    }

    public CRUDUpdateResponse update(CRUDOperationContext ctx, QueryExpression query, UpdateExpression update, Projection projection) {
        if (query == null) {
            throw new IllegalArgumentException("mongo-crud:NullQuery");
        }
        LOGGER.debug("update start: q:{} u:{} p:{}", new Object[]{query, update, projection});
        Error.push((String)OP_UPDATE);
        CRUDUpdateResponse response = new CRUDUpdateResponse();
        Translator translator = new Translator((MetadataResolver)ctx, ctx.getFactory().getNodeFactory());
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_UPDATE, ctx);
        try {
            EntityMetadata md = ctx.getEntityMetadata(ctx.getEntityName());
            if (md.getAccess().getUpdate().hasAccess((Collection)ctx.getCallerRoles())) {
                Projector projector;
                ConstraintValidator validator = ctx.getFactory().getConstraintValidator(md);
                LOGGER.debug("Translating query {}", (Object)query);
                DBObject mongoQuery = translator.translate(md, query);
                LOGGER.debug("Translated query {}", (Object)mongoQuery);
                FieldAccessRoleEvaluator roleEval = new FieldAccessRoleEvaluator(md, ctx.getCallerRoles());
                if (projection != null) {
                    Projection x = Projection.add((Projection)projection, (Projection)roleEval.getExcludedFields(FieldAccessRoleEvaluator.Operation.find));
                    LOGGER.debug("Projection={}", (Object)x);
                    projector = Projector.getInstance((Projection)x, (EntityMetadata)md);
                } else {
                    projector = null;
                }
                DB db = this.dbResolver.get((MongoDataStore)md.getDataStore());
                DBCollection coll = db.getCollection(((MongoDataStore)md.getDataStore()).getCollectionName());
                Projector errorProjector = projector == null ? Projector.getInstance((Projection)ID_PROJECTION, (EntityMetadata)md) : projector;
                Updater updater = Updater.getInstance((JsonNodeFactory)ctx.getFactory().getNodeFactory(), (EntityMetadata)md, (UpdateExpression)update);
                IterateAndUpdate docUpdater = new IterateAndUpdate(ctx.getFactory().getNodeFactory(), validator, roleEval, translator, updater, projector, errorProjector);
                ctx.setProperty(PROP_UPDATER, (Object)docUpdater);
                docUpdater.update(ctx, coll, md, response, mongoQuery);
                ctx.getHookManager().queueHooks(ctx);
            } else {
                ctx.addError(Error.get((String)"mongo-crud:NoAccess", (String)("update:" + ctx.getEntityName())));
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw Error.get((String)"crud", (String)e.getMessage());
        }
        finally {
            Error.pop();
        }
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_UPDATE, ctx);
        LOGGER.debug("update end: updated: {}, failed: {}", (Object)response.getNumUpdated(), (Object)response.getNumFailed());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRUDDeleteResponse delete(CRUDOperationContext ctx, QueryExpression query) {
        if (query == null) {
            throw new IllegalArgumentException("mongo-crud:NullQuery");
        }
        LOGGER.debug("delete start: q:{}", (Object)query);
        Error.push((String)OP_DELETE);
        CRUDDeleteResponse response = new CRUDDeleteResponse();
        Translator translator = new Translator((MetadataResolver)ctx, ctx.getFactory().getNodeFactory());
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_DELETE, ctx);
        try {
            EntityMetadata md = ctx.getEntityMetadata(ctx.getEntityName());
            if (md.getAccess().getDelete().hasAccess((Collection)ctx.getCallerRoles())) {
                LOGGER.debug("Translating query {}", (Object)query);
                DBObject mongoQuery = translator.translate(md, query);
                LOGGER.debug("Translated query {}", (Object)mongoQuery);
                DB db = this.dbResolver.get((MongoDataStore)md.getDataStore());
                DBCollection coll = db.getCollection(((MongoDataStore)md.getDataStore()).getCollectionName());
                IterateDeleter deleter = new IterateDeleter(translator);
                ctx.setProperty(PROP_DELETER, (Object)deleter);
                deleter.delete(ctx, coll, mongoQuery, response);
                ctx.getHookManager().queueHooks(ctx);
            } else {
                ctx.addError(Error.get((String)"mongo-crud:NoAccess", (String)("delete:" + ctx.getEntityName())));
            }
        }
        catch (Error e) {
            ctx.addError(e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ctx.addError(Error.get((String)e.toString()));
        }
        finally {
            Error.pop();
        }
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_DELETE, ctx);
        LOGGER.debug("delete end: deleted: {}}", (Object)response.getNumDeleted());
        return response;
    }

    public CRUDFindResponse find(CRUDOperationContext ctx, QueryExpression query, Projection projection, Sort sort, Long from, Long to) {
        if (query == null) {
            throw new IllegalArgumentException("mongo-crud:NullQuery");
        }
        if (projection == null) {
            throw new IllegalArgumentException("mongo-crud:NullProjection");
        }
        LOGGER.debug("find start: q:{} p:{} sort:{} from:{} to:{}", new Object[]{query, projection, sort, from, to});
        Error.push((String)OP_FIND);
        CRUDFindResponse response = new CRUDFindResponse();
        Translator translator = new Translator((MetadataResolver)ctx, ctx.getFactory().getNodeFactory());
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_FIND, ctx);
        try {
            EntityMetadata md = ctx.getEntityMetadata(ctx.getEntityName());
            if (md.getAccess().getFind().hasAccess((Collection)ctx.getCallerRoles())) {
                DBObject mongoSort;
                FieldAccessRoleEvaluator roleEval = new FieldAccessRoleEvaluator(md, ctx.getCallerRoles());
                LOGGER.debug("Translating query {}", (Object)query);
                DBObject mongoQuery = translator.translate(md, query);
                LOGGER.debug("Translated query {}", (Object)mongoQuery);
                if (sort != null) {
                    LOGGER.debug("Translating sort {}", (Object)sort);
                    mongoSort = translator.translate(sort);
                    LOGGER.debug("Translated sort {}", (Object)mongoSort);
                } else {
                    mongoSort = null;
                }
                DBObject mongoProjection = translator.translateProjection(md, this.getProjectionFields(projection, md), query, sort);
                LOGGER.debug("Translated projection {}", (Object)mongoProjection);
                DB db = this.dbResolver.get((MongoDataStore)md.getDataStore());
                DBCollection coll = db.getCollection(((MongoDataStore)md.getDataStore()).getCollectionName());
                LOGGER.debug("Retrieve db collection:" + coll);
                BasicDocFinder finder = new BasicDocFinder(translator);
                ctx.setProperty(PROP_FINDER, (Object)finder);
                response.setSize(finder.find(ctx, coll, mongoQuery, mongoProjection, mongoSort, from, to));
                Projector projector = Projector.getInstance((Projection)Projection.add((Projection)projection, (Projection)roleEval.getExcludedFields(FieldAccessRoleEvaluator.Operation.find)), (EntityMetadata)md);
                for (DocCtx document : ctx.getDocuments()) {
                    document.setOutputDocument(projector.project((JsonDoc)document, ctx.getFactory().getNodeFactory()));
                }
                ctx.getHookManager().queueHooks(ctx);
            } else {
                ctx.addError(Error.get((String)"mongo-crud:NoAccess", (String)("find:" + ctx.getEntityName())));
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw Error.get((String)"crud", (String)e.getMessage());
        }
        finally {
            Error.pop();
        }
        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_FIND, ctx);
        LOGGER.debug("find end: query: {} results: {}", (Object)response.getSize());
        return response;
    }

    public void updatePredefinedFields(CRUDOperationContext ctx, JsonDoc doc) {
        JsonNode idNode = doc.get(Translator.ID_PATH);
        if (idNode == null || idNode instanceof NullNode) {
            doc.modify(Translator.ID_PATH, (JsonNode)ctx.getFactory().getNodeFactory().textNode(ObjectId.get().toString()), false);
        }
    }

    public MetadataListener getMetadataListener() {
        return this;
    }

    public void afterUpdateEntityInfo(Metadata md, EntityInfo ei, boolean newEntity) {
        this.createUpdateEntityInfoIndexes(ei);
    }

    public void beforeUpdateEntityInfo(Metadata md, EntityInfo ei, boolean newEntity) {
        this.validateIndexFields(ei);
        this.ensureIdIndex(ei);
    }

    public void afterCreateNewSchema(Metadata md, EntityMetadata emd) {
    }

    public void beforeCreateNewSchema(Metadata md, EntityMetadata emd) {
        this.validateIndexFields(emd.getEntityInfo());
        this.ensureIdField(emd);
    }

    private Path translateIndexPath(Path p) {
        MutablePath newPath = new MutablePath();
        int n = p.numSegments();
        for (int i = 0; i < n; ++i) {
            String x = p.head(i);
            if (x.equals("*")) continue;
            if (p.isIndex(i)) {
                throw Error.get((String)"mongo-crud:InvalidIndexField", (String)p.toString());
            }
            newPath.push(x);
        }
        return newPath.immutableCopy();
    }

    private void validateIndexFields(EntityInfo ei) {
        for (Index ix : ei.getIndexes().getIndexes()) {
            List fields = ix.getFields();
            ArrayList<SortKey> newFields = null;
            boolean copied = false;
            int i = 0;
            for (SortKey key : fields) {
                Path newPath;
                Path p = key.getField();
                if (p.equals((Object)(newPath = this.translateIndexPath(p)))) continue;
                SortKey newKey = new SortKey(newPath, key.isDesc());
                if (!copied) {
                    newFields = new ArrayList<SortKey>();
                    newFields.addAll(fields);
                    copied = true;
                }
                newFields.set(i, newKey);
            }
            if (!copied) continue;
            ix.setFields(newFields);
            LOGGER.debug("Index rewritten as {}", (Object)ix);
        }
    }

    private void ensureIdField(EntityMetadata md) {
        this.ensureIdField(md.getEntitySchema());
    }

    private void ensureIdField(EntitySchema schema) {
        SimpleField idField;
        FieldTreeNode field;
        LOGGER.debug("ensureIdField: begin");
        try {
            field = schema.resolve(Translator.ID_PATH);
        }
        catch (Error e) {
            field = null;
        }
        if (field == null) {
            LOGGER.debug("Adding _id field");
            idField = new SimpleField(ID_STR, StringType.TYPE);
            schema.getFields().addNew((Field)idField);
        } else if (field instanceof SimpleField) {
            idField = (SimpleField)field;
        } else {
            throw Error.get((String)"mongo-metadata:Invalid_id_defn");
        }
        List constraints = idField.getConstraints();
        boolean identityConstraintFound = false;
        for (FieldConstraint x : constraints) {
            if (!(x instanceof IdentityConstraint)) continue;
            identityConstraintFound = true;
            break;
        }
        if (!identityConstraintFound) {
            LOGGER.debug("Adding identity constraint to _id field");
            constraints.add(new IdentityConstraint());
            idField.setConstraints((Collection)constraints);
        }
        LOGGER.debug("ensureIdField: end");
    }

    private void ensureIdIndex(EntityInfo ei) {
        LOGGER.debug("ensureIdIndex: begin");
        Indexes indexes = ei.getIndexes();
        boolean found = false;
        for (Index ix : indexes.getIndexes()) {
            List fields = ix.getFields();
            if (fields.size() != 1 || !((SortKey)fields.get(0)).getField().equals((Object)Translator.ID_PATH) || !ix.isUnique()) continue;
            found = true;
            break;
        }
        if (!found) {
            LOGGER.debug("Adding _id index");
            Index idIndex = new Index();
            idIndex.setUnique(true);
            ArrayList<SortKey> fields = new ArrayList<SortKey>();
            fields.add(new SortKey(Translator.ID_PATH, false));
            idIndex.setFields(fields);
            List ix = indexes.getIndexes();
            ix.add(idIndex);
            indexes.setIndexes((Collection)ix);
        } else {
            LOGGER.debug("_id index exists");
        }
        LOGGER.debug("ensureIdIndex: end");
    }

    private void createUpdateEntityInfoIndexes(EntityInfo ei) {
        LOGGER.debug("createUpdateEntityInfoIndexes: begin");
        Indexes indexes = ei.getIndexes();
        MongoDataStore ds = (MongoDataStore)ei.getDataStore();
        DB entityDB = this.dbResolver.get(ds);
        DBCollection entityCollection = entityDB.getCollection(ds.getCollectionName());
        Error.push((String)"createUpdateIndex");
        try {
            List existingIndexes = entityCollection.getIndexInfo();
            LOGGER.debug("Existing indexes: {}", (Object)existingIndexes);
            for (Index index : indexes.getIndexes()) {
                boolean createIx;
                boolean bl = createIx = !this.isIdIndex(index);
                if (createIx) {
                    LOGGER.debug("Processing index {}", (Object)index);
                    for (DBObject existingIndex : existingIndexes) {
                        if (!this.indexFieldsMatch(index, existingIndex) || !this.indexOptionsMatch(index, existingIndex)) continue;
                        LOGGER.debug("Same index exists, not creating");
                        createIx = false;
                        break;
                    }
                }
                if (createIx) {
                    for (DBObject existingIndex : existingIndexes) {
                        if (!this.indexFieldsMatch(index, existingIndex) || this.indexOptionsMatch(index, existingIndex)) continue;
                        LOGGER.debug("Same index exists with different options, dropping index:{}", (Object)existingIndex);
                        entityCollection.dropIndex(existingIndex.get("name").toString());
                    }
                }
                if (!createIx) continue;
                BasicDBObject newIndex = new BasicDBObject();
                for (SortKey p : index.getFields()) {
                    newIndex.put(p.getField().toString(), (Object)(p.isDesc() ? -1 : 1));
                }
                BasicDBObject options = new BasicDBObject("unique", (Object)index.isUnique());
                if (index.getName() != null && index.getName().trim().length() > 0) {
                    options.append("name", (Object)index.getName().trim());
                }
                options.append("background", (Object)true);
                LOGGER.debug("Creating index {} with options {}", (Object)newIndex, (Object)options);
                entityCollection.createIndex((DBObject)newIndex, (DBObject)options);
            }
        }
        catch (MongoException me) {
            LOGGER.error("createUpdateEntityInfoIndexes: {}", (Object)ei);
            throw Error.get((String)"mongo-crud:EntityIndexNotCreated", (String)me.getMessage());
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw Error.get((String)"metadata:IllFormedMetadata", (String)e.getMessage());
        }
        finally {
            Error.pop();
        }
        LOGGER.debug("createUpdateEntityInfoIndexes: end");
    }

    private boolean isIdIndex(Index index) {
        List fields = index.getFields();
        return fields.size() == 1 && ((SortKey)fields.get(0)).getField().equals((Object)Translator.ID_PATH);
    }

    private boolean compareSortKeys(SortKey sortKey, String fieldName, Object dir) {
        if (sortKey.getField().toString().equals(fieldName)) {
            int direction = ((Number)dir).intValue();
            return sortKey.isDesc() == direction < 0;
        }
        return false;
    }

    private boolean indexFieldsMatch(Index index, DBObject existingIndex) {
        BasicDBObject keys = (BasicDBObject)existingIndex.get("key");
        if (keys != null) {
            List fields = index.getFields();
            if (keys.size() == fields.size()) {
                Iterator sortKeyItr = fields.iterator();
                for (Map.Entry entry : keys.entrySet()) {
                    SortKey sortKey = (SortKey)sortKeyItr.next();
                    if (this.compareSortKeys(sortKey, (String)entry.getKey(), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean indexOptionsMatch(Index index, DBObject existingIndex) {
        Boolean unique = (Boolean)existingIndex.get("unique");
        return unique != null ? unique != false && index.isUnique() || unique == false && !index.isUnique() : !index.isUnique();
    }

    private Projection getProjectionFields(Projection requestedProjection, EntityMetadata md) {
        Field[] identityFields = md.getEntitySchema().getIdentityFields();
        ArrayList<Object> projectFields = new ArrayList<Object>(identityFields == null ? 1 : identityFields.length + 1);
        if (requestedProjection instanceof ProjectionList) {
            projectFields.addAll(((ProjectionList)requestedProjection).getItems());
        } else if (requestedProjection != null) {
            projectFields.add(requestedProjection);
        }
        for (Field x : identityFields) {
            projectFields.add(new FieldProjection(x.getFullPath(), true, false));
        }
        projectFields.add(new FieldProjection(Translator.OBJECT_TYPE, true, false));
        return new ProjectionList(projectFields);
    }
}

