/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.mongodb.DBObject;
import com.redhat.lightblue.metadata.EntityMetadata;
import com.redhat.lightblue.metadata.FieldConstraint;
import com.redhat.lightblue.metadata.FieldCursor;
import com.redhat.lightblue.metadata.FieldTreeNode;
import com.redhat.lightblue.metadata.ObjectField;
import com.redhat.lightblue.metadata.SimpleField;
import com.redhat.lightblue.metadata.constraints.ArrayElementIdConstraint;
import com.redhat.lightblue.metadata.types.UIDType;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.MutablePath;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Merge {
    private static final Logger LOGGER = LoggerFactory.getLogger(Merge.class);
    private final EntityMetadata md;
    private final List<IField> invisibleFields = new ArrayList<IField>();
    private final Map<Path, List<PathAndField>> arrayIdentifiers = new HashMap<Path, List<PathAndField>>();

    public Merge(EntityMetadata md) {
        this.md = md;
    }

    public void reset() {
        this.invisibleFields.clear();
        this.arrayIdentifiers.clear();
    }

    public void merge(DBObject oldCopy, DBObject newCopy) {
        this.reset();
        this.findInvisibleFields(oldCopy);
        if (!this.invisibleFields.isEmpty()) {
            this.mergeIn(oldCopy, newCopy);
        }
    }

    public List<IField> getInvisibleFields() {
        return (List)((ArrayList)this.invisibleFields).clone();
    }

    private void mergeIn(DBObject oldCopy, DBObject newCopy) {
        for (IField ifield : this.invisibleFields) {
            Path p = ifield.getPath();
            DBObject parent = this.findMergeParent(oldCopy, newCopy, p);
            if (parent == null) {
                throw Error.get((String)"mongo-crud:SaveClobblersHiddenFields", (String)p.toString());
            }
            parent.put(p.tail(0), ifield.getValue());
        }
    }

    private DBObject findMergeParent(DBObject oldCopy, DBObject newCopy, Path field) {
        LOGGER.debug("Attempting to merge in {}", (Object)field);
        int n = field.numSegments();
        DBObject ret = null;
        if (n > 1) {
            int parentLevel = n - 1;
            Object parent = newCopy;
            Object oldParent = oldCopy;
            boolean fail = false;
            for (int segment = 0; segment < parentLevel; ++segment) {
                if (field.isIndex(segment)) {
                    Path elemField = field.prefix(segment + 1);
                    Path arrayField = elemField.prefix(segment);
                    List<PathAndField> identifiers = this.arrayIdentifiers.get(arrayField);
                    if (identifiers == null && !(identifiers = this.getArrayIdentifiers(elemField)).isEmpty()) {
                        this.arrayIdentifiers.put(arrayField, identifiers);
                    }
                    LOGGER.debug("Identifiers for array field {}: {}", (Object)field, identifiers);
                    if (identifiers.isEmpty()) {
                        fail = true;
                        break;
                    }
                    List<IField> identifyingContent = this.getIdentifyingContent(identifiers, (DBObject)((List)oldParent).get(field.getIndex(segment)));
                    LOGGER.debug("Identifying content: {}", identifyingContent);
                    DBObject newArrayElement = this.findArrayElement((List)parent, identifyingContent);
                    if (newArrayElement != null) {
                        LOGGER.debug("Found element in newCopy: {} ", (Object)newArrayElement);
                        oldParent = ((List)oldParent).get(field.getIndex(segment));
                        parent = newArrayElement;
                        continue;
                    }
                    LOGGER.debug("Not found element in newCopy with identifiers {}", identifyingContent);
                    continue;
                }
                if (parent instanceof DBObject) {
                    String seg = field.head(segment);
                    Object x = parent.get(seg);
                    if (x == null) {
                        fail = true;
                        break;
                    }
                    parent = x;
                    oldParent = oldParent.get(seg);
                    continue;
                }
                fail = true;
                break;
            }
            if (!fail) {
                ret = parent;
            }
        } else {
            ret = newCopy;
        }
        return ret;
    }

    public List<IField> getIdentifyingContent(List<PathAndField> identifiers, DBObject parent) {
        ArrayList<IField> values = new ArrayList<IField>(identifiers.size());
        for (PathAndField pf : identifiers) {
            Object value = this.getValue(parent, pf.getPath());
            values.add(new IField(pf.getPath(), value));
        }
        return values;
    }

    private Object getValue(Object parent, Path relpath) {
        int n = relpath.numSegments();
        for (int i = 0; i < n && (parent = ((DBObject)parent).get(relpath.head(i))) != null; ++i) {
        }
        return parent;
    }

    public List<PathAndField> getArrayIdentifiers(Path arrayElementField) {
        ArrayList<PathAndField> idPaths = new ArrayList<PathAndField>();
        MutablePath mp = new MutablePath();
        this.getArrayIdentifiers(this.md.getFieldCursor(arrayElementField), mp, idPaths, new ArrayIdCollector(){

            @Override
            public boolean isIncluded(SimpleField field) {
                List constraints = field.getConstraints();
                if (constraints != null) {
                    for (FieldConstraint x : constraints) {
                        if (!(x instanceof ArrayElementIdConstraint)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        if (idPaths.isEmpty()) {
            this.getArrayIdentifiers(this.md.getFieldCursor(arrayElementField), mp, idPaths, new ArrayIdCollector(){

                @Override
                public boolean isIncluded(SimpleField field) {
                    return field.getType().equals((Object)UIDType.TYPE);
                }
            });
        }
        return idPaths;
    }

    private void getArrayIdentifiers(FieldCursor cursor, MutablePath mp, List<PathAndField> paths, ArrayIdCollector collector) {
        if (cursor.firstChild()) {
            mp.push("x");
            do {
                FieldTreeNode fn = (FieldTreeNode)cursor.getCurrentNode();
                mp.setLast(fn.getName());
                if (fn instanceof ObjectField) {
                    this.getArrayIdentifiers(cursor, mp, paths, collector);
                    continue;
                }
                if (!(fn instanceof SimpleField) || !collector.isIncluded((SimpleField)fn)) continue;
                paths.add(new PathAndField(mp.immutableCopy(), (SimpleField)fn));
            } while (cursor.nextSibling());
            cursor.parent();
            mp.pop();
        }
    }

    private DBObject findArrayElement(List array, List<IField> identifiers) {
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            DBObject elem = (DBObject)array.get(i);
            boolean found = true;
            for (IField ifld : identifiers) {
                Object value = this.getValue(elem, ifld.getPath());
                if (value == null && ifld.getValue() == null || value != null && ifld.getValue() != null && value.equals(ifld.getValue())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return elem;
        }
        return null;
    }

    public void findInvisibleFields(DBObject dbObject) {
        MutablePath mp = new MutablePath();
        this.findInvisibleFields_dbobj(dbObject, mp);
        LOGGER.debug("Invisible fields: {} ", this.invisibleFields);
    }

    private void findInvisibleFields_obj(Object object, MutablePath path) {
        if (object instanceof DBObject) {
            this.findInvisibleFields_dbobj((DBObject)object, path);
        } else if (object instanceof List) {
            path.push(0);
            int index = 0;
            for (Object value : (List)object) {
                path.setLast(index);
                this.findInvisibleFields_obj(value, path);
                ++index;
            }
            path.pop();
        }
    }

    private void findInvisibleFields_dbobj(DBObject dbObject, MutablePath path) {
        Set fields = dbObject.keySet();
        for (String field : fields) {
            path.push(field);
            LOGGER.debug("Processing {}", (Object)path);
            Object value = dbObject.get(field);
            try {
                this.md.resolve((Path)path);
                this.findInvisibleFields_obj(value, path);
            }
            catch (Error e) {
                LOGGER.debug("Invisible field {}", (Object)path);
                this.invisibleFields.add(new IField(path.immutableCopy(), value));
            }
            path.pop();
        }
    }

    private static interface ArrayIdCollector {
        public boolean isIncluded(SimpleField var1);
    }

    public static final class PathAndField {
        private final Path path;
        private final SimpleField field;

        public PathAndField(Path path, SimpleField field) {
            this.path = path;
            this.field = field;
        }

        public Path getPath() {
            return this.path;
        }

        public SimpleField getField() {
            return this.field;
        }

        public String toString() {
            return this.path.toString();
        }
    }

    public static final class IField {
        private final Path path;
        private final Object value;

        public IField(Path p, Object value) {
            this.path = p;
            this.value = value;
        }

        public Path getPath() {
            return this.path;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.path.toString() + ":" + this.value;
        }
    }
}

