/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.redhat.lightblue.crud.CRUDDeleteResponse;
import com.redhat.lightblue.crud.CRUDOperationContext;
import com.redhat.lightblue.crud.DocCtx;
import com.redhat.lightblue.crud.Operation;
import com.redhat.lightblue.crud.mongo.DocDeleter;
import com.redhat.lightblue.crud.mongo.Translator;
import com.redhat.lightblue.interceptor.InterceptPoint;
import com.redhat.lightblue.mongo.hystrix.FindCommand;
import com.redhat.lightblue.mongo.hystrix.RemoveCommand;
import com.redhat.lightblue.util.JsonDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterateDeleter
implements DocDeleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IterateDeleter.class);
    private final Translator translator;

    public IterateDeleter(Translator translator) {
        this.translator = translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(CRUDOperationContext ctx, DBCollection collection, DBObject mongoQuery, CRUDDeleteResponse response) {
        LOGGER.debug("Computing the result set for {}", (Object)mongoQuery);
        DBCursor cursor = null;
        int docIndex = 0;
        int numDeleted = 0;
        try {
            cursor = (DBCursor)new FindCommand(collection, mongoQuery, null).execute();
            LOGGER.debug("Found {} documents", (Object)cursor.count());
            while (cursor.hasNext()) {
                DBObject document = cursor.next();
                LOGGER.debug("Retrieved doc {}", (Object)docIndex);
                Object id = document.get("_id");
                DocCtx doc = ctx.addDocument(this.translator.toJson(document));
                doc.setOriginalDocument((JsonDoc)doc);
                ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_DELETE_DOC, ctx, doc);
                WriteResult result = (WriteResult)new RemoveCommand(collection, (DBObject)new BasicDBObject("_id", id), WriteConcern.SAFE).execute();
                if (result.getN() == 1) {
                    ++numDeleted;
                    doc.setOperationPerformed(Operation.DELETE);
                }
                ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_DELETE_DOC, ctx, doc);
                ++docIndex;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        response.setNumDeleted(numDeleted);
    }
}

