/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import com.redhat.lightblue.crud.CRUDOperationContext;
import com.redhat.lightblue.crud.CRUDUpdateResponse;
import com.redhat.lightblue.crud.ConstraintValidator;
import com.redhat.lightblue.crud.DocCtx;
import com.redhat.lightblue.crud.Operation;
import com.redhat.lightblue.crud.mongo.DocUpdater;
import com.redhat.lightblue.crud.mongo.Translator;
import com.redhat.lightblue.eval.FieldAccessRoleEvaluator;
import com.redhat.lightblue.eval.Projector;
import com.redhat.lightblue.eval.Updater;
import com.redhat.lightblue.interceptor.InterceptPoint;
import com.redhat.lightblue.metadata.EntityMetadata;
import com.redhat.lightblue.metadata.PredefinedFields;
import com.redhat.lightblue.mongo.hystrix.FindCommand;
import com.redhat.lightblue.mongo.hystrix.SaveCommand;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonDoc;
import com.redhat.lightblue.util.Path;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterateAndUpdate
implements DocUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(IterateAndUpdate.class);
    private final JsonNodeFactory nodeFactory;
    private final ConstraintValidator validator;
    private final FieldAccessRoleEvaluator roleEval;
    private final Translator translator;
    private final Updater updater;
    private final Projector projector;
    private final Projector errorProjector;

    public IterateAndUpdate(JsonNodeFactory nodeFactory, ConstraintValidator validator, FieldAccessRoleEvaluator roleEval, Translator translator, Updater updater, Projector projector, Projector errorProjector) {
        this.nodeFactory = nodeFactory;
        this.validator = validator;
        this.roleEval = roleEval;
        this.translator = translator;
        this.updater = updater;
        this.projector = projector;
        this.errorProjector = errorProjector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(CRUDOperationContext ctx, DBCollection collection, EntityMetadata md, CRUDUpdateResponse response, DBObject query) {
        LOGGER.debug("iterateUpdate: start");
        LOGGER.debug("Computing the result set for {}", (Object)query);
        DBCursor cursor = null;
        int docIndex = 0;
        int numFailed = 0;
        try {
            ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_UPDATE_RESULTSET, ctx);
            cursor = (DBCursor)new FindCommand(collection, query, null).execute();
            LOGGER.debug("Found {} documents", (Object)cursor.count());
            ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_UPDATE_RESULTSET, ctx);
            while (cursor.hasNext()) {
                DBObject document = cursor.next();
                boolean hasErrors = false;
                LOGGER.debug("Retrieved doc {}", (Object)docIndex);
                DocCtx doc = ctx.addDocument(this.translator.toJson(document));
                doc.setOutputDocument(doc.copy());
                if (this.updater.update(doc.getOutputDocument(), md.getFieldTreeRoot(), Path.EMPTY)) {
                    LOGGER.debug("Document {} modified, updating", (Object)docIndex);
                    PredefinedFields.updateArraySizes((JsonNodeFactory)this.nodeFactory, (JsonDoc)doc.getOutputDocument());
                    LOGGER.debug("Running constraint validations");
                    this.validator.clearErrors();
                    this.validator.validateDoc(doc.getOutputDocument());
                    List errors = this.validator.getErrors();
                    if (errors != null && !errors.isEmpty()) {
                        ctx.addErrors((Collection)errors);
                        hasErrors = true;
                        LOGGER.debug("Doc has errors");
                    }
                    if ((errors = (List)this.validator.getDocErrors().get(doc.getOutputDocument())) != null && !errors.isEmpty()) {
                        doc.addErrors((Collection)errors);
                        hasErrors = true;
                        LOGGER.debug("Doc has data errors");
                    }
                    if (!hasErrors) {
                        List paths = this.roleEval.getInaccessibleFields_Update(doc.getOutputDocument(), (JsonDoc)doc);
                        LOGGER.debug("Inaccesible fields during update={}" + paths);
                        if (paths != null && !paths.isEmpty()) {
                            doc.addError(Error.get((String)"update", (String)"crud:update:NoFieldAccess", (String)paths.toString()));
                            hasErrors = true;
                        }
                    }
                    if (!hasErrors) {
                        try {
                            ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_UPDATE_DOC, ctx, doc);
                            DBObject updatedObject = this.translator.toBson(doc.getOutputDocument());
                            this.translator.addInvisibleFields(document, updatedObject, md);
                            WriteResult result = (WriteResult)new SaveCommand(collection, updatedObject).execute();
                            doc.setOperationPerformed(Operation.UPDATE);
                            LOGGER.debug("Number of rows affected : ", (Object)result.getN());
                            ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_UPDATE_DOC, ctx, doc);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Update exception for document {}: {}", (Object)docIndex, (Object)e);
                            doc.addError(Error.get((String)"mongo-crud:UpdateError", (String)e.toString()));
                            hasErrors = true;
                        }
                    }
                } else {
                    LOGGER.debug("Document {} was not modified", (Object)docIndex);
                }
                if (hasErrors) {
                    LOGGER.debug("Document {} has errors", (Object)docIndex);
                    ++numFailed;
                    doc.setOutputDocument(this.errorProjector.project(doc.getOutputDocument(), this.nodeFactory));
                } else if (this.projector != null) {
                    LOGGER.debug("Projecting document {}", (Object)docIndex);
                    doc.setOutputDocument(this.projector.project(doc.getOutputDocument(), this.nodeFactory));
                }
                ++docIndex;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        response.setNumUpdated(docIndex);
        response.setNumFailed(numFailed);
    }
}

