/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.redhat.lightblue.crud.CRUDOperationContext;
import com.redhat.lightblue.crud.DocCtx;
import com.redhat.lightblue.crud.Operation;
import com.redhat.lightblue.crud.mongo.DocSaver;
import com.redhat.lightblue.crud.mongo.Translator;
import com.redhat.lightblue.eval.FieldAccessRoleEvaluator;
import com.redhat.lightblue.interceptor.InterceptPoint;
import com.redhat.lightblue.metadata.EntityMetadata;
import com.redhat.lightblue.mongo.hystrix.FindOneCommand;
import com.redhat.lightblue.mongo.hystrix.InsertCommand;
import com.redhat.lightblue.mongo.hystrix.UpdateCommand;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonDoc;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDocSaver
implements DocSaver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicDocSaver.class);
    private final FieldAccessRoleEvaluator roleEval;
    private final Translator translator;

    public BasicDocSaver(Translator translator, FieldAccessRoleEvaluator roleEval) {
        this.translator = translator;
        this.roleEval = roleEval;
    }

    @Override
    public void saveDoc(CRUDOperationContext ctx, DocSaver.Op op, boolean upsert, DBCollection collection, EntityMetadata md, DBObject dbObject, DocCtx inputDoc) {
        WriteResult result = null;
        String error = null;
        Object id = dbObject.get("_id");
        if (op == DocSaver.Op.insert || id == null && upsert) {
            result = this.insertDoc(ctx, collection, md, dbObject, inputDoc);
        } else if (op == DocSaver.Op.save && id != null) {
            LOGGER.debug("Updating doc {}" + id);
            BasicDBObject q = new BasicDBObject("_id", Translator.createIdFrom(id));
            DBObject oldDBObject = (DBObject)new FindOneCommand(collection, (DBObject)q).execute();
            if (oldDBObject != null) {
                if (md.getAccess().getUpdate().hasAccess((Collection)ctx.getCallerRoles())) {
                    JsonDoc oldDoc = this.translator.toJson(oldDBObject);
                    inputDoc.setOriginalDocument(oldDoc);
                    List paths = this.roleEval.getInaccessibleFields_Update((JsonDoc)inputDoc, oldDoc);
                    if (paths == null || paths.isEmpty()) {
                        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_UPDATE_DOC, ctx, inputDoc);
                        this.translator.addInvisibleFields(oldDBObject, dbObject, md);
                        result = (WriteResult)new UpdateCommand(collection, (DBObject)q, dbObject, upsert, upsert, WriteConcern.SAFE).execute();
                        inputDoc.setOperationPerformed(Operation.UPDATE);
                        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_UPDATE_DOC, ctx, inputDoc);
                    } else {
                        inputDoc.addError(Error.get((String)"update", (String)"crud:update:NoFieldAccess", (String)paths.toString()));
                    }
                } else {
                    inputDoc.addError(Error.get((String)"update", (String)"crud:NoAccess", (String)("update:" + md.getName())));
                }
            } else {
                result = this.insertDoc(ctx, collection, md, dbObject, inputDoc);
            }
        } else {
            LOGGER.warn("Invalid request, cannot update or insert");
            inputDoc.addError(Error.get((String)op.toString(), (String)"mongo-crud:SaveError", (String)"Invalid request"));
        }
        LOGGER.debug("Write result {}", (Object)result);
        if (result != null) {
            if (error == null) {
                error = result.getError();
            }
            if (error != null) {
                inputDoc.addError(Error.get((String)op.toString(), (String)"mongo-crud:SaveError", (String)error));
            }
        }
    }

    private WriteResult insertDoc(CRUDOperationContext ctx, DBCollection collection, EntityMetadata md, DBObject dbObject, DocCtx inputDoc) {
        LOGGER.debug("Inserting doc");
        if (!md.getAccess().getInsert().hasAccess((Collection)ctx.getCallerRoles())) {
            inputDoc.addError(Error.get((String)"insert", (String)"mongo-crud:NoAccess", (String)("insert:" + md.getName())));
        } else {
            List paths = this.roleEval.getInaccessibleFields_Insert((JsonDoc)inputDoc);
            LOGGER.debug("Inaccessible fields:{}", (Object)paths);
            if (paths == null || paths.isEmpty()) {
                try {
                    ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_INSERT_DOC, ctx, inputDoc);
                    WriteResult r = (WriteResult)new InsertCommand(collection, dbObject, WriteConcern.SAFE).execute();
                    inputDoc.setOperationPerformed(Operation.INSERT);
                    ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_INSERT_DOC, ctx, inputDoc);
                    return r;
                }
                catch (MongoException.DuplicateKey dke) {
                    LOGGER.error("saveOrInsert failed: {}", (Throwable)dke);
                    inputDoc.addError(Error.get((String)"insert", (String)"mongo-crud:Duplicate", (Throwable)dke));
                }
            } else {
                inputDoc.addError(Error.get((String)"insert", (String)"crud:insert:NoFieldAccess", (String)paths.toString()));
            }
        }
        return null;
    }
}

