/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.redhat.lightblue.crud.CRUDOperationContext;
import com.redhat.lightblue.crud.DocCtx;
import com.redhat.lightblue.crud.Operation;
import com.redhat.lightblue.crud.mongo.DocFinder;
import com.redhat.lightblue.crud.mongo.Translator;
import com.redhat.lightblue.interceptor.InterceptPoint;
import com.redhat.lightblue.mongo.hystrix.FindCommand;
import com.redhat.lightblue.util.JsonDoc;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDocFinder
implements DocFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicDocFinder.class);
    private final Translator translator;

    public BasicDocFinder(Translator translator) {
        this.translator = translator;
    }

    @Override
    public long find(CRUDOperationContext ctx, DBCollection coll, DBObject mongoQuery, DBObject mongoProjection, DBObject mongoSort, Long from, Long to) {
        LOGGER.debug("Submitting query");
        DBCursor cursor = (DBCursor)new FindCommand(coll, mongoQuery, mongoProjection).execute();
        LOGGER.debug("Query evaluated");
        if (mongoSort != null) {
            cursor = cursor.sort(mongoSort);
            LOGGER.debug("Result set sorted");
        }
        long ret = cursor.size();
        LOGGER.debug("Applying limits: {} - {}", (Object)from, (Object)to);
        if (from != null) {
            cursor.skip(from.intValue());
        }
        if (to != null) {
            cursor.limit(to.intValue() - (from == null ? 0 : from.intValue()) + 1);
        }
        LOGGER.debug("Retrieving results");
        List mongoResults = cursor.toArray();
        LOGGER.debug("Retrieved {} results", (Object)mongoResults.size());
        List<JsonDoc> jsonDocs = this.translator.toJson(mongoResults);
        ctx.addDocuments(jsonDocs);
        for (DocCtx doc : ctx.getDocuments()) {
            doc.setOperationPerformed(Operation.FIND);
            ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_FIND_DOC, ctx, doc);
        }
        LOGGER.debug("Translated DBObjects to json");
        return ret;
    }
}

