/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import com.redhat.lightblue.crud.CRUDDeleteResponse;
import com.redhat.lightblue.crud.CRUDOperationContext;
import com.redhat.lightblue.crud.mongo.DocDeleter;
import com.redhat.lightblue.mongo.hystrix.RemoveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDocDeleter
implements DocDeleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicDocDeleter.class);

    @Override
    public void delete(CRUDOperationContext ctx, DBCollection collection, DBObject mongoQuery, CRUDDeleteResponse response) {
        LOGGER.debug("Removing docs with {}", (Object)mongoQuery);
        WriteResult result = (WriteResult)new RemoveCommand(collection, mongoQuery).execute();
        LOGGER.debug("Removal complete, write result={}", (Object)result);
        response.setNumDeleted(result.getN());
    }
}

